set -o xtrace
echo "CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES"

METHOD_LST=(
    "predicatt"
    "transformer_attribution"
    "rollout"
    "full_lrp"
    "lrp_last_layer"
    "attn_last_layer"
    "attn_gradcam"
)

MODEL_TYPE_LST=(
    "vit-b"
    "vit-l"
)


for MODEL_TYPE in ${MODEL_TYPE_LST[@]}; do
    for METHOD in ${METHOD_LST[@]}; do
        echo ">>>>>>> $MODEL_TYPE - $METHOD"
        PYTHONPATH=. python scripts/benchmark_memory.py --model_type "$MODEL_TYPE" --method "$METHOD"
    done
done


for MODEL_TYPE in ${MODEL_TYPE_LST[@]}; do
    for METHOD in ${METHOD_LST[@]}; do
        echo ">>>>>>> $MODEL_TYPE - $METHOD"
        PYTHONPATH=. python scripts/benchmark_runtime.py --model_type "$MODEL_TYPE" --method "$METHOD"
    done
done

