set -o xtrace
echo "CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES"
echo "IMAGENET_SEGMENTATION_PATH=$IMAGENET_SEGMENTATION_PATH"
echo "IMAGENET_PATH=$IMAGENET_PATH"

METHOD_LST=(
    "predmap15_softmax_classes_batched_layer"
    "transformer_attribution"
    "rollout"
    "full_lrp"
    "lrp_last_layer"
    "attn_last_layer"
    "attn_gradcam"
)

SUBSET_FLAG=""

for METHOD in ${METHOD_LST[@]}; do
    echo ">>>>>>> $METHOD"
    PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class target --method $METHOD
    PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD --neg True
    PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD
    PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class top --method $METHOD
    PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD --neg True
    PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD
done

METHOD=predmap15_softmax_classes_batched_layer
LAYER=10
echo ">>>>>>> $METHOD"
PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class target --method $METHOD --layer $LAYER
PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD$LAYER --neg True
PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD$LAYER
PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class top --method $METHOD --layer $LAYER
PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD$LAYER --neg True
PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD$LAYER

for METHOD in ${METHOD_LST[@]}; do
    echo ">>>>>>> $METHOD"
    PYTHONPATH=. python baselines/ViT/imagenet_seg_eval.py --imagenet-seg-path "$IMAGENET_SEGMENTATION_PATH" --method $METHOD
done

PYTHONPATH=. python baselines/ViT/imagenet_seg_eval.py --imagenet-seg-path "$IMAGENET_SEGMENTATION_PATH" --method predmap15_softmax_classes_batched_layer --layer 10
