set -o xtrace
echo "CUDA_VISIBLE_DEVICES=$CUDA_VISIBLE_DEVICES"
echo "IMAGENET_SEGMENTATION_PATH=$IMAGENET_SEGMENTATION_PATH"
echo "IMAGENET_PATH=$IMAGENET_PATH"

METHOD_LST=(
    "predmap15_ablation_mean_attnmap_only"
    "predmap15_ablation_weighted_attnmap"
    "predmap15_ablation_predmap"
    # "predmap15_ablation_mean"
)
LAYER_LST=(11 10)
SUBSET_FLAG=""

for LAYER in ${LAYER_LST[@]}; do
    for METHOD in ${METHOD_LST[@]}; do
        echo ">>>>>>> $METHOD - $LAYER"
        PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class target --method $METHOD --layer $LAYER
        PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD$LAYER --neg True
        PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class target --method $METHOD$LAYER
        PYTHONPATH=. python baselines/ViT/generate_visualizations_optimized.py --dataset-type imagenet --imagenet-validation-path "$IMAGENET_PATH" $SUBSET_FLAG --batch-size 1 --vis-class top --method $METHOD --layer $LAYER
        PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD$LAYER --neg True
        PYTHONPATH=. python baselines/ViT/pertubation_eval_from_hdf5_optimized.py --dataset-name imagenet --imagenet-validation-path "$IMAGENET_PATH" --batch-size 4 --vis-class top --method $METHOD$LAYER
    done
done

for METHOD in ${METHOD_LST[@]}; do
    for LAYER in ${LAYER_LST[@]}; do
        echo ">>>>>>> $METHOD - $LAYER"
        PYTHONPATH=. python baselines/ViT/imagenet_seg_eval.py --imagenet-seg-path "$IMAGENET_SEGMENTATION_PATH" --method $METHOD --layer $LAYER
    done
done
