import faiss
import numpy as np
from torch.utils.data import DataLoader
from .strategy import Strategy
import pickle
from scipy.spatial.distance import cosine
import sys
import gc
from scipy.linalg import det
from scipy.linalg import pinv as inv
from copy import copy as copy
from copy import deepcopy as deepcopy
import torch
from torch import nn
from torch.autograd import Variable
#import resnet
#import vgg
import torch.optim as optim
import pdb
from torch.nn import functional as F
import argparse
import torch.nn as nn
from collections import OrderedDict
from scipy import stats
import time
import numpy as np
import scipy.sparse as sp
from itertools import product
from sklearn.base import BaseEstimator, ClusterMixin, TransformerMixin
from sklearn.metrics.pairwise import euclidean_distances
from sklearn.metrics.pairwise import pairwise_distances_argmin_min
from sklearn.utils.extmath import row_norms, squared_norm, stable_cumsum
from sklearn.utils.sparsefuncs_fast import assign_rows_csr
from sklearn.utils.sparsefuncs import mean_variance_axis
from sklearn.utils.validation import _num_samples
from sklearn.utils import check_array
from sklearn.utils import gen_batches
from sklearn.utils import check_random_state
from sklearn.utils.validation import check_is_fitted
from sklearn.utils.validation import FLOAT_DTYPES
from sklearn.metrics.pairwise import rbf_kernel as rbf
#from sklearn.externals.six import string_types
from sklearn.exceptions import ConvergenceWarning
from sklearn.metrics import pairwise_distances

import random


class BadgeSamplingKmeansGPU(Strategy):
	def __init__(self, X, Y, idxs_lb, net, handler, args):
		super(BadgeSamplingKmeansGPU, self).__init__(X, Y, idxs_lb, net, handler, args)

	def query(self, n):
		idxs_unlabeled = np.arange(self.n_pool)[~self.idxs_lb]
		random.shuffle(idxs_unlabeled)
		
		gradEmbedding = self.get_grad_embedding(self.X[idxs_unlabeled], self.Y.numpy()[idxs_unlabeled]).numpy()
		
		cluster_learner = FaissKmeans(n_clusters = n, gpu = True)
		cluster_learner.fit(gradEmbedding)
		
		dis, q_idxs = cluster_learner.predict(gradEmbedding)
		q_idxs = q_idxs.T[0]
		return idxs_unlabeled[q_idxs]


class FaissKmeans:
	def __init__(self, n_clusters=8, gpu=True, n_init=10, max_iter=300):
		self.n_clusters = n_clusters
		self.n_init = n_init
		self.max_iter = max_iter
		self.kmeans = None
		self.cluster_centers_ = None
		self.inertia_ = None
		self.gpu = gpu

	def fit(self, X):
		self.kmeans = faiss.Kmeans(d=X.shape[1],
								   k=self.n_clusters,
								   niter=self.max_iter,
								   nredo=self.n_init,
								   gpu = self.gpu)
		self.kmeans.train(X.astype(np.float32))
		self.cluster_centers_ = self.kmeans.centroids
		self.inertia_ = self.kmeans.obj[-1]

	def predict(self, X):
		D, I = self.kmeans.index.search(X.astype(np.float32), 1)
		return D, I
