## Installation

We use `conda` environment manager to install the packages. Depending on your machine, you may create a new environment.

### CPU Version

For the CPU version, we currently do not have an automated installation script. You can install the packages manually by running the following commands:

```bash
conda create -y -n relfm-v1.0 python=3.9
conda activate relfm-v1.0
conda install -y tqdm pillow numpy matplotlib scipy
pip install ipdb ipython jupyter jupyterlab gdown opencv-python termcolor natsort
pip install torch==1.9.0 torchvision==0.10.0 torchaudio==0.9.0
pip install escnn
pip install wandb
```

> :warning: **Note**: This has been tested on Mac M1 machine.

### GPU Version


Run the following command to create an environment:
```bash
sbatch jobscripts/create_gpu_env.job
```

Once it is created, you can activate it and install other packages.

To activate the environment, run the following command (on your login node):
```sh
module load 2021
module load Anaconda3/2021.05
conda activate relfm-v1.0
```

To check if the packages are installed correctly, run the following command:
```sh
python setup/check_packages.py
```

<!-- Once the environment `relfm-v1.0` is created, activate it and install other packages.
Please follow the same instructions as above except use the apt CUDA version while installing `torch`.

For e.g., using CUDA 10.1, use:
```bash
pip install torch==1.8.1+cu101 torchvision==0.9.1+cu101 torchaudio==0.8.1 -f https://download.pytorch.org/whl/torch_stable.html
```
 -->

## Updating the environment

Suppose you want to install an additional package, say `termcolor`, you need to add it to the jobscript and run it again.
```bash
(old) pip install .....some packages.....
(new) pip install .....some packages..... termcolor
```
Then, run the jobscript again.
```bash
sbatch jobscripts/create_gpu_env.job
```


> Tip: To use the conda environment on the login node, you will need to run the following commands before activating the environment:

```bash
module purge
module load 2021
module load Anaconda3/2021.05
conda activate relfm-v1.0
```


## Setting up W&B

```bash
# make sure you have the environment activated
# make sure you have installed wandb
pip install wandb

wandb login
# after this, enter the API key from settings of your account on W&B
```