# Copyright 2024
# [ANONYMIZED_INSTITUTION],
# [ANONYMIZED_FACULTY],
# [ANONYMIZED_DEPARTMENT]
#
# Authors:
# AUTHOR_1 (author1@example.com)
# AUTHOR_2 (author2@example.com)
#
# Code generation tools and workflows:
# First versions of this code were potentially generated
# with the help of AI writing assistants including
# GitHub Copilot, ChatGPT, Microsoft Copilot, Google Gemini.
# Afterwards, the generated segments were manually reviewed and edited.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Tests for the embeddings path manager."""

import logging
import pathlib

from topollm.path_management.embeddings import protocol
from topollm.path_management.validate_path_part import validate_path_part


def validate_path(
    path: pathlib.Path,
) -> None:
    """Validate the path."""
    assert isinstance(  # noqa: S101 - pytest assertion
        path,
        pathlib.Path,
    )

    assert validate_path_part(  # noqa: S101 - pytest assertion
        path_part=str(object=path),
    )


class TestEmbeddingsPathManager:
    """Tests for the embeddings path manager."""

    def test_data_dir(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.data_dir
        logger_fixture.info(
            "data_dir:\n%s",
            result,
        )

        validate_path(
            path=result,
        )

    def test_array_dir_absolute_path(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.array_dir_absolute_path
        logger_fixture.info(
            "array_dir_absolute_path:\n%s",
            result,
        )

        validate_path(
            path=result,
        )

    def test_metadata_dir_absolute_path(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.metadata_dir_absolute_path
        logger_fixture.info(
            "metadata_dir_absolute_path:\n%s",
            result,
        )

        validate_path(
            path=result,
        )

    def test_get_global_estimate_save_path(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.get_global_estimate_save_path()
        logger_fixture.info(
            "global_estimate_save_path:\n%s",
            result,
        )

        validate_path(
            path=result,
        )

    def test_get_local_estimates_pointwise_array_save_path(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.get_local_estimates_pointwise_array_save_path()
        logger_fixture.info(
            "local_estimates_pointwise_array_save_path:\n%s",
            result,
        )

        validate_path(
            path=result,
        )

    def test_get_local_estimates_pointwise_meta_save_path(
        self,
        embeddings_path_manager: protocol.EmbeddingsPathManager,
        logger_fixture: logging.Logger,
    ) -> None:
        result: pathlib.Path = embeddings_path_manager.get_local_estimates_pointwise_meta_save_path()
        logger_fixture.info(
            "local_estimates_pointwise_meta_save_path:\n%s",
            result,
        )

        validate_path(
            path=result,
        )
