#!/bin/bash

set -e # Stop script at the first error

# https://hydra.cc/docs/tutorials/basic/running_your_app/multi-run/

echo "TOPO_LLM_REPOSITORY_BASE_PATH=${TOPO_LLM_REPOSITORY_BASE_PATH}"

PYTHON_SCRIPT_NAME="run_single_setup_load_saved_perplexity_and_local_estimates_and_analyse.py"
RELATIVE_PYTHON_SCRIPT_PATH="topollm/model_inference/perplexity/saved_perplexity_processing/align_and_analyse/${PYTHON_SCRIPT_NAME}"
ABSOLUTE_PYTHON_SCRIPT_PATH="${TOPO_LLM_REPOSITORY_BASE_PATH}/${RELATIVE_PYTHON_SCRIPT_PATH}"

# ==================================================== #
# Select the parameters here

datas=(
    # "iclr_2024_submissions_test"
    # "iclr_2024_submissions_train"
    # "iclr_2024_submissions_validation"
    "multiwoz21_test"
    "multiwoz21_train"
    "multiwoz21_validation"
    "one-year-of-tsla-on-reddit_test"
    "one-year-of-tsla-on-reddit_train"
    "one-year-of-tsla-on-reddit_validation"
    # "sgd_test"
    # "sgd_train"
    # "sgd_validation"
    # "wikitext_test"
    # "wikitext_train"
    # "wikitext_validation"
)

DATA_LIST=$(IFS=,; echo "${datas[*]}")
echo "DATA_LIST: $DATA_LIST"

language_models=(
    # "roberta-base"
    # "model-roberta-base_task-masked_lm_iclr_2024_submissions-train-5000-ner_tags_ftm-standard_lora-None_5e-05-linear-0.01-5"
    # "model-roberta-base_task-masked_lm_multiwoz21-train-10000-ner_tags_ftm-standard_lora-None_5e-05-linear-0.01-5"
    # "model-roberta-base_task-masked_lm_one-year-of-tsla-on-reddit-train-10000-ner_tags_ftm-standard_lora-None_5e-05-linear-0.01-5"
    # "model-roberta-base_task-masked_lm_wikitext-train-10000-ner_tags_ftm-standard_lora-None_5e-05-linear-0.01-5"
    "model-roberta-base_task-masked_lm_multiwoz21-train-10000-ner_tags_ftm-standard_lora-None_5e-05-constant-0.01-50"
    "model-roberta-base_task-masked_lm_one-year-of-tsla-on-reddit-train-10000-ner_tags_ftm-standard_lora-None_5e-05-constant-0.01-50"
)



LAYER_INDICES_LIST="[-1]"
# LAYER_INDICES_LIST="[-5]"

EMBEDDINGS_DATA_PREP_NUM_SAMPLES="30000"

ADDITIONAL_OVERRIDES=""

# Note: In the dimension experiments, we usually set `add_prefix_space=False` 
# ADDITIONAL_OVERRIDES+=" tokenizer.add_prefix_space=True"


# ==================================================== #

# For the lancher, we can use the following options:
# `hydra/launcher=basic`
# `hydra/launcher=joblib`

# Iterate over each language model
for language_model in "${language_models[@]}"; do
    if [ "$language_model" == "roberta-base" ]; then
        # Checkpoints for roberta-base
        CHECKPOINTS="0"
    else
        # Define checkpoints for other models here
        # Adjust the checkpoints as per your requirements for other models
        #
        # CHECKPOINTS="400,1200,2000,2800"

        CHECKPOINTS_ARRAY=(
            "400"
            "3200"
            "6000"
            "8800"
            "11600"
            "14400"
            "17200"
            "20000"
            "22800"
            "25600"
            "28400"
            "31200"
        )

        CHECKPOINTS=$(IFS=,; echo "${CHECKPOINTS_ARRAY[*]}")
    fi

    # Run the Python script with the selected checkpoints for the current model
    echo "Running analysis for model: $language_model with checkpoints: $CHECKPOINTS"
    
    poetry run python3 $ABSOLUTE_PYTHON_SCRIPT_PATH \
        --multirun \
        hydra/launcher=joblib \
        data=$DATA_LIST \
        language_model=$language_model \
        ++language_model.checkpoint_no=$CHECKPOINTS \
        embeddings.embedding_extraction.layer_indices=$LAYER_INDICES_LIST \
        embeddings_data_prep.sampling.num_samples=$EMBEDDINGS_DATA_PREP_NUM_SAMPLES \
        +embeddings_data_prep.sampling.sampling_mode="take_first" \
        $ADDITIONAL_OVERRIDES
done

# Exit with the return code of the last command
exit $?
