import os
import json
import html
import graphviz
from tqdm import tqdm


def main():
    with open("evaluate/raw/triple.json", "r") as f:
        all_chunk_data = json.load(f)
    with open("evaluate/selection/global_idx_test.json", "r") as f:
        global_idx_test = json.load(f)

    global_idx_list = [idx for cate_idx_list in global_idx_test.values() for idx in cate_idx_list]
    global_to_local = {item["idx"]: enum_idx for enum_idx, item in enumerate(all_chunk_data)}
    triple_local_idx_list = [global_to_local[idx] for idx in global_idx_list]

    visual_dir = f"visual/graphviz_test"
    if not os.path.exists(visual_dir):
        os.makedirs(visual_dir)

    for enum_idx, idx in tqdm(enumerate(triple_local_idx_list), total=len(triple_local_idx_list), desc="Drawing"):
        filename = os.path.join(visual_dir, f"{enum_idx}")
        if os.path.exists(filename):
            continue

        item = all_chunk_data[idx]
        g = graphviz.Digraph(f"{enum_idx}", filename=os.path.join(visual_dir, f"{enum_idx}.gv"))
        g.attr(rankdir='LR', nodesep='0.5', ranksep='0.75', splines='true')
        g.node_attr.update(width='0.5', height='0.3')
        for triple in item['triple']:
            src = html.escape(triple['Source'])
            tgt = html.escape(triple['Target'])
            rel = html.escape(triple['Relationship'])
            g.node(src, label=src)
            g.node(tgt, label=tgt)
            g.edge(src, tgt, label=rel)
        g.render(filename=filename, format='png', view=False)


if __name__ == '__main__':
    main()
