import os
import json


def get_chunk_data(base_dir):
    all_chunk_data = []
    chunk_dir = os.path.join(base_dir, "chunks")
    num_chunks = len(os.listdir(chunk_dir))
    for chunk_idx in range(num_chunks):
        file_name = os.path.join(chunk_dir, f"chunk_{chunk_idx}.json")
        with open(file_name, "r") as f:
            all_chunk_data += json.load(f)
    idx_dict = {item['idx']: enum_idx for enum_idx, item in enumerate(all_chunk_data)}
    return all_chunk_data, idx_dict

