def get_empty_prompt(annotation):
    prompt = (
        'You are a helpful question answering assistant. '
        'Your task is to answer multiple-choice questions based on specific requirements. \n'
    )
    prompt += (
        'No information is provided. You must rely on your own knowledge to answer questions later. \n'
        '\n'
    )
    prompt += get_question(annotation)

    return prompt


def get_wiki_prompt(data, annotation):
    page_data = data['webpages'][0]
    page_title = page_data.get('page_title', 'Unknown Title')
    page_desc = page_data.get('clean_page_description', 'Not provided.')
    image_ref_desc = data.get('image_ref_desc', 'Not provided.')

    prompt = (
        'You are a helpful question answering assistant. '
        'Your task is to answer multiple-choice questions based on specific requirements. \n'
    )
    prompt += (
        'The following text is from a Wikipedia page. You will need to answer questions based on this text later. \n'
        f'- Page Title: {page_title}\n'
        f'- Page Description: {page_desc}\n'
        f'- Diagram Description: {image_ref_desc}\n'
        '\n'
    )
    prompt += get_question(annotation)

    return prompt


def get_triple_prompt(triple, annotation):
    triple_text = "\n".join(f"[{t['Source']}, {t['Relationship']}, {t['Target']}]" for t in triple)

    prompt = (
        'You are a helpful question answering assistant. '
        'Your task is to answer multiple-choice questions based on specific requirements. \n'
    )
    prompt += (
        'The following text is extracted from a diagram. You will need to answer questions based on this text later. \n'
        f'{triple_text}\n'
        '\n'
    )
    prompt += get_question(annotation)

    return prompt


def get_question(anno):
    question = (
        "Here are four multiple-choice questions: \n"
        f"Recognition: \n{anno['Recognition']['Question']}\n{anno['Recognition']['Options']}\n"
        f"Understanding: \n{anno['Understanding']['Question']}\n{anno['Understanding']['Options']}\n"
        f"Grounding: \n{anno['Grounding']['Question']}\n{anno['Grounding']['Options']}\n"
        f"Reasoning: \n{anno['Reasoning']['Question']}\n{anno['Reasoning']['Options']}\n"
        "Each question contains four answers (A, B, C, D), and you need to choose the best one. "
        'You must output your result in the following JSON-like format:\n'
        '{'
        '  "Recognition": "X",'
        '  "Understanding": "X",'
        '  "Grounding": "X",'
        '  "Reasoning": "X"'
        '}\n'
    )
    return question
