def get_empty_prompt(annotation, rev=False):
    options = annotation['Options']
    if rev:
        options = dict(zip("ABCD", [options[k] for k in "DCBA"]))

    prompt = (
        'Based on your own knowledge, answer the question: \n'
        f"{annotation['Question']}\n{options}\n"
        "Do not provide any explanations. Only output A/B/C/D. \n"
    )
    return prompt


def get_wiki_prompt(data, annotation, rev=False):
    page_data = data['webpages'][0]
    page_title = page_data.get('page_title', 'Unknown Title')
    page_desc = page_data.get('clean_page_description', 'Not provided.')
    image_ref_desc = data.get('image_ref_desc', 'Not provided.')
    options = annotation['Options']
    if rev:
        options = dict(zip("ABCD", [options[k] for k in "DCBA"]))

    prompt = (
        'The following text is from a Wikipedia page. \n'
        f'- Page Title: {page_title}\n'
        f'- Page Description: {page_desc}\n'
        f'- Diagram Description: {image_ref_desc}\n'
        '\n'
    )
    prompt += (
        'Based on the text above, answer the question: \n'
        f"{annotation['Question']}\n{options}\n"
        "Do not provide any explanations. Only output A/B/C/D. \n"
    )
    return prompt


def get_triple_prompt(triple, annotation, rev=False):
    triple_text = "\n".join(f"[{t['Source']}, {t['Relationship']}, {t['Target']}]" for t in triple)
    options = annotation['Options']
    if rev:
        options = dict(zip("ABCD", [options[k] for k in "DCBA"]))

    prompt = (
        'The following text is extracted from a diagram. \n'
        f'{triple_text}\n'
        '\n'
    )
    prompt += (
        'Based on the text above, answer the question: \n'
        f"{annotation['Question']}\n{options}\n"
        "Do not provide any explanations. Only output A/B/C/D. \n"
    )
    return prompt
