import os
import io
import json
import torch
import argparse


def download_model(args):
    if args.lvlm_path == "mistralai/Pixtral-12B-2409":
        from huggingface_hub import snapshot_download

        model_path = os.path.join(args.models_folder, 'mistral_models/Pixtral')
        if not os.path.exists(model_path):
            os.makedirs(model_path)
        snapshot_download(repo_id=args.lvlm_path,
                          allow_patterns=["params.json", "consolidated.safetensors", "tekken.json"],
                          local_dir=model_path)


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--func', type=str, default="download_model")
    parser.add_argument('--data_folder', type=str, default="../../Datasets")
    parser.add_argument('--lvlm_path', type=str, default="mistralai/Pixtral-12B-2409")
    parser.add_argument('--models_folder', type=str, default="../../Models")
    parser.add_argument('--max_data', type=int, default=-1)
    args = parser.parse_args()

    if args.func == "download_model":
        download_model(args)
