import re
import json


def normalize_triple(triple_str):
    triple_list = []
    pattern = r'"(\d+)":\s*\{\s*"Source":\s*"([^"]+)",\s*"Relationship":\s*"([^"]+)",\s*"Target":\s*"([^"]+)"\s*\}'
    matches = re.finditer(pattern, triple_str)

    for match in matches:
        source, relationship, target = match.group(2), match.group(3), match.group(4)
        if all('\\u' not in json.dumps(item) for item in [source, relationship, target]):
            triple_list.append({"Source": source, "Relationship": relationship, "Target": target})
    unique_triple_list = [dict(t) for t in {tuple(triple.items()) for triple in triple_list}]

    return unique_triple_list
