import os
import time
import json
import torch
import graphviz
import argparse
from tqdm import tqdm
from datetime import datetime


def main(args):
    output_dir = os.path.join(os.getcwd(), f"../output/synthesis/{args.lvlm}_{args.use_wiki_text}")

    all_chunk_data = []
    chunk_dir = os.path.join(output_dir, "chunks")
    num_chunks = len(os.listdir(chunk_dir))
    for chunk_idx in range(num_chunks):
        file_name = os.path.join(chunk_dir, f"chunk_{chunk_idx}.json")
        with open(file_name, "r") as f:
            all_chunk_data += json.load(f)
    idx_list = eval(f"list(range(len(all_chunk_data)))[{args.slice}]") if ":" in args.slice else [idx for idx in eval(args.slice)]

    ### Drawing synthetic diagrams
    visual_dir = os.path.join(output_dir, "visual")
    if not os.path.exists(visual_dir):
        os.mkdir(visual_dir)
    for idx in tqdm(idx_list, total=len(idx_list), desc="Drawing synthetic diagrams"):
        item = all_chunk_data[idx]
        g = graphviz.Digraph(f"{item['idx']}", filename=os.path.join(visual_dir, f"{item['idx']}.gv"))
        g.attr(rankdir='LR', nodesep='0.5', ranksep='0.75', splines='true')
        g.node_attr.update(width='0.5', height='0.3')
        for triple in item['triple']:
            g.node(triple['Source'], label=triple['Source'])
            g.node(triple['Target'], label=triple['Target'])
            g.edge(triple['Source'], triple['Target'], label=triple['Relationship'])
        g.render(filename=os.path.join(visual_dir, f"{item['idx']}"), format='png', view=False)


if __name__ == '__main__':
    parser = argparse.ArgumentParser(description='')
    parser.add_argument('--lvlm', type=str, default="molmo", help="[molmo, llama]")
    parser.add_argument('--use_wiki_text', type=str, default='wiki', help="[wiki, no-wiki]")
    parser.add_argument('--slice', type=str, default="")
    args = parser.parse_args()

    print("########## Information ##########")
    print(f"Starting time: {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}")

    main(args)
    print(f"Ending time: {datetime.now().strftime('%Y-%m-%d %H:%M:%S')}")
