import re


def normalize_tag(tag_str):
    try:
        match = re.search(r'"Domain"\s*:\s*"([^"]+)"\s*,\s*"Type"\s*:\s*"([^"]+)"', tag_str)
        tag = {"Domain": match.group(1), "Type": match.group(2)}
    except Exception as e:
        return None, str(e)

    if "Domain" not in tag or not isinstance(tag["Domain"], str):
        return None, "The 'Domain' field is missing or not a string. "

    if "Type" not in tag or not isinstance(tag["Type"], str):
        return None, "The 'Type' field is missing or not a string. "

    return tag, None

