import os
import re
import json
import pickle
import numpy as np
from fixed_variables import *
from utils import *


def length(text):
    text_str = str(text)
    return len(text_str.split())


def e_option():
    with open("pkl/data_test.pkl", 'rb') as file:
        data_test = pickle.load(file)

    for question in questions:
        print(f"\n# {question}: ")
        total_cor_len = 0
        total_wro_len = 0
        total_question_len = 0
        for item in data_test:
            total_question_len += length(item['QAs'][question]['Question'])
            ans = item['QAs'][question]['Answer']
            for opt, opt_str in item['QAs'][question]['Options'].items():
                if opt == ans:
                    total_cor_len += length(opt_str)
                else:
                    total_wro_len += length(opt_str)
        print(f"Average length of questions: {total_question_len / len(data_test):.2f}")
        print(f"Average length of correct options: {total_cor_len / len(data_test):.2f}")
        print(f"Average length of wrong options: {total_wro_len / (len(data_test) * 3):.2f}")


if __name__ == '__main__':
    e_option()

