cd YOUR_ROOT_PATH/MLLM

RUN_NAME="Merged_COCO_Flickr30K_NoCaps_WHOOPS"
NUM_GPUS=8
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_bi_512_2e_ls1_beta95_0.4/last_4145"
FACTORIZED=1
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_uni_bi_512_2e_ls1_beta95/last_4145"
# FACTORIZED=0

if [ $FACTORIZED -eq 1 ]
then
    RUN_NAME="ZS/${RUN_NAME}_factorized"
    FACTORIZED_COMMAND="--expand_vocab factorized --factorized_linear_mlp"
else
    RUN_NAME="ZS/${RUN_NAME}_direct"
    FACTORIZED_COMMAND=""
fi

LOG_PATH="YOUR_ROOT_PATH/MLLM/logs/evaluation/$RUN_NAME.log"
echo "Factorized: $Factorized" > $LOG_PATH
date | tee -a $LOG_PATH
echo "RUN_NAME: $RUN_NAME, LOG_PATH: $LOG_PATH, NUM_GPUS: $NUM_GPUS, CHECKPOINT_PATH: $CHECKPOINT_PATH, FACTORIZED: $FACTORIZED" | tee -a $LOG_PATH

CUDA_VISIBLE_DEVICES=0 python src/evaluation/eval_vllm.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name COCO --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
CUDA_VISIBLE_DEVICES=1 python src/evaluation/eval_vllm.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name Flickr30K --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
CUDA_VISIBLE_DEVICES=2 python src/evaluation/eval_vllm.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name NoCaps --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
CUDA_VISIBLE_DEVICES=3 python src/evaluation/eval_vllm.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name "WHOOPS-Caption" --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &

wait

date | tee -a $LOG_PATH