cd YOUR_ROOT_PATH/MLLM

DATASET_NAME="Merged_MathVista"
NUM_GPUS=8
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_bi_512_2e_ls1_beta95_0.4/last_4145"
FACTORIZED=1
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_uni_bi_512_2e_ls1_beta95/last_4145"
# FACTORIZED=0

if [ $FACTORIZED -eq 1 ]
then
    RUN_NAME="ZS_CoT/${DATASET_NAME}_factorized"
    FACTORIZED_COMMAND="--expand_vocab factorized --factorized_linear_mlp"
else
    RUN_NAME="ZS_CoT/${DATASET_NAME}_direct"
    FACTORIZED_COMMAND=""
fi

LOG_PATH="YOUR_ROOT_PATH/MLLM/logs/evaluation/$RUN_NAME.log"
echo "Factorized: $Factorized" > $LOG_PATH
date | tee -a $LOG_PATH
echo "RUN_NAME: $RUN_NAME, LOG_PATH: $LOG_PATH, NUM_GPUS: $NUM_GPUS, CHECKPOINT_PATH: $CHECKPOINT_PATH, FACTORIZED: $FACTORIZED" | tee -a $LOG_PATH

for i in $(seq 0 $((NUM_GPUS - 1)))
do
    CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_cot.py --template_index $i --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --prompt_setting zero_shot_cot_choices_ppl --from_hf --use_lora --dataset_name MathVista_MultiChoice --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
done

wait

for i in $(seq 0 $((NUM_GPUS - 1)))
do
    CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_cot.py --template_index $i --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name MathVista_OpenEnded --prompt_setting zero_shot_cot --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
done

wait

date | tee -a $LOG_PATH