date

cd YOUR_ROOT_PATH/MLLM

RUN_NAME="Merged_Test"
NUM_GPUS=8
CHECKPOINT_PATH_LIST=(
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_OIv4-IC_factorized_mlp_uni/last_1368"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_OIv4-IC_factorized_mlp_bi/last_1368"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_OIv4-IC_factorized_mlp_uni_bi/last_1368"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_bi_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_OIv4_factorized_mlp_uni_bi_remove_des/last_3781"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_OIv4_factorized_mlp_uni_bi_remove_related/last_1209"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_WITv4-IC_factorized_mlp_uni_bi/last_1692"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_WITv4_factorized_mlp_uni_bi/last_7482"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_WITv4-concrete-strict_factorized_mlp_uni_bi/last_4227"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_WITv4_factorized_mlp_uni_bi_remove_des/last_4001"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_data_WITv4_factorized_mlp_uni_bi_remove_related/last_1334"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_bi_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_bi_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_512_2e_ls1_beta95_bi/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_bi_512_2e_ls1_beta95/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_bi_512_2e_ls1_beta95_0_1/last_4145"
    "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_bi_512_2e_ls1_beta95_1_0/last_4145"
)
FACTORIZED=1
# CHECKPOINT_PATH_LIST=(
#     "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_uni_512_2e_ls1_beta95/last_4145"
#     "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_bi_512_2e_ls1_beta95/last_4145"
#     "YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_uni_bi_512_2e_ls1_beta95/last_4145"
# )
# FACTORIZED=0

if [ $FACTORIZED -eq 1 ]
then
    RUN_NAME="ZS/${RUN_NAME}_factorized"
else
    RUN_NAME="ZS/${RUN_NAME}_direct"
fi
LOG_PATH="YOUR_ROOT_PATH/MLLM/logs/evaluation_sft/$RUN_NAME.log"

echo "RUN_NAME: $RUN_NAME, LOG_PATH: $LOG_PATH, NUM_GPUS: $NUM_GPUS, CHECKPOINT_PATH: $CHECKPOINT_PATH, FACTORIZED: $FACTORIZED"

if [ $FACTORIZED -eq 1 ]
then
    echo "Factorized" > $LOG_PATH
    for i in $(seq 0 $(($NUM_GPUS - 1)))
    do
        CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_sft.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name "WHOOPS-Caption" --checkpoint_path ${CHECKPOINT_PATH_LIST[i]} --expand_vocab "factorized" --factorized_linear_mlp >> $LOG_PATH 2>&1 &
    done
else
    echo "Direct" > $LOG_PATH
    for i in $(seq 0 $(($NUM_GPUS - 1)))
    do
        CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_sft.py --template_index 0 --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config --from_hf --use_lora --dataset_name "WHOOPS-Caption" --checkpoint_path ${CHECKPOINT_PATH_LIST[i]} >> $LOG_PATH 2>&1 &
    done
fi

wait

date