cd YOUR_ROOT_PATH/MLLM

DATASET_NAME=$1
# DATASET_NAME="VQAv2_VAL"
# DATASET_NAME="VQAv2_TEST"
NUM_GPUS=8
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_factorized_mlp_uni_bi_512_2e_ls1_beta95_0.4/last_4145"
FACTORIZED=1
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct_uni_bi_512_2e_ls1_beta95/last_4145"
# FACTORIZED=0

TEMPLATE_INDEX_START=$2
TEMPLATE_INDEX_END=$3
DEBUG=$4
FROM_HF=$5

if [ $FACTORIZED -eq 1 ]
then
    RUN_NAME="ZS_CoT/${DATASET_NAME}_factorized"
    FACTORIZED_COMMAND="--expand_vocab factorized --factorized_linear_mlp"
else
    RUN_NAME="ZS_CoT/${DATASET_NAME}_direct"
    FACTORIZED_COMMAND=""
fi

LOG_PATH="YOUR_ROOT_PATH/MLLM/logs/evaluation_sft/$RUN_NAME.log"
echo "Factorized: $Factorized" > $LOG_PATH
date | tee -a $LOG_PATH
echo "RUN_NAME: $RUN_NAME, LOG_PATH: $LOG_PATH, NUM_GPUS: $NUM_GPUS, CHECKPOINT_PATH: $CHECKPOINT_PATH, FACTORIZED: $FACTORIZED, TEMPLATE_INDEX_START: $TEMPLATE_INDEX_START, TEMPLATE_INDEX_END: $TEMPLATE_INDEX_END, DEBUG: $DEBUG, FROM_HF: $FROM_HF" | tee -a $LOG_PATH

for TEMPLATE_INDEX in $(seq $TEMPLATE_INDEX_START $TEMPLATE_INDEX_END)
do
    echo "TEMPLATE_INDEX: $TEMPLATE_INDEX" | tee -a $LOG_PATH
    for i in $(seq 0 $((NUM_GPUS - 1)))
    do
        CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_multi_gpu_cot_sft.py --num_gpu $NUM_GPUS --dataset_shard_index $i --template_index $TEMPLATE_INDEX --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config $FROM_HF --use_lora --dataset_name $DATASET_NAME --prompt_setting "zero_shot_cot_choices_ppl" --checkpoint_path $CHECKPOINT_PATH --debug $DEBUG $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
    done
    
    wait

    CUDA_VISIBLE_DEVICES=0 python src/evaluation/eval_vllm_multi_gpu_cot_sft.py --num_gpu $NUM_GPUS --dataset_shard_index -1 --template_index $TEMPLATE_INDEX  --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config $FROM_HF --use_lora --dataset_name $DATASET_NAME --prompt_setting "zero_shot_cot_choices_ppl" --checkpoint_path $CHECKPOINT_PATH --debug $DEBUG $FACTORIZED_COMMAND >> $LOG_PATH 2>&1
done

date | tee -a $LOG_PATH