cd YOUR_ROOT_PATH/MLLM

DATASET_NAME=$1
# DATASET_NAME="GQA_TESTDEV_BALANCED"
NUM_GPUS=8
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/ablation_vocab_OIv4_direct+factorized_mlp_uni_512_2e_ls1_beta95/last_4145"
FACTORIZED=1
# CHECKPOINT_PATH="YOUR_ROOT_PATH/model/checkpoint/MLLM/adjust_OIv4-IC_lora_custom_only_ic_e3_512_2e_ls1_uni_eps1e-18/best_1416_ppl_154.536"
# FACTORIZED=0

FROM_HF=$2

if [ $FACTORIZED -eq 1 ]
then
    RUN_NAME="ZS_TO/${DATASET_NAME}_factorized"
    FACTORIZED_COMMAND="--expand_vocab factorized --factorized_linear_mlp"
else
    RUN_NAME="ZS_TO/${DATASET_NAME}_direct"
    FACTORIZED_COMMAND=""
fi

LOG_PATH="YOUR_ROOT_PATH/MLLM/logs/evaluation_sft/$RUN_NAME.log"
echo "Factorized: $Factorized" > $LOG_PATH
date | tee -a $LOG_PATH
echo "RUN_NAME: $RUN_NAME, LOG_PATH: $LOG_PATH, NUM_GPUS: $NUM_GPUS, CHECKPOINT_PATH: $CHECKPOINT_PATH, FACTORIZED: $FACTORIZED, FROM_HF: $FROM_HF" | tee -a $LOG_PATH

for i in $(seq 0 $((NUM_GPUS - 1)))
do
    CUDA_VISIBLE_DEVICES=$i python src/evaluation/eval_vllm_to_sft.py --template_index $i --use_slow_tokenizer --skip_special_tokens --spaces_between_special_tokens --use_config $FROM_HF --use_lora --dataset_name $DATASET_NAME --prompt_setting zero_shot_cot --checkpoint_path $CHECKPOINT_PATH $FACTORIZED_COMMAND >> $LOG_PATH 2>&1 &
done

wait

date | tee -a $LOG_PATH