import json,os
from statistics import mean,median


# For JSONL or newline-delimited JSON
# fp_set='context_bugs/pytorch_to_jax_code_rules_complete.json'

# set F
fp_set='set_F/setF_code_rules.json'
fop_out='output_examples_proposal/'
json_item = json.load(open(fp_set,'rb'))['Pytorch_to_JAX_Examples']
list_errors=[]
list_examples=[]
for i in range(0,len(json_item)):
    it=json_item[i]
    size_errors=len(it['Errors'])
    list_errors.append(size_errors)
    list_examples.append(it['Example_id'])

min_err=min(list_errors)
max_err=max(list_errors)
mean_err= mean(list_errors)
med_err=median(list_errors)
sum_err=sum(list_errors)
print('min:\t{}\nmax:\t{}\nmean:\t{}\nmedian:\t{}\nTotal:\t{}\n'.format(min_err,max_err,mean_err,med_err,sum_err))
f1=open(fop_out+'fix_effort_details.txt','w')
f1.write('\n'.join(sorted(['{}\t{}'.format(list_examples[i],list_errors[i]) for i in range(0,len(list_errors))])))
f1.close()