import os
import numpy as np


def load_train_data(folder='train-data'):
    """function to load the train data from the data folder storing 
    the subject-wise data from at home training
    Returns:
    y_true: numpy array of true values (n_subs, n_blocks, n_trials, n_responses)
    y_pred: numpy array of predicted values(n_subs, n_blocks, n_trials, n_responses)
    planet_type: numpy array of planet type(n_subs, n_blocks, n_trials, n_responses)
    """
        
    data_folder = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                '..', 
                                                'human-data', 
                                                folder))
    
    y_true = np.load(os.path.join(data_folder, 'ground_truth_responses.npy'))
    y_pred = np.load(os.path.join(data_folder, 'responses.npy'))
    planet_type = np.load(os.path.join(data_folder, 'planet_type.npy'))
    return y_true, y_pred, planet_type


def load_scanner_data():
    """function to load the scanner data from the data folder storing 
    the subject-wise data from scanner training
    Returns:
        y_true: numpy array of true values (n_subs, n_blocks, n_trials, n_responses)
        y_pred: numpy array of predicted values(n_subs, n_blocks, n_trials, n_responses)
        planet_type: numpy array of planet type(n_subs, n_blocks, n_trials, n_responses)
        plant_type: numpy array of plant type(n_subs, n_blocks, n_trials, n_responses)
    """
        
    data_folder = os.path.abspath(os.path.join(os.path.dirname(__file__),
                                                '..', 
                                                'data', 
                                                'scanner-data'))
    
    y_true = np.load(os.path.join(data_folder, 'ground_truth_responses.npy'))
    y_pred = np.load(os.path.join(data_folder, 'responses.npy'))
    planet_type = np.load(os.path.join(data_folder, 'planet_type.npy'))
    plant_type = np.load(os.path.join(data_folder, 'plant_type.npy'))
    return y_true, y_pred, planet_type, plant_type
