import numpy as np

def pomp_score(acc:np.array, chance:float, max_score:float):
    """Calculates the Pomp (fraction of maximum possible) 
    score for a given accuracy value.
    
    Args:
        acc (np.ndarray): the array of accuracy values
        chance (float): the chance level in the task
        max_score (float): the maximum score possible in the task
    Returns:
        float: pomp score
    """
    return (acc - chance)/(max_score - chance)