import os
import json
import random


with open(r'D:\ecnu\2025\nvi\data\task1\extend_test_scene.txt', encoding="utf-8") as f:
    content = f.readlines()
data = dict()
for i in content:
    i = i.strip()
    if i.endswith('.png'):
        data[temp].append(i)
    else:
        temp = i
        data[temp] = []

hist_len = 3
cand_num = 4
jsonl_data = []


for inst in data:
    print(inst)
    instruction_text = f"You are following a multi-step navigation instruction. Based on the historical images, think step by step to determine which step you are currently at. Then, choose the best next-view image that matches the next instruction step.\n Instruction: {inst}, Think step by step before answering. Output only:\n Answer: <A/B/C/D>"
    imgs = sorted(data[inst])
    img_paths = [os.path.join('/oss/zhanglechao/mc_dataset/img', img) for img in imgs]
    if len(img_paths) <= 7 :
        continue
    for t in range(hist_len, len(img_paths) - 1):
        # 历史图像
        hist_imgs = img_paths[t - hist_len : t]
        hist_tags = [f"img_hist{i}" for i in range(hist_len)]

        # 正确图像
        gt_img = img_paths[t + 1]
        gt_tag = "img_gt"

        # 随机选择干扰项
        distractors = []
        while len(distractors) < cand_num - 1:
            rand_img = random.choice(img_paths)
            if rand_img != gt_img and rand_img not in hist_imgs and rand_img not in distractors:
                distractors.append(rand_img)

        # 候选图像（打乱顺序）
        all_candidates = distractors + [gt_img]
        random.shuffle(all_candidates)
        cand_tags = [f"img_cand{i}" for i in range(cand_num)]
        answer_index = all_candidates.index(gt_img)
        answer_letter = chr(ord("A") + answer_index)

        # 构造 input 文本
        input_text = "The historical images are as follows:\n"
        for tag in hist_tags:
            input_text += f"<{tag}>\n"
        input_text += "And the choices are as follows: " + ", ".join([f"<{tag}>" for tag in cand_tags])

        # 构造样本
        sample = {
            "instruction": inst,
            "input": input_text,
            "output": answer_letter,
            "images": {}
        }

        # 添加图像路径映射
        for tag, path in zip(hist_tags, hist_imgs):
            sample["images"][tag] = path
        for tag, path in zip(cand_tags, all_candidates):
            sample["images"][tag] = path

        jsonl_data.append(sample)

output_file = "./data/task1/extend_test.json"

import json
# 写入 JSONL 文件
with open(output_file, "w", encoding="utf-8") as f:
    json.dump(jsonl_data, f, ensure_ascii=False, indent=2)

print(f"✅ 成功生成 {len(jsonl_data)} 条样本，保存为 {output_file}")

