import os
import math
import json
from PIL import Image


def angle_diff(a, b):
    """计算两个角度的最小差值（单位：度）"""
    diff = (a - b + 180) % 360 - 180
    return diff

def compute_action(pose1, pose2):
    x1, z1, yaw1 = pose1['x'], pose1['z'], pose1['yaw']
    x2, z2 = pose2['x'], pose2['z']
    dx = x2 - x1
    dz = z2 - z1
    dist = math.sqrt(dx ** 2 + dz ** 2)
    # if dist < 1.0:
    #     return 'D'  # 太近 → 停止

    yaw1 = float(pose1["yaw"]) % 360
    if yaw1 > 180:
        yaw1 -= 360
    angle_to_target = math.degrees(math.atan2(-dx, dz)) % 360  # 注意 z 是向前
    delta_yaw = angle_diff(angle_to_target, yaw1)

    if abs(delta_yaw) < 15:
        return 'A'
    elif delta_yaw > 0:
        return 'C'  # 右转
    else:
        return 'B'  # 左转

with open(r'D:\ecnu\2025\nvi\data\task1\extend_train_scene.txt', encoding="utf-8") as f:
    content = f.readlines()
data = dict()
for i in content:
    i = i.strip()
    if i.startswith('D:\ecnu'):
        data[temp].append(i[28:])
    else:
        temp = i
        data[temp] = []


# 参数
pose_file = r"D:\ecnu\2025\nvi\vln_add_coords.jsonl"  # 每张图片的 pose: {"img_000.png": {"x":..., "z":..., "yaw":..., "pitch":...}, ...}
output_json = "../data/task2/extend_train.json"

pose = dict()
# 加载所有位姿
with open(pose_file, "r", encoding="utf-8") as file:
    for line in file:
        line = line.strip()  # 去除首尾空白字符
        if line:
            temp = json.loads(line)
            pose[temp["filename"]] = temp

# 构建导航样本
dataset = []
for inst in data:
    # 所有图片按文件名顺序排序
    image_names = sorted(data[inst])

    for i in range(len(image_names) - 1):
        curr_img = image_names[i]
        next_img = image_names[i + 1]
        curr_pose = pose[curr_img[4:]]
        next_pose = pose[next_img[4:]]
        action = compute_action(curr_pose, next_pose)

        sample = {
            "instruction": f"You are given a multi-step navigation instruction and a current-view image. \nFirst, analyze which step of the instruction you are currently at based on the image. \nThen, reason what action should be taken to progress to the next step of the instruction. \nInstruction:{inst}\nThe action options are: A = move forward, B = turn left, C = turn right, D = stop. \nOutput only: Answer: <A/B/C/D>",
            "input": f"The current-view is : <img_hist0>",
            "output": action,
            "images": {
                "img_hist0": os.path.join('/oss-tanxin/zhanglechao/mc_dataset_v2', curr_img)
            }
        }
        dataset.append(sample)

    # 最后一帧动作设为停止
    dataset.append({
        "instruction": inst,
        "input": f"The current-view is : <img_hist0>",
        "output": "D",
        "images": {
            "img_hist0": os.path.join('/oss-tanxin/zhanglechao/mc_dataset_v2', image_names[-1])
        }
    })

# 保存结果
with open(output_json, "w") as f:
    json.dump(dataset, f, indent=2)

print(f"Saved {len(dataset)} navigation samples to {output_json}")
