// 配置参数
const CONFIG = {
    GRID_SIZE: 20,
    COLORS: [
        "#FF5252", "#FF4081", "#E040FB", "#7C4DFF", 
        "#536DFE", "#448AFF", "#40C4FF", "#18FFFF",
        "#64FFDA", "#69F0AE", "#B2FF59", "#EEFF41"
    ],
    CATEGORY_NAMES: [
        "empthy", "ceiling", "floor", "wall", 
        "window", "chair", "bed", "sofa",
        "table", "tvs", "furniture", "object"
    ],
    CENTER_COLOR: "#FFFFFF", // 中心点颜色
    
    // 默认值
    DEFAULT_VOXEL_SIZE: 5,
    DEFAULT_OPACITY: 80,
    DEFAULT_CENTER_SIZE: 8,
    DEFAULT_SCALE: 1,
    
    // 限制值
    MIN_SCALE: 0.5,
    MAX_SCALE: 5
};

// 状态变量
let state = {
    rotationX: 0,
    rotationY: 0,
    rotationZ: 0,
    scale: CONFIG.DEFAULT_SCALE,
    offsetX: 0,
    offsetY: 0,
    isDragging: false,
    isEditing: false,
    isDraggingCenter: false,
    lastX: 0,
    lastY: 0,
    autoRotate: false,
    showCenters: false,
    animationId: null,
    voxelData: [],
    centerPoints: [],
    selectedCategories: new Set([...Array(12).keys()]),
    draggedCenterIndex: -1,
    originalCenterPos: null,
    centerPointsFromFile: [],
    useFileCenters: false,
    isShiftPressed: false,
    isRightClick: false,
    isCtrlPressed: false
};

// DOM元素引用
let elements = {};

// 初始化DOM元素引用
function initElements() {
    elements = {
        canvas: document.getElementById('occupancy-canvas'),
        ctx: null, // 将在setupCanvas中初始化
        loading: document.getElementById('loading'),
        voxelSize: document.getElementById('voxel-size'),
        opacity: document.getElementById('opacity'),
        centerSize: document.getElementById('center-size'),
        voxelSizeValue: document.getElementById('voxel-size-value'),
        opacityValue: document.getElementById('opacity-value'),
        centerSizeValue: document.getElementById('center-size-value'),
        rotationXValue: document.getElementById('rotation-x-value'),
        rotationYValue: document.getElementById('rotation-y-value'),
        rotationZValue: document.getElementById('rotation-z-value'),
        scaleValue: document.getElementById('scale-value'),
        selectedCategories: document.getElementById('selected-categories'),
        voxelCount: document.getElementById('voxel-count'),
        centerCount: document.getElementById('center-count'),
        centerSource: document.getElementById('center-source'),
        rotationStatus: document.getElementById('rotation-status'),
        editStatus: document.getElementById('edit-status'),
        fileInput: document.getElementById('file-input'),
        pointsFileInput: document.getElementById('points-file-input'),
        fileType: document.getElementById('file-type')
    };
    
    // 初始化canvas上下文
    if (elements.canvas) {
        elements.ctx = elements.canvas.getContext('2d');
    }
}

// 导出配置和状态
window.CONFIG = CONFIG;
window.state = state;
window.elements = elements;
window.initElements = initElements;