This is the anonymous repo for the work: " Robust Decentralized VFL
Over Dynamic Device Environment"

## Requirements
Our result is based on `torch==1.13.1` and `torch_geometric==2.3.1`. It also requires some other basic packages such as `numpy`.

To use StarcraftMNIST, you need to install `sc2image`.

For logging and processing final results, we use [`wandb`](https://wandb.ai/site). 

## Reproducing Results

Here is an example of running our experiment
```angular2html

python main.py --dataset 'starmnist' --drop_mode 'device' --drop_rate_train 0.5 --graph_type 'uni' --model_setup 'MVFL' --n_device 16 --n_gossip 4 --gossip_mode 'gm' --repeat 2 --seed 16
```

Here `dataset` specifies the dataset to be StarcraftMNIST.

`drop_mode` specifies the fault pattern to be device fault or communication fault.

`drop_rate_train` specifies the fault rate. For each run, we track the performance under different test fault rates which does not need
to be specified here.

`graph_type` specifies the baseline network to be `uni`(complete) or `grid`.

`n_device` specifies the number of devices.

`model_setup` can be `VFL`, `MVFL` or `DeepMVFL`.

`repeat` specifies the depth of DeepMVFL which does not make any difference for other models.

If you don't want to use `wandb` to log your results, you can add `--no_wandb` to the command line. If you want to use `wandb`,
you need to specific your `wandb-entity`.