#!/bin/bash

export CUDA_VISIBLE_DEVICES=0

## path to the data directory
DATA=
## path to store real images (for FID computation)
REAL=

CODE=

python ${CODE}/main.py \
  --eval_fid \
  --calculate_fid_num_images 50_000 \
  --load_from 1 \
  --num_image_tiles 64 \
  --generate_types 'ema' \
  --num_train_steps 450_000 \
  --image_size 64 \
  --num_decoding_steps 64 \
  --data_dir ${DATA} \
  --fid_real_path ${REAL} \
  --batch_size 20 \
  --grad_cummulate_every 1 \
  --latent_dim 512 \
  --v2_input_sigmoid \
  --use_latent_to_init \
  --mini_latent_dim 8 \
  --mini_input_size 128 \
  --rnn_hidden_size 1024 \
  --num_layers 1 \
  --use_softmax \
  --frozen_base \
  --reset_g_optimizer \
  --stop_grad_unet \
  --out_tanh \
  --unet_tanh \
  --ema_only_unet \
  --model_type 'lstm_delta_split_v2_unet' \
  --result_dir 'results' \
  --model_dir 'models' \
