# TLDR: Temporal Distance-aware Representation for Unsupervised Goal-Conditioned RL

## Requirements
- Python 3.8

## Installation

```
conda create --name tldr python=3.8
conda activate tldr
pip install -r requirements.txt --no-deps
pip install -e .
pip install -e garaged
pip install -e d4rl
```

Before running the scripts, please fill in the arguments for `wandb.init()` in `tests/main.py`.

## Commands to run experiments:

```
seed=42

# Ant
# TLDR:
python tests/main.py --env ant --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type preset --eval_plot_axis -50 50 -50 50 --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --eval_plot_axis -80 80 -80 80 --trans_minibatch_size 1024 --discrete 0 --dim_option 4 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env ant --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type preset --eval_plot_axis -50 50 -50 50 --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 2 


# HalfCheetah
# TLDR:
python tests/main.py --env half_cheetah --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type preset --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 1 --dim_option 16 --trans_minibatch_size 1024 --discrete 0 --dim_option 4 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env half_cheetah --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type preset --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 1 --dim_option 16 --trans_minibatch_size 1024 

# AntMaze-Large
# TLDR:
python tests/main.py --env antmaze-large-play --max_path_length 300 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 75 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --discrete 0 --dim_option 4 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env antmaze-large-play --max_path_length 300 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 75 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024


# AntMaze-Ultra
# TLDR:
python tests/main.py --env antmaze-ultra-play --max_path_length 600 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 150 --n_epochs_per_log 100 --n_epochs_per_eval 500 --n_epochs_per_save 500 --n_epochs_per_pt_save 500 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --discrete 0 --dim_option 4 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env antmaze-ultra-play --max_path_length 600 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 150 --n_epochs_per_log 100 --n_epochs_per_eval 500 --n_epochs_per_save 500 --n_epochs_per_pt_save 500 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 

# Quadruped-Escape
# TLDR:
python tests/main.py --env dmc_quadruped_state_escape --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --eval_plot_axis -15 15 -15 15 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env dmc_quadruped_state_escape --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --eval_plot_axis -15 15 -15 15

# Humanoid-Run
# TLDR:
python tests/main.py --env dmc_humanoid_state --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --eval_plot_axis -60 60 -60 60 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env dmc_humanoid_state --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --trans_optimization_epochs 50 --n_epochs_per_log 100 --n_epochs_per_eval 1000 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --sac_max_buffer_size 1000000 --algo metra --discrete 0 --dim_option 4 --trans_minibatch_size 1024 --eval_plot_axis -60 60 -60 60

# Quadruped (Pixel)
# TLDR:
python tests/main.py --env dmc_quadruped --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --video_skip_frames 2 --frame_stack 3 --sac_max_buffer_size 300000 --eval_plot_axis -15 15 -15 15 --algo metra --trans_optimization_epochs 200 --n_epochs_per_log 25 --n_epochs_per_eval 125 --n_epochs_per_save 125 --n_epochs_per_pt_save 125 --discrete 0 --dim_option 4 --encoder 1 --sample_cpu 0 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --env dmc_quadruped --max_path_length 200 --seed $seed --traj_batch_size 8 --n_parallel 4 --normalizer_type off --video_skip_frames 2 --frame_stack 3 --sac_max_buffer_size 300000 --eval_plot_axis -15 15 -15 15 --algo metra --trans_optimization_epochs 200 --n_epochs_per_log 25 --n_epochs_per_eval 125 --n_epochs_per_save 125 --n_epochs_per_pt_save 125 --discrete 0 --dim_option 4 --encoder 1 --sample_cpu 0 

# Kitchen (Pixel)
# TLDR:
python tests/main.py --run_group Debug --env kitchen --max_path_length 50 --seed 0 --traj_batch_size 8 --n_parallel 4 --normalizer_type off --num_video_repeats 1 --frame_stack 3 --sac_max_buffer_size 100000 --algo metra --sac_lr_a -1 --trans_optimization_epochs 100 --n_epochs_per_log 25 --n_epochs_per_eval 250 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --discrete 1 --dim_option 24 --encoder 1 --sample_cpu 0 --hilp 1 --hilp_qrl 1 --hilp_p_trajgoal 0.25 --apt 1 --use_traj_for_apt_rep 1 --goal_reaching 1 --exploration_type 13 --num_video_repeats 24 --dual_lam 3000 --q_layer_normalization 1 --exp_q_layer_normalization 1 --lr_te 5e-4 --sac_discount 0.97 --exploration_sac_discount 0.99 --description "tldr" --n_epochs 40002
# METRA:
python tests/main.py --run_group Debug --env kitchen --max_path_length 50 --seed 0 --traj_batch_size 8 --n_parallel 4 --normalizer_type off --num_video_repeats 1 --frame_stack 3 --sac_max_buffer_size 100000 --algo metra --sac_lr_a -1 --trans_optimization_epochs 100 --n_epochs_per_log 25 --n_epochs_per_eval 250 --n_epochs_per_save 1000 --n_epochs_per_pt_save 1000 --discrete 1 --dim_option 24 --encoder 1 --sample_cpu 0 
```