import numpy as np

import gym
import matplotlib

# matplotlib.use("Agg")
import matplotlib.pyplot as plt

from matplotlib import patches
import imageio

import functools as ft

from envs.mujoco.half_cheetah_env import HalfCheetahEnv

from lxml import etree

env = HalfCheetahEnv(
    render_hw=100, model_path="half_cheetah_short_hurdle.xml", hurdle_height=0.5
)

tensor = []
for _ in range(300):
    env.step(env.action_space.sample())

    res = env.render(height=64, width=64, mode="rgb_array")
    tensor.append(res)

from moviepy import editor as mpy

clip = mpy.ImageSequenceClip(list(tensor), fps=30)

# plot_path = (
#     pathlib.Path(runner._snapshotter.snapshot_dir)
#     / "plots"
#     # / f'{label}_{runner.step_itr}.gif')
#     / f"{label}_{runner.step_itr}.mp4"
# )
# plot_path.parent.mkdir(parents=True, exist_ok=True)

clip.write_videofile(str("vid.mp4"), audio=False, verbose=False, logger=None)
