# One After Another: Unsupervised Discovery of Incremental Skills

## Requirements
Only Linux with Python 3.6+, [conda](https://conda.io/projects/conda/en/latest/user-guide/install/index.html), and MuJoCo 1.5 are currently supported. To install MuJoCo, follow these steps:

1. Obtain a 30-day free trial on the [MuJoCo website](https://www.roboti.us/license.html) or free license if you are a student. The license key will arrive in an email with your username and password.
2. Download the MuJoCo version 1.5 binaries for [Linux](https://www.roboti.us/download/mjpro150_linux.zip).
3. Unzip the downloaded `mjpro150` directory into `~/.mujoco/mjpro150`, and place your license key (the `mjkey.txt` file from your email) at `~/.mujoco/mjkey.txt`.

## How to run
1. Install MuJoCo as detailed in the section above.
1. Install the dependencies using conda, `conda env create -f conda_env.yml`
2. Activate the conda environment, `conda activate disk-env`
3. Modify `utils.py`, dictionary `ENV_EXTRA_KWARGS` so that the xml paths points to where `disk/config` is located in your system.
5. (Optional) sign in to `wandb` to see the logs of your run.
5. Run `python train.py`.

## How to add a new environment
1. Create a new file in `config/env/your_env.yaml`.
2. Modify `utils.py:make_env_from_env_name` function so that it can return your environment properly.
3. Add an associated projection function in `envs/obs_transform.py`, and add the functions to the `OBS_TRANSFORMS, RECORD_TRANSFORMS` dictionaries in that file. See other projection functions in that file for example.
4. Run `python train.py -env your_env`.