# GNN Training and Fine-Tuning for Physical Properties

## Project Description
This repository contains tools for:
- Training Graph Neural Networks (GNNs) on physical simulation data
- Fine-tuning GNNs for specific physical property prediction
- Processing Material Point Method (MPM) demonstration data

## File Structure

| File | Purpose |
|------|---------|
| `preprocess_mpm.py` | Preprocesses raw MPM simulation data into training-ready format |
| `train_final_2.py` | Main GNN training script |
| `finetune_fix_idx.py` | Fine-tunes specific physical properties of pre-trained GNN |

## Installation
```
conda create -n gnn python=3.10
conda activate gnn
conda install pytorch==2.4.0 torchvision==0.19.0 torchaudio==2.4.0 pytorch-cuda=12.4 -c pytorch -c nvidia
pip install -r requirements.txt
conda install -c dglteam/label/th24_cu124 dgl  # install dgl with cuda 12.4

```

```
mkdir third-party
cd third-party
git clone git@github.com:JonathonLuiten/diff-gaussian-rasterization-w-depth.git
cd diff-gaussian-rasterization-w-depth
python setup.py install
cd ..
```

## Usage
### 1. Data Preprocessing
```
python preprocess_mpm.py
```

### 2. GNN Training
```
python train_final_2.py
```

### 3. Fine-tuning Physical Properties
```
python finetune_fix_idx.py
```

### 4.evaluate
```
python evaluate_chamfer.py
python evaluate_track.py
```

