import os.path
import random
import torch
import numpy as np

import sys
sys.path.append("gaussian-splatting")

# gaussian-splatting
from scene.gaussian_model_final import GaussianModel

def filling(data_path, output_path, is_cloth = False, sh_degree = 3):
    gaussian = GaussianModel(sh_degree)
    gaussian.load_structure_data_filling(data_path,is_cloth = is_cloth)
    output_name = os.path.join(output_path,'point_cloud_filling.ply')
    gaussian.save_ply(output_name)
    print(f"filling success and save in {output_name}")


def set_all_seeds(seed):
    random.seed(seed)
    np.random.seed(seed)
    torch.manual_seed(seed)
    torch.cuda.manual_seed(seed)
    torch.cuda.manual_seed_all(seed)
    torch.backends.cudnn.deterministic = True
    torch.backends.cudnn.benchmark = False

set_all_seeds(42)

if __name__ == '__main__':

    name = 'single_push_rope'
    is_cloth = False

    data_path = f'./data/phystwin_data/{name}'
    output_path = f'./data/phystwin_data/{name}'

    filling(data_path, output_path, is_cloth = is_cloth)