

# Project Code Structure Explanation

The WaveDN folder contains the main code for this paper, which includes scripts for conducting zero-shot and cross-modal retrieval experiments. 

 The configuration for the experiment is set in **args_parser.py**. Before extracting features or performing similarity calculations, the corresponding parameter settings should be modified in this file, or the parameters should be specified using the command line. To ensure computational efficiency, the experiments are conducted in two main steps:

1. The first step involves extracting features from the dataset. This process is primarily carried out in **FeatureExtraction.py**, where images and text from the dataset are processed through a CLIP encoder to extract features, which are then saved as files in the corresponding dataset. 

   `python FeatureExtraction.py`

2. The second step involves calculating similarity, which is executed in **ComputeSims.py** and **ComputeRetrieval.py**. Using the features extracted in the previous step, similarity calculations can be performed in three different modes: WaveDN, DN and Org to make predictions.

   `python ComputeSims.py`

   `python ComputeRetrieval.py`