import pandas as pd

def load_data(file_path):
    df = pd.read_csv(file_path)
    return df

def preprocess_data(df, dynamic_predictors, target, early_prediction):
    df_cases = df[df[target] == 1]
    df_controls = df[df[target] == 0]

    df_cases_filtered = df_cases.groupby('VisitIdentifier').apply(
        lambda x: x[(x['MinutesFromArrival'].iloc[-1] - x['MinutesFromArrival']) >= early_prediction * 60])
    df_controls_filtered = df_controls.groupby('VisitIdentifier').apply(
        lambda x: x[(x['MinutesFromArrival'].iloc[-1] - x['MinutesFromArrival']) >= early_prediction * 60])

    df_filtered = pd.concat([df_cases_filtered, df_controls_filtered])
    df_filtered['label'] = df_filtered[target].astype(int)

    X = df_filtered[dynamic_predictors]
    y = df_filtered['label']

    return X, y
