import time
from data_loading import load_data, preprocess_data
from train import train_model

# Hyperparameters
dynamic_predictors = ['MinutesFromArrival', 'HeartRate', 'RespiratoryRate', 'PulseOx', 'SystolicBP', 'DiastolicBP', 'Temperature', 'BUN', 'Lactate', 'Platelet', 'Creatinine', 'BiliRubin', 'WBC', 'CReactiveProtein', 'OxygenFlow']
target = 'Observed_Shock'
early_prediction = 24
learning_rates = [0.0001, .001, .01]
batch_sizes = [64, 32, 16, 8]
epochs = 28
hidden_dims = [512, 256, 128, 64]
model_type = 'Bi_LSTM'  # Bi_LSTM or LSTM

# Load and preprocess data
df = load_data('cleaned_mimic.csv')
X, y = preprocess_data(df, dynamic_predictors, target, early_prediction)

# Start the timer
start_time = time.time()

# Train the model
results = train_model(X, y, dynamic_predictors, learning_rates, batch_sizes, epochs, hidden_dims, model_type=model_type)

# Display results
print(f"Accuracy: Mean = {results['accuracy'][0]:.4f}, Std = {results['accuracy'][1]:.4f}")
print(f"Precision: Mean = {results['precision'][0]:.4f}, Std = {results['precision'][1]:.4f}")
print(f"Recall: Mean = {results['recall'][0]:.4f}, Std = {results['recall'][1]:.4f}")
print(f"Cross-Validation Test AUC: Mean = {results['test_auc'][0]:.4f}, Std = {results['test_auc'][1]:.4f}")
print(f"Cross-Validation Test F1: Mean = {results['test_f1'][0]:.4f}, Std = {results['test_f1'][1]:.4f}")

# Print runtime
elapsed_time = time.time() - start_time
print(f"Runtime: {elapsed_time:.2f} seconds")
print(f"Using the early_prediction as: {early_prediction}")
print(f"Using {model_type}")
