import pandas as pd
import torch
import numpy as np
from torch.utils.data import DataLoader, TensorDataset

def load_data(file_path):
    return pd.read_csv(file_path)

def preprocess_data(df, dynamic_predictors, target, early_prediction):
    df_cases = df[df[target] == 1]
    df_controls = df[df[target] == 0]

    df_cases_filtered = df_cases.groupby('VisitIdentifier').apply(
        lambda x: x[(x['MinutesFromArrival'].iloc[-1] - x['MinutesFromArrival']) >= early_prediction * 60])
    df_controls_filtered = df_controls.groupby('VisitIdentifier').apply(
        lambda x: x[(x['MinutesFromArrival'].iloc[-1] - x['MinutesFromArrival']) >= early_prediction * 60])
    df_filtered = pd.concat([df_cases_filtered, df_controls_filtered])
    df_filtered['label'] = df_filtered[target].astype(int)

    X = df_filtered[dynamic_predictors]
    y = df_filtered['label']
    times = df_filtered['MinutesFromArrival'].values

    return X, y, times

def prepare_times_tensor(times_array, num_time_indices, device):
    times_array = np.clip(times_array, 0, num_time_indices - 1)
    return torch.tensor(times_array.reshape(-1, 1), dtype=torch.long).to(device)


def prepare_data(X, y, times, batch_size, device):
    X_tensor = torch.tensor(X.values.astype(np.float32)).unsqueeze(1).to(device)
    y_tensor = torch.tensor(y.values.astype(np.float32)).unsqueeze(1).to(device)
    times_tensor = prepare_times_tensor(times, num_time_indices=1, device=device)
    dataset = TensorDataset(X_tensor, times_tensor, y_tensor)
    return DataLoader(dataset, batch_size=batch_size, shuffle=True)
