import time
import torch
import numpy as np
from sklearn.model_selection import train_test_split
from data_loading import load_data, preprocess_data, prepare_data
from train import train_model
from evaluate import evaluate_model, compute_metrics, print_classification_report

# Hyperparameters
dynamic_predictors = [
    'HeartRate', 'RespiratoryRate', 'PulseOx', 'SystolicBP', 'DiastolicBP',
    'Temperature', 'BUN', 'Lactate', 'Platelet', 'Creatinine', 'BiliRubin',
    'WBC', 'CReactiveProtein', 'OxygenFlow']
target = 'Observed_Shock'
early_prediction = 28
batch_size = 64
input_dim = len(dynamic_predictors)
hidden_dim = 200
output_dim = 1  # Number of target variables
lr = 0.001
num_epochs = 100
num_heads = 2
num_layers = 2
num_folds = 3

learning_rates = [0.0001, 0.001, 0.01]
batch_sizes = [32, 64]
hidden_dims = [64, 128, 256]

start_time = time.time()

device = torch.device("cuda" if torch.cuda.is_available() else "cpu")
print("Using device:", device)

df = load_data('cleaned_mimic.csv')
X, y = preprocess_data(df, dynamic_predictors, target, early_prediction)

results = train_model(X, y, dynamic_predictors, learning_rates, batch_sizes, num_epochs, hidden_dims, num_heads, num_layers, num_folds)

end_time = time.time()
runtime = end_time - start_time
print(f"Runtime: {runtime:.2f} seconds")
print(f'Using the early prediction window as: {early_prediction} hours')
print(f'Using Transformer')
