# Image Experiments of EP-GAN

This sub-project implements experiments involved in "Section 5.2 Synthetic Extremely Non-I.I.D. Image Dataset".

## Major Components

- `datasets/`: the directory containing dataset loading and preprocessing.
- `inception/`: the directory used for metrics evaluation
- `fl_utils.py`: the script containing federated learning toolkits.
- `models.py`: the implementation of model architectures.
- `train*.py`: the trianing scripts

## Usage

The running environment is listed in `ep-gan.yaml` for reference. The codes run
on Python 3.6 and PyTorch 1.7. 

The models can run on two GAN objectives.
```
W: Wasserstein GAN
LS: Least-Square GAN
```

There are two federated learning datasets construction modes supported:
```
i: the i.i.d. setting
p: the extremely non-i.i.d. setting, in this case the number of client (N) should be 10.
```

To run the centralized baseline:
```
python train.py --dataset [cifar10|mnist] --gan_obj [W|LS]
```

To run the federated learning baseline of Mixture-EP-ProbGAN:
```
python train_fl_epp.py --dataset [cifar10|mnist] --gan_obj [W|LS] \
    --federated-style [p|i] \
    --N [number of clients] \
    --T [number of federated learning turns] \
    --L [local training epoch]
    --g_ep_prior_lambda [the EP-prior factor]
```