import torch
import torch.nn as nn
import pdb
class Counter():
    def __init__(self, ):
        self.gated_layer=[]
    def addgated(self,layers):
        self.gated_layer=self.gated_layer+layers

OPS = {
    'none': lambda C, stride, affine,counter: Zero(stride),
    'avg_pool_3x3': lambda C, stride, affine,counter: nn.AvgPool2d(3, stride=stride, padding=1, count_include_pad=False),
    'max_pool_3x3': lambda C, stride, affine,counter: nn.MaxPool2d(3, stride=stride, padding=1),
    'skip_connect': lambda C, stride, affine,counter: Identity() if stride == 1 else FactorizedReduce(C, C, affine=affine),
    'sep_conv_3x3': lambda C, stride, affine,counter: SepConv(C, C, 3, stride, 1,counter, affine=affine),
    'sep_conv_5x5': lambda C, stride, affine,counter: SepConv(C, C, 5, stride, 2, counter,affine=affine),
    'sep_conv_7x7': lambda C, stride, affine,counter: SepConv(C, C, 7, stride, 3, counter,affine=affine),
    'dil_conv_3x3': lambda C, stride, affine,counter: DilConv(C, C, 3, stride, 2, 2,counter, affine=affine),
    'dil_conv_5x5': lambda C, stride, affine,counter: DilConv(C, C, 5, stride, 4, 2, counter,affine=affine),
    'conv_7x1_1x7': lambda C, stride, affine,counter: Conv7x1_1x7(C, C, stride, counter,affine=True),
}

class Gate(nn.Module):
    def __init__(self, num_gates,**kwargs):
        super(Gate, self).__init__()
        self.num_gates = num_gates

    def get_weight(self, x):
        raise NotImplementedError

    def get_mask(self):
        raise NotImplementedError

    def get_reg(self, base):
        raise NotImplementedError

    def get_num_active(self):
        return self.get_mask().sum().int().item()

    def forward(self, x):
        z = self.get_weight(x) #[num_gates]
        if len(x.size()) == 4:
            z = z.view(-1, self.num_gates, 1, 1) # scalar broadcast for * with conv(x);activation map
        else:
            z = z.view(-1, self.num_gates)

        z=z.cuda()
        return x*z

class GatedLayer(nn.Module):
    def __init__(self, num_gates):
        super(GatedLayer, self).__init__()
        self.num_gates = num_gates
        self.base = None
        self.gate = None
        self.dgate = None
        self.filtersize=None

        self.setf=None
    def build_gate(self, gate_fn, **kwargs):

        if self.setf is not None:
            self.gate = gate_fn(self.num_gates,self.setf, **kwargs)
        else:
            self.gate = gate_fn(self.num_gates, **kwargs)

    def build_gate_dep(self, dgate_fn, **kwargs):
        self.dgate = dgate_fn(self.num_gates, **kwargs)

    def apply_gate(self, x):
        if self.gate is None:
            return x
        else:
            if self.dgate is None:
                return self.gate(x)
            else:
                z = self.gate.get_weight(x)
                return self.dgate(x, z)

    def get_mask(self):
        return None if self.gate is None \
                else self.gate.get_mask()

    def get_reg(self):
        return None if self.gate is None \
                else self.gate.get_reg(self.base)

    def get_reg_dep(self):
        return None if self.dgate is None \
                else self.dgate.get_reg(self.base)

    def get_num_active(self):
        return None if self.gate is None \
                else self.gate.get_num_active()
    def get_weight_nonactive(self):
        if self.gate is None:
            return None
        else:
            if self.dgate is None:
                return (self.num_gates-self.gate.get_num_active())*self.filtersize
            else:
                return (self.num_gates-self.dgate.num_active)*self.filtersize
    def get_weight(self):
        if self.gate is None:
            return None
        else:
            if self.dgate is None:
                return (self.gate.get_num_active()) * self.filtersize
            else:
                return (self.dgate.num_active)*self.filtersize


class GatedConv2d(GatedLayer):
    def __init__(self, in_channels, out_channels, kernel_size,
            stride=1, padding=0, dilation=1, groups=1, bias=True,setf=None):
        super(GatedConv2d, self).__init__(out_channels)
        self.filtersize=in_channels*kernel_size*kernel_size
        self.base = nn.Conv2d(in_channels, out_channels, kernel_size,
                stride=stride, padding=padding, dilation=dilation,
                groups=groups, bias=bias)
        if setf is not None:
            self.setf=setf
    def forward(self, x):
        return self.apply_gate(self.base(x))



class GatedLinear(GatedLayer):
    def __init__(self, in_features, out_features, bias=True):
        super(GatedLinear, self).__init__(in_features)
        self.base = nn.Linear(in_features, out_features, bias=bias)

    def forward(self, x):
        return self.base(self.apply_gate(x))

class ReLUConvBN(nn.Module):

    def __init__(self, C_in, C_out, kernel_size, stride, padding,counter, affine=True):
        super(ReLUConvBN, self).__init__()
        conv=GatedConv2d(C_in, C_out, kernel_size, stride=stride, padding=padding, bias=False)
        self.op = nn.Sequential(
            nn.ReLU(inplace=False),
            conv,
            nn.BatchNorm2d(C_out, affine=affine)
        )

        counter.addgated([conv])

    def forward(self, x):
        return self.op(x)


class Conv7x1_1x7(nn.Module):

    def __init__(self, C_in, C_out, stride, counter,affine=True):
        super(Conv7x1_1x7, self).__init__()
        conv1 = GatedConv2d(C_in, C_in, (1, 7), stride=(1, stride), padding=(0, 3), bias=False)
        conv2=GatedConv2d(C_in, C_out, (7, 1), stride=(stride, 1), padding=(3, 0), bias=False)
        self.op=nn.Sequential(
            nn.ReLU(inplace=False),
            conv1,
            conv2,
            nn.BatchNorm2d(C_out, affine=affine))
        counter.addgated([conv1,conv2])

    def forward(self, x):
        return self.op(x)

class DilConv(nn.Module):

    def __init__(self, C_in, C_out, kernel_size, stride, padding, dilation, counter,affine=True):
        super(DilConv, self).__init__()
        conv1=GatedConv2d(C_in, C_in, kernel_size=kernel_size, stride=stride, padding=padding, dilation=dilation,
                      groups=C_in, bias=False)
        conv2=GatedConv2d(C_in, C_out, kernel_size=1, padding=0, bias=False)
        self.op = nn.Sequential(
            nn.ReLU(inplace=False),
            conv1,
            conv2,
            nn.BatchNorm2d(C_out, affine=affine),
        )
        counter.addgated([conv1, conv2])

    def forward(self, x):
        return self.op(x)


class SepConv(nn.Module):

    def __init__(self, C_in, C_out, kernel_size, stride, padding,counter, affine=True):
        super(SepConv, self).__init__()
        conv1=GatedConv2d(C_in, C_in, kernel_size=kernel_size, stride=stride, padding=padding, groups=C_in, bias=False)
        conv2=GatedConv2d(C_in, C_in, kernel_size=1, padding=0, bias=False)
        conv3=GatedConv2d(C_in, C_in, kernel_size=kernel_size, stride=1, padding=padding, groups=C_in, bias=False)
        conv4=GatedConv2d(C_in, C_out, kernel_size=1, padding=0, bias=False)


        self.op = nn.Sequential(
            nn.ReLU(inplace=False),
            conv1,
            conv2,
            nn.BatchNorm2d(C_in, affine=affine),
            nn.ReLU(inplace=False),
            conv3,
            conv4,
            nn.BatchNorm2d(C_out, affine=affine),
        )
        counter.addgated([conv1, conv2,conv3,conv4])

    def forward(self, x):
        return self.op(x)


class Identity(nn.Module):

    def __init__(self):
        super(Identity, self).__init__()

    def forward(self, x):
        return x


class Zero(nn.Module):

    def __init__(self, stride):
        super(Zero, self).__init__()
        self.stride = stride

    def forward(self, x):
        if self.stride == 1:
            return x.mul(0.)
        return x[:, :, ::self.stride, ::self.stride].mul(0.)


class FactorizedReduce(nn.Module):

    def __init__(self, C_in, C_out,counter, affine=True):
        super(FactorizedReduce, self).__init__()
        assert C_out % 2 == 0
        self.relu = nn.ReLU(inplace=False)
        self.conv_1 = GatedConv2d(C_in, C_out // 2, 1, stride=2, padding=0, bias=False)
        self.conv_2 = GatedConv2d(C_in, C_out // 2, 1, stride=2, padding=0, bias=False)
        self.bn = nn.BatchNorm2d(C_out, affine=affine)

        counter.addgated([self.conv_1, self.conv_2])
    def forward(self, x):
        x = self.relu(x)
        out = torch.cat([self.conv_1(x), self.conv_2(x[:, :, 1:, 1:])], dim=1)
        out = self.bn(out)
        return out
