# This file runs all the experiments in a big for loop.
batch_size=25
for start_idx in $(python -c "for i in range(0, 500, $batch_size): print(i)") ; do
    end_idx=$(( $start_idx + $batch_size))

    # Pad index strings so that they are sorted properly
    printf -v start_idx0 "%05d" $start_idx
    printf -v end_idx0 "%05d" $end_idx

    # Go through all experiments
    for marg in "constant" "rank" ; do
        for corr in "independent" "gplvm" ; do

            # Breadth-first
            CUDA_VISIBLE_DEVICES="" start_idx=$start_idx0 end_idx=$end_idx0 marg=${marg} corr=${corr} alg=breadth-first heuristic=NONE bash iclr24_bash_scripts/run_single_experiment.sh

            # Heuristic-guided
            for heur in "optimistic" "sascore" ; do
                for alg in "mcts" "retro-star" "retro-fallback" ; do
                    CUDA_VISIBLE_DEVICES="" start_idx=$start_idx0 end_idx=$end_idx0 marg=${marg} corr=${corr} alg=${alg} heuristic=${heur} bash iclr24_bash_scripts/run_single_experiment.sh
                done
            done

        done
    done
done
