num_samples="0"  # not used by most algs
for corr in "independent" "gplvm" ; do
    for trial in {1..10} ; do
        start_idx=0
        end_idx=25

        # Pad index strings so that they are sorted properly
        printf -v start_idx0 "%05d" $start_idx
        printf -v end_idx0 "%05d" $end_idx

        # Go through all experiments
        for marg in "constant" "rank" ; do

            # Launch retro-star
            heur="optimistic"
            alg="retro-star"
            CUDA_VISIBLE_DEVICES="" start_idx=$start_idx0 end_idx=$end_idx0 marg=${marg} corr=${corr} alg=${alg} heuristic=${heur} num_samples_alg=0 trial=$trial bash iclr24_bash_scripts/run_single_experiment.sh

            # Launch breadth-first
            heur="NONE"
            alg="breadth-first"
            CUDA_VISIBLE_DEVICES="" start_idx=$start_idx0 end_idx=$end_idx0 marg=${marg} corr=${corr} alg=${alg} heuristic=${heur} num_samples_alg=0 trial=$trial bash iclr24_bash_scripts/run_single_experiment.sh

            # Launch retro-fallback
            heur="optimistic"
            alg="retro-fallback"
            for num_samples in 10 100 1000 10000 ; do
                CUDA_VISIBLE_DEVICES="" start_idx=$start_idx0 end_idx=$end_idx0 marg=${marg} corr=${corr} alg=${alg} heuristic=${heur} num_samples_alg=$num_samples trial=$trial bash iclr24_bash_scripts/run_single_experiment.sh
            done
        done
    done
done
