if [[ -z $start_idx ]] ; then
    exit 1
fi

if [[ -z $end_idx ]] ; then
    exit 1
fi

if [[ -z $alg ]] ; then
    echo "Must provide alg"
    exit 1
fi

if [[ -z $marg ]] ; then
    echo "Must provide marg"
    exit 1
fi

if [[ -z $corr ]] ; then
    echo "Must provide corr"
    exit 1
fi

if [[ -z $heuristic ]] ; then
    echo "Must provide heuristic"
    exit 1
fi

# Hard-coded defaults
smiles_file="./iclr24_expts/guacamol/test-all.smiles"
num_calls=201
# num_calls=11  # uncomment for short test

# construct save string
fname=$(basename $smiles_file .smiles)$start_idx-$end_idx
save_dir="${marg}-${corr}/${alg}-${heuristic}/"
# This is a hack just assuming we are running one of two studies
if [[ -n $trial ]] ; then
    save_dir="./iclr24_results/variability-study/$save_dir"/$num_samples_alg/trial$trial
else
    save_dir="./iclr24_results/alg-comparison/$save_dir"
    num_samples_alg=1000  # 1k samples for retro-fallback
fi
mkdir -p "$save_dir"
save_str="$save_dir"/"$fname"

# Exit early if file already present
json_name="$save_str".json
if [[ -f $json_name ]] ; then
    echo "File already present, skipping"
    exit 0
fi

# Actual running, limiting number of threads
OMP_NUM_THREADS=2 OPENBLAS_NUM_THREADS=2 MKL_NUM_THREADS=2 VECLIB_MAXIMUM_THREADS=2 NUMEXPR_NUM_THREADS=2 \
    python ./scripts/iclr24_comparison.py \
    --smiles_file=$smiles_file \
    --smiles_start_idx=$start_idx \
    --smiles_end_idx=$end_idx \
    \
    --limit_rxn_model_calls=$num_calls \
    --marginal_feasibility=$marg \
    --corr_feasibility=$corr \
    --algorithm=$alg \
    --num_samples=10000 \
    --num_samples_alg=$num_samples_alg \
    --heuristic=$heuristic \
    \
    --andor_graph_analysis \
    \
    --output_json=$json_name  > "$save_str".log
