from yacs.config import CfgNode as CN

# Basic settings
cfg = CN()
cfg.exp_space = "ImageNet"
cfg.dataset_cfg = "imagenet_ood.yaml"

# Model
cfg.model = "MobileNetV2"
cfg.model_type = "mb"
cfg.num_classes = 1000
cfg.resume = "./checkpoints/imagenet_mobilenet_v2.pth"
cfg.root_dir = "/data/"

# Preprocessing
cfg.pre_size = 256
cfg.image_size = 224
cfg.normalization_type = "imagenet"

# Dataset:
cfg.dataset = CN()
cfg.dataset.id_dataset = "imagenet"
cfg.dataset.val_dataset = "inaturalist"
cfg.dataset.near_ood = ["species", "inaturalist",
                        "sun", "places",
                        "openimageo", "imageneto"]
cfg.dataset.far_ood = ["texture", "mnist"]
