import numpy as np
import math
from sklearn.metrics import adjusted_rand_score, adjusted_mutual_info_score, normalized_mutual_info_score
from matplotlib import pyplot as plt

def sDbscan_NMI():

    y = np.loadtxt('data/mnist_all_y_70K_784')
    y_sDbscan = np.loadtxt('y_dbscan_L2_Eps_1300000_MinPts_50_NumEmbed_1024_NumProjection_1024_TopM_50_TopK_5')

    print("sDBSCAN: Number of clusters found: {}".format(len(np.unique(y_sDbscan))))
    print("sDBSCAN Acc: Adj. Rand Index Score: %f." % adjusted_rand_score(y_sDbscan, y))
    print("sDBSCAN Acc: Adj. Mutual Info Score: %f." % adjusted_mutual_info_score(y_sDbscan, y))
    print("sDBSCAN Acc: NMI %f." % normalized_mutual_info_score(y_sDbscan, y))

sDbscan_NMI()
