# Equivariant Descriptor Fields (EDFs)
PyTorch Implementation for the EDFs.
The paper can be found at: anon

## Installation

**Step 1.** We recommend using Anaconda, although not necessary.
```shell
conda create --name edf python=3.9.12 -y
conda activate edf
```
If using VSC, add python interpreter path: ~/anaconda3/envs/edf/bin/python

(ctrl+shift+P => Python: Select Interpreter => Enter interpreter path)

**Step 2.**
Download the following file and unzip it as ./pybullet-planning

Link: https://drive.google.com/file/d/1rNUZeRdb6WmbOMCW48PHS26-HG4fgto9/view?usp=sharing

**Step 3.**
```shell
pip3 install -r requirements.txt
cd pybullet-planning/pybullet_tools/ikfast/franka_panda
python setup.py                                           # You need g++ compiler installed in your system
cd ../../../..
conda develop ./pybullet-planning
conda develop .
```

**Step 4.**
```shell
pip3 install torch==1.11.0 torchvision==0.12.0 torchaudio==0.11.0 --extra-index-url https://download.pytorch.org/whl/cu113
pip3 install torch-scatter==2.0.9 -f https://data.pyg.org/whl/torch-1.11.0+cu113.html
pip3 install torch-sparse==0.6.13 -f https://data.pyg.org/whl/torch-1.11.0+cu113.html
pip3 install torch-cluster==1.6.0 -f https://pytorch-geometric.com/whl/torch-1.11.0+cu113.html
pip3 install torch-spline-conv==1.2.1 -f https://pytorch-geometric.com/whl/torch-1.11.0+cu113.html
pip3 install e3nn==0.4.4 xitorch==0.3.0 iopath==0.1.9 fvcore==0.1.5.post20220504
pip3 install --no-index --no-cache-dir pytorch3d==0.7.0 -f https://dl.fbaipublicfiles.com/pytorch3d/packaging/wheels/py39_cu113_pyt1110/download.html
```

## Generate Demo
```shell
PYTHONHASHSEED=0 python3 generate_demo.py --use-gui --file-name='mug_task_rim.gzip' --pick-type='rim'
# PYTHONHASHSEED=0 python3 generate_demo.py --use-gui --file-name='mug_task_mixed.gzip' --pick-type='mixed'
# PYTHONHASHSEED=0 python3 generate_demo.py --use-gui --file-name='mug_task_rim_lowvar.gzip' --pick-type='rim' --low-var
# PYTHONHASHSEED=0 python3 generate_demo.py --use-gui --file-name='mug_task_rim_5_demo.gzip' --pick-type='rim' --seeds 0 1 2 3 4
# PYTHONHASHSEED=0 python3 generate_demo_stick.py --use-gui --file-name='stick_task_rim.gzip' --pick-type='rim'
```

## Train
```shell
bash experiments/train.sh                  # EDF 10 demo
# bash experiments/train_5_demo.sh         # EDF 5 demo
# bash experiments/train_ablation.sh       # IDF 10 demo
# bash experiments/train_lowvar.sh         # EDF lowvar 10 demo
# bash experiments/train_multimodal.sh     # EDF mixed mug task 10 demo
# bash experiments/train_stick.sh          # EDF stick_task 10 demo
# bash experiments/baseline_train.sh       # SE(3) Transporter Networks 10 demo
```

## Eval
```shell
bash experiments/eval.sh                          # EDF 
# bash experiments/eval_ablation.sh                # IDF
# bash experiments/eval_multimodal.sh              # EDF mixed mug task
# bash experiments/eval_stick.sh                   # EDF stick task 
```



## Reproducibility
Our algorithms are guaranteed to be fully deterministic in a local machine.
However, the results may be different accross different machines.
This is presumably due to the numerical differences between processors.
Unfortunately, even a very tiny numerical difference would result in completely different output due to the MCMC steps.
Therefore, we provide download links to the task demonstrations and checkpoints.
Please download and use these files for reproducing our results.

### Download links:

Demos: https://drive.google.com/file/d/1NQga8j3KYxh72mo8nTdMiZn-1df6eEdB/view?usp=sharing

Checkpoints: https://drive.google.com/file/d/1EiptQIW7KfE8qd_7Vtdomt5uizh8ge80/view?usp=sharing

Checkpoints for baseline method (SE(3) Transporter Networks): https://drive.google.com/file/d/1HZEJYQQN1AVjXH94VZy-HlEVndk514a-/view?usp=sharing

Please unzip these files in current directory.

Next, move checkpoint/\<demo_name_to_experiment\>/train_pick to checkpoint/train_pick and checkpoint/\<demo_name_to_experiment\>/train_place to checkpoint/train_place.



## Logs
We also provide the training and evalutation logs.

### Download links:
Logs: https://drive.google.com/file/d/19wFsnmimG667QC9T3FOmxkVEFIeY-MfT/view?usp=sharing

Logs for baseline method (SE(3) Transporter Networks): https://drive.google.com/file/d/1_t81UtFiAbnnw4X0Fto7dvUxAyMWp4mO/view?usp=sharing



### Download Link for revised version:
Code: https://drive.google.com/file/d/1VzkwQiNq1gjMWDzpOZkyXHdWHjxWtWBO/view?usp=sharing

Demo: https://drive.google.com/file/d/1bTS6goVQw_ihEqDumox09tpc6daE6Gu8/view?usp=sharing

Checkpoints: https://drive.google.com/file/d/1TYJ0aJKe1bNPv8QZ6-4Kn2L6K-L246qV/view?usp=share_link







