from easy_io import read_json, dump_str_list_to_txt_file

from src.path import task_stats_dir


key_explanation_list = [
    ["question_topic", "The problem requires an understanding of the concept of ..."],
    ["instances_in_question", "The problem statement should include [price of ..., number of ..., etc.]"],
    ["number_in_question", "The problem statement should include [specific number]"],
    ["key_phrase_in_question", "The problem statement should include the phrase ``...''."],
    ["datatype_in_question", "The problem statement should include [integers, fractions, etc.] and should not include any other type of number"],
    ["math_concept_in_solution", "The solution should involve [addition, division, linear equation, etc.]"],
    ["key_phrase_in_solution", "The solution should include the phrase ``...''."],
    ["equation_in_solution", "The solution should include the question ``...''."],
    ["datatype_in_solution", "The problem statement should include [integers, fractions, etc.] and should not include any other type of number"],
]



if __name__ == "__main__":
    conditions_stats = read_json(task_stats_dir / "math_problem_generation_constraints_count.json")
    
    table_rows = []
    for key, explanation in key_explanation_list:
        row = f"{explanation:s} & {conditions_stats[key]*100:.1f} \\\\"
        table_rows.append(row)
    
    dump_str_list_to_txt_file(table_rows, task_stats_dir / "math_problem_generation_constraints_count_table.txt")
    