# Data Directory

This directory is for storing datasets used in the entropy-based early stopping experiments.

## Directory Structure

```
data/
├── README.md                    # This file
├── aime24/                     # AIME 2024 problems (user-provided)
├── aime25/                     # AIME 2025 problems (user-provided)
├── gpqa/                       # GPQA Diamond dataset (user-provided)
└── processed/                  # Processed experiment results
```

## Dataset Information

### AIME (American Invitational Mathematics Examination)

- **Source**: Mathematical Association of America
- **Format**: Mathematical competition problems with numerical answers
- **Difficulty**: High school level, but challenging
- **Usage**: Mathematical reasoning validation

**Expected format for AIME problems:**
```json
[
  {
    "problem": "Problem statement here...",
    "answer": "123",
    "year": "2024",
    "problem_number": 1
  }
]
```

### GPQA Diamond

- **Source**: Graduate-Level Google-Proof Q&A Benchmark
- **Format**: Multiple choice questions in science
- **Subjects**: Physics, Chemistry, Biology
- **Difficulty**: Graduate level
- **Usage**: Cross-domain scientific reasoning validation

**Expected format for GPQA problems:**
```json
[
  {
    "problem": "Question with A) B) C) D) options...",
    "answer": "A",
    "subject": "Physics",
    "difficulty": "graduate"
  }
]
```

## Usage Instructions

1. **Obtain Datasets**: 
   - AIME problems can be found on the MAA website or mathematics competition archives
   - GPQA dataset can be accessed from the original paper/repository
   - Ensure you comply with any usage restrictions or licenses

2. **Format Data**:
   - Convert datasets to the JSON format shown above
   - Place files in the appropriate subdirectories
   - Use descriptive filenames (e.g., `aime_2024_problems.json`)

3. **Update Experiment Templates**:
   - Modify the experiment templates to load your data files
   - Update file paths in the template code
   - Adjust problem loading functions as needed

## Data Privacy and Ethics

- **No Personal Information**: Ensure datasets contain no personal or sensitive information
- **Academic Use**: This research code is intended for academic research purposes
- **Attribution**: Properly cite and acknowledge dataset sources
- **Compliance**: Follow all applicable data usage agreements and licenses

## Sample Data

For testing purposes, the experiment templates include small sample datasets. For full experiments, you'll need to provide the complete datasets in this directory.

## Processed Results

The `processed/` subdirectory will store:
- Experiment outputs and results
- Entropy calculations and statistics
- Performance metrics and analysis
- Generated plots and visualizations

Results are automatically saved with timestamps to avoid overwriting previous experiments.