(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    511286,      11492]
NotebookOptionsPosition[    502427,      11353]
NotebookOutlinePosition[    502858,      11370]
CellTagsIndexPosition[    502815,      11367]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"Phi", "[", "x_", "]"}], ":=", 
  RowBox[{
   RowBox[{"1", "/", "2"}], "+", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "*", 
    RowBox[{"Erf", "[", 
     RowBox[{"x", "/", 
      RowBox[{"Sqrt", "[", "2", "]"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.9090715658425207`*^9, 3.909071577395323*^9}},
 CellLabel->"In[6]:=",ExpressionUUID->"ab7aa9d6-d032-4f70-9390-16be15a00838"],

Cell[CellGroupData[{

Cell["Logarithmic derivative", "Chapter",
 CellChangeTimes->{{3.909072869326623*^9, 
  3.909072873376243*^9}},ExpressionUUID->"4c0c8a55-b48d-4c0c-b2fe-\
f815c3ce33b8"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", "*", 
         RowBox[{"m1", "[", "t", "]"}]}], "+", 
        RowBox[{"mu2", "*", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"mu1", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu1", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                  RowBox[{"sigma", "^", "2"}], "*", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"sigma", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                    "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
          " ", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"OwenT", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
            ")"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
           RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"Pi", "/", "8"}], "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
           "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", " ", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
              "2"}], " ", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Pi", "/", "8"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{"lam", "*", 
           RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], " ", "+", 
       RowBox[{"mu2", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu2", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                  RowBox[{"sigma", "^", "2"}], "*", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"sigma", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                    "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
          " ", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"OwenT", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
            ")"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
           RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"Pi", "/", "8"}], "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
           "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", " ", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
              "2"}], " ", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Pi", "/", "8"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], " ", "-", 
          RowBox[{"lam", "*", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], "-", " ", 
    RowBox[{
     RowBox[{"2", "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
        RowBox[{
         RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}]}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"m1", "[", "t", "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu1", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                  RowBox[{"sigma", "^", "2"}], "*", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"sigma", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                    "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
          " ", "-", 
          RowBox[{"mu1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"OwenT", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
            ")"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
           RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"Pi", "/", "8"}], "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
           "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", " ", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
              "2"}], " ", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Pi", "/", "8"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{"lam", "*", 
           RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"m2", "[", "t", "]"}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu2", "*", 
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                   RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                  RowBox[{"sigma", "^", "2"}], "*", 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
            RowBox[{
             RowBox[{"sigma", "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"2", "Pi"}], "]"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
             RowBox[{"Exp", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"-", "1"}], "/", "2"}], "*", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                    "2"}], 
                  RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}], 
          " ", "-", 
          RowBox[{"mu2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"Phi", "[", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"OwenT", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
            ")"}]}], "-", 
          RowBox[{
           RowBox[{"sigma", "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
           RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
           RowBox[{
            RowBox[{"Sqrt", "[", 
             RowBox[{"Pi", "/", "8"}], "]"}], "/", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{
                  RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                 RowBox[{
                  RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
               RowBox[{"sigma", "^", "2"}], 
               RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
           "*", 
           RowBox[{"Exp", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "1"}], "/", "2"}], "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", " ", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
              "2"}], " ", "*", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"Pi", "/", "8"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
          RowBox[{"lam", "*", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9090736637496367`*^9, 3.909073868545673*^9}, {
  3.909073899774128*^9, 3.909073921949782*^9}, {3.9090739530916843`*^9, 
  3.909073967291587*^9}, {3.909075877252596*^9, 3.90907590354919*^9}, {
  3.9090759478433933`*^9, 3.909075950649522*^9}},
 CellLabel->
  "In[327]:=",ExpressionUUID->"e7b7c3f3-f16e-4cad-abd3-918435c3b65c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{
    FractionBox["1", 
     RowBox[{"2", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "+", 
        RowBox[{"mu2", " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox["mu2", "2"], " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m1", "[", "t", "]"}], "2"]}], "-", 
      RowBox[{"2", " ", "mu1", " ", "mu2", " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       RowBox[{"m1", "[", "t", "]"}], " ", 
       RowBox[{"m2", "[", "t", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["mu1", "2"], " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       RowBox[{"Erfc", "[", 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SqrtBox["\[Pi]"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", " ", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", " ", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
       SuperscriptBox[
        RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"32", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "+", 
        RowBox[{"mu2", " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]], 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "8"]}], " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "mu2"}], " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "+", 
        RowBox[{"mu1", " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "4"}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox["1", "16"], " ", "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"mu1", " ", 
              RowBox[{"m1", "[", "t", "]"}]}], "+", 
             RowBox[{"mu2", " ", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", "mu1", 
        " ", "\[Pi]", " ", 
        RowBox[{"Erf", "[", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          SqrtBox["\[Pi]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu1", " ", 
             RowBox[{"m1", "[", "t", "]"}]}], "+", 
            RowBox[{"mu2", " ", 
             RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"m1", "[", "t", "]"}]}], "+", 
       RowBox[{
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          FractionBox["1", "16"], " ", "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             RowBox[{"mu1", " ", 
              RowBox[{"m1", "[", "t", "]"}]}], "+", 
             RowBox[{"mu2", " ", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", "mu2", 
        " ", "\[Pi]", " ", 
        RowBox[{"Erf", "[", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          SqrtBox["\[Pi]"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"mu1", " ", 
             RowBox[{"m1", "[", "t", "]"}]}], "+", 
            RowBox[{"mu2", " ", 
             RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
        RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], " ", 
     SuperscriptBox["sigma", "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "sigma", "]"}], "4"],
    SeriesData[$CellContext`sigma, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`sigma, 
   0, {((Rational[
       1, 2]/($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 \
$CellContext`m2[$CellContext`t]))/($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2)) ((($CellContext`mu2^2 
        Erfc[(Rational[-1, 4] 
           Pi^Rational[
             1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) 
       Erfc[(Rational[1, 4] 
          Pi^Rational[
            1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) \
$CellContext`m1[$CellContext`t]^2 - (((((2 $CellContext`mu1) $CellContext`mu2)
          Erfc[(Rational[-1, 4] 
           Pi^Rational[
             1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) 
       Erfc[(Rational[1, 4] 
          Pi^Rational[
            1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) \
$CellContext`m1[$CellContext`t]) $CellContext`m2[$CellContext`t] + \
(($CellContext`mu1^2 
        Erfc[(Rational[-1, 4] 
           Pi^Rational[
             1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) 
       Erfc[(Rational[1, 4] 
          Pi^Rational[
            1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) \
$CellContext`m2[$CellContext`t]^2), 
    0, (((Rational[1, 32] 
       E^((Rational[-1, 8] 
          Pi) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])^2)) ((-$CellContext`mu2) \
$CellContext`m1[$CellContext`t] + $CellContext`mu1 \
$CellContext`m2[$CellContext`t])^2)/($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t])) (-4 + (((
         E^((Rational[1, 16] 
            Pi) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])^2) $CellContext`mu1) Pi) 
       Erf[(Rational[1, 4] 
          Pi^Rational[
            1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) \
$CellContext`m1[$CellContext`t] + (((
         E^((Rational[1, 16] 
            Pi) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])^2) $CellContext`mu2) Pi) 
       Erf[(Rational[1, 4] 
          Pi^Rational[
            1, 2]) ($CellContext`mu1 $CellContext`m1[$CellContext`t] + \
$CellContext`mu2 $CellContext`m2[$CellContext`t])]) \
$CellContext`m2[$CellContext`t])}, 0, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{3.909073968413065*^9, 3.909075905108467*^9, 
  3.9090759514766197`*^9},
 CellLabel->
  "Out[327]=",ExpressionUUID->"d2549795-7f16-499d-b964-bba71c6b4ad5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "4"}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["1", "16"], " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", "mu1", " ",
      "\[Pi]", " ", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"mu1", " ", 
          RowBox[{"m1", "[", "t", "]"}]}], "+", 
         RowBox[{"mu2", " ", 
          RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
     RowBox[{"m1", "[", "t", "]"}]}], "+", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       FractionBox["1", "16"], " ", "\[Pi]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "+", 
          RowBox[{"mu2", " ", 
           RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", "mu2", " ",
      "\[Pi]", " ", 
     RowBox[{"Erf", "[", 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SqrtBox["\[Pi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"mu1", " ", 
          RowBox[{"m1", "[", "t", "]"}]}], "+", 
         RowBox[{"mu2", " ", 
          RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
     RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], " ", "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.909073995562356*^9, 3.909073997642178*^9}},
 CellLabel->
  "In[304]:=",ExpressionUUID->"9d7b5d07-0931-4ea8-b921-cfbfca82be73"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "4"}], "+", 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     FractionBox["1", "16"], " ", "\[Pi]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"mu1", " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "+", 
        RowBox[{"mu2", " ", 
         RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "2"]}]], " ", "\[Pi]", " ", 
   RowBox[{"Erf", "[", 
    RowBox[{
     FractionBox["1", "4"], " ", 
     SqrtBox["\[Pi]"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"mu1", " ", 
        RowBox[{"m1", "[", "t", "]"}]}], "+", 
       RowBox[{"mu2", " ", 
        RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"mu1", " ", 
      RowBox[{"m1", "[", "t", "]"}]}], "+", 
     RowBox[{"mu2", " ", 
      RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.9090739981042757`*^9},
 CellLabel->
  "Out[304]=",ExpressionUUID->"7dc07ded-3d81-4581-a98a-19336356192d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", "*", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", "*", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu1", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma1", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m1", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], " ", "+", 
          RowBox[{"mu2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu2", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma2", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m2", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], " ", 
             "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], "-", " ", 
       RowBox[{
        RowBox[{"2", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "*", 
            RowBox[{"sigma1", "^", "2"}]}], "+", 
           RowBox[{
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], "^", "2"}], "*", 
            RowBox[{"sigma2", "^", "2"}]}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", "t", "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu1", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma1", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m1", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"m2", "[", "t", "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu2", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma2", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m2", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}]}], "//", 
      "FullSimplify"}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu1", "\[Rule]", "1"}], ",", 
      RowBox[{"mu2", "\[Rule]", "0"}], ",", 
      RowBox[{"sigma1", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma2", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.916757095539312*^9, 3.916757102428308*^9}},
 CellLabel->"In[7]:=",ExpressionUUID->"fa9af152-7ad4-4b78-9e83-45b68265940c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox[
    RowBox[{"2", " ", "lam", " ", 
     SuperscriptBox[
      RowBox[{"m2", "[", "t", "]"}], "2"]}], 
    SuperscriptBox[
     RowBox[{"m1", "[", "t", "]"}], "2"]], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"lam", " ", 
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
       RowBox[{"lam", " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "4"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"m1", "[", "t", "]"}], " ", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
        RowBox[{"OwenT", "[", 
         RowBox[{
          FractionBox[
           RowBox[{
            SqrtBox["\[Pi]"], " ", 
            RowBox[{"m1", "[", "t", "]"}]}], 
           SqrtBox[
            RowBox[{"8", "+", 
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
          FractionBox["2", 
           SqrtBox[
            RowBox[{"4", "+", 
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], ")"}], 
     " ", 
     SuperscriptBox["sigma2", "2"]}], 
    SuperscriptBox[
     RowBox[{"m1", "[", "t", "]"}], "4"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "sigma2", "]"}], "4"],
    SeriesData[$CellContext`sigma2, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`sigma2, 
   0, {((2 $CellContext`lam) $CellContext`m1[$CellContext`t]^(-2)) \
$CellContext`m2[$CellContext`t]^2, 
    0, ((-2) $CellContext`m1[$CellContext`t]^(-4)) (($CellContext`lam \
$CellContext`m1[$CellContext`t]^2) $CellContext`m2[$CellContext`t]^2 + \
$CellContext`lam $CellContext`m2[$CellContext`t]^4 - ((
       2 $CellContext`m1[$CellContext`t]) $CellContext`m2[$CellContext`t]^2) 
     OwenT[(Pi^Rational[1, 2] $CellContext`m1[$CellContext`t]) (8 + 
         Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2], 
       2 (4 + Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2]])}, 0, 4, 
   1],
  Editable->False]], "Output",
 CellChangeTimes->{3.916757139098362*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"1bb37764-3a17-450e-8d36-db8912793999"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Anisotropic Logarithmic derivative", "Chapter",
 CellChangeTimes->{{3.909072869326623*^9, 3.909072873376243*^9}, {
  3.9158135414083633`*^9, 
  3.915813546783689*^9}},ExpressionUUID->"00d84e8e-0c64-4609-907d-\
2dc86eff17ec"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"2", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"mu1", "*", 
            RowBox[{"m1", "[", "t", "]"}]}], "+", 
           RowBox[{"mu2", "*", 
            RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"mu1", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu1", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma1", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m1", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], " ", "+", 
          RowBox[{"mu2", "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu2", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma2", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m2", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], " ", 
             "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}], "-", " ", 
       RowBox[{
        RowBox[{"2", "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}]}], "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"m1", "[", "t", "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu1", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma1", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu1", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma1", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m1", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], "+", 
          RowBox[{
           RowBox[{"m2", "[", "t", "]"}], "*", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"mu2", "*", 
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
               RowBox[{
                RowBox[{
                 RowBox[{"sigma2", "^", "2"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"2", "Pi"}], "]"}]}], 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "  ", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", "1"}], "/", "2"}], "*", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
              " ", "-", 
             RowBox[{"mu2", "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"Phi", "[", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                  RowBox[{
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                RowBox[{"2", 
                 RowBox[{"OwenT", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                   RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
               ")"}]}], "-", 
             RowBox[{
              RowBox[{
               RowBox[{"sigma2", "^", "2"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
              RowBox[{"m2", "[", "t", "]"}], "  ", 
              RowBox[{
               RowBox[{"Sqrt", "[", 
                RowBox[{"Pi", "/", "8"}], "]"}], "/", 
               RowBox[{"Sqrt", "[", 
                RowBox[{"1", "+", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                  RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
              RowBox[{"Phi", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                RowBox[{
                 RowBox[{"Sqrt", "[", 
                  RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                 RowBox[{"Sqrt", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
              "*", 
              RowBox[{"Exp", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"-", "1"}], "/", "2"}], "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   " ", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                  "2"}], " ", "*", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                 RowBox[{"(", 
                  RowBox[{"1", "+", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma1", "^", "2"}]}], "+", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}], 
                    RowBox[{"sigma2", "^", "2"}]}]}], ")"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], "-", 
             RowBox[{"lam", "*", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}]}], ")"}]}]}], "//", 
      "FullSimplify"}], ")"}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"mu1", "\[Rule]", "1"}], ",", 
      RowBox[{"mu2", "\[Rule]", "0"}], ",", 
      RowBox[{"sigma1", "\[Rule]", "1"}]}], "}"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma2", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.9090736637496367`*^9, 3.909073868545673*^9}, {
  3.909073899774128*^9, 3.909073921949782*^9}, {3.9090739530916843`*^9, 
  3.909073967291587*^9}, {3.909075877252596*^9, 3.90907590354919*^9}, {
  3.9090759478433933`*^9, 3.909075950649522*^9}, {3.915813562170397*^9, 
  3.9158138831457033`*^9}, {3.915813915680337*^9, 3.9158139432359858`*^9}, {
  3.9158913894674892`*^9, 3.9158914109460163`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"2fa32f83-73b3-46dd-9d37-cf93d889c4f4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"Erf", "[", 
          FractionBox[
           RowBox[{
            SqrtBox[
             RowBox[{"2", " ", "\[Pi]"}]], " ", 
            RowBox[{"m1", "[", "t", "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], "]"}], 
         " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
         SqrtBox[
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
         RowBox[{"OwenT", "[", 
          RowBox[{
           FractionBox[
            RowBox[{
             SqrtBox["\[Pi]"], " ", 
             RowBox[{"m1", "[", "t", "]"}]}], 
            SqrtBox[
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
           FractionBox["2", 
            SqrtBox[
             RowBox[{"4", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], 
       ")"}]}], 
     RowBox[{
      RowBox[{"m1", "[", "t", "]"}], " ", 
      SqrtBox[
       RowBox[{"8", "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]]}], "+", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"m1", "[", "t", "]"}], " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
        SuperscriptBox[
         RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]], 
    RowBox[{
     RowBox[{"m2", "[", "t", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         RowBox[{"m2", "[", "t", "]"}]}], " ", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}], 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
            SuperscriptBox["\[Pi]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
             RowBox[{"5", "/", "2"}]]}]], "-", 
          FractionBox[
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             RowBox[{"-", 
              FractionBox[
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}], 
               RowBox[{"2", " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ",
             "\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m2", "[", "t", "]"}], "2"]}], 
           RowBox[{"2", " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
             RowBox[{"3", "/", "2"}]]}]]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SqrtBox["2"], " ", 
           RowBox[{"Erf", "[", 
            FractionBox[
             RowBox[{
              SqrtBox[
               RowBox[{"2", " ", "\[Pi]"}]], " ", 
              RowBox[{"m1", "[", "t", "]"}]}], 
             SqrtBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], "]"}], 
           " ", 
           RowBox[{"m1", "[", "t", "]"}]}], "-", 
          RowBox[{"4", " ", 
           SuperscriptBox["\[ExponentialE]", 
            FractionBox[
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"8", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
           SqrtBox[
            RowBox[{"8", "+", 
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
           RowBox[{"OwenT", "[", 
            RowBox[{
             FractionBox[
              RowBox[{
               SqrtBox["\[Pi]"], " ", 
               RowBox[{"m1", "[", "t", "]"}]}], 
              SqrtBox[
               RowBox[{"8", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
             FractionBox["2", 
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], 
         ")"}]}], "-", 
       RowBox[{
        FractionBox["1", 
         SqrtBox[
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{"-", 
           FractionBox[
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}], 
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SqrtBox["2"], " ", 
            RowBox[{"m1", "[", "t", "]"}], " ", 
            RowBox[{"m2", "[", "t", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               RowBox[{"Erf", "[", 
                FractionBox[
                 RowBox[{
                  SqrtBox[
                   RowBox[{"2", " ", "\[Pi]"}]], " ", 
                  RowBox[{"m1", "[", "t", "]"}]}], 
                 SqrtBox[
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
                   RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], 
                "]"}]}], "-", 
              FractionBox[
               RowBox[{"2", " ", 
                SqrtBox["2"], " ", 
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  FractionBox[
                   RowBox[{"2", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                   RowBox[{"32", "+", 
                    RowBox[{"12", " ", "\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
                    RowBox[{
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "4"]}]}]]}]], " ", 
                RowBox[{"m1", "[", "t", "]"}], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"6", " ", "\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
                  RowBox[{
                   SuperscriptBox["\[Pi]", "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                   SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
                SqrtBox[
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
                  RowBox[{"(", 
                   RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]]}], 
             ")"}]}], "-", 
           RowBox[{"4", " ", 
            RowBox[{"m2", "[", "t", "]"}], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               SuperscriptBox["\[ExponentialE]", 
                FractionBox[
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                 RowBox[{"2", " ", 
                  RowBox[{"(", 
                   RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
               SqrtBox[
                RowBox[{"8", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
               RowBox[{"(", 
                RowBox[{
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ",
                    "\[Pi]", " ", 
                   RowBox[{"Erf", "[", 
                    FractionBox[
                    RowBox[{
                    SqrtBox[
                    RowBox[{"2", " ", "\[Pi]"}]], " ", 
                    RowBox[{"m1", "[", "t", "]"}]}], 
                    RowBox[{
                    SqrtBox[
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
                    SqrtBox[
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], "]"}], " ", 
                   RowBox[{"m1", "[", "t", "]"}], " ", 
                   SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}], 
                  RowBox[{"4", " ", 
                   SqrtBox["2"], " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                    RowBox[{"3", "/", "2"}]]}]], "-", 
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    RowBox[{"-", 
                    FractionBox[
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    FractionBox["4", 
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}], ")"}]}], 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
                   SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}], 
                  RowBox[{"2", " ", 
                   SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                    RowBox[{"3", "/", "2"}]], " ", 
                   RowBox[{"(", 
                    RowBox[{"1", "+", 
                    FractionBox["4", 
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}], ")"}]}]]}], 
                ")"}]}], "+", 
              RowBox[{
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"-", 
                  FractionBox[
                   RowBox[{
                    SuperscriptBox["\[ExponentialE]", 
                    FractionBox[
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
                    SuperscriptBox["\[Pi]", "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                    SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}], 
                   RowBox[{"2", " ", 
                    SuperscriptBox[
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                    RowBox[{"3", "/", "2"}]]}]]}], "+", 
                 FractionBox[
                  RowBox[{
                   SuperscriptBox["\[ExponentialE]", 
                    FractionBox[
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                    RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
                   "\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m2", "[", "t", "]"}], "2"]}], 
                  RowBox[{"2", " ", 
                   SqrtBox[
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]]}], ")"}], " ", 
               RowBox[{"OwenT", "[", 
                RowBox[{
                 FractionBox[
                  RowBox[{
                   SqrtBox["\[Pi]"], " ", 
                   RowBox[{"m1", "[", "t", "]"}]}], 
                  SqrtBox[
                   RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
                 FractionBox["2", 
                  SqrtBox[
                   RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], 
             ")"}]}]}], ")"}]}]}]}], ")"}], " ", 
     SuperscriptBox["sigma2", "2"]}]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "sigma2", "]"}], "4"],
    SeriesData[$CellContext`sigma2, 0, {}, 0, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`sigma2, 
   0, {(((((-
         E^((Rational[-1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
            Pi $CellContext`m1[$CellContext`t]^2))))/$CellContext`m1[$\
CellContext`t]) (8 + Pi $CellContext`m1[$CellContext`t]^2)^
        Rational[-1, 
          2]) $CellContext`m2[$CellContext`t]^2)/($CellContext`m1[$\
CellContext`t]^2 + $CellContext`m2[$CellContext`t]^2)) ((2^Rational[1, 2] 
       Erf[((2 Pi)^
           Rational[1, 2] $CellContext`m1[$CellContext`t]) ((4 + 
            Pi $CellContext`m1[$CellContext`t]^2) (8 + 
            Pi $CellContext`m1[$CellContext`t]^2))^
          Rational[-1, 2]]) $CellContext`m1[$CellContext`t] - ((4 
       E^((Rational[1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
          Pi $CellContext`m1[$CellContext`t]^2)))) (8 + 
        Pi $CellContext`m1[$CellContext`t]^2)^Rational[1, 2]) 
     OwenT[(Pi^Rational[1, 2] $CellContext`m1[$CellContext`t]) (8 + 
         Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2], 
       2 (4 + Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2]]), 
    0, (($CellContext`m1[$CellContext`t]^(-1) \
$CellContext`m2[$CellContext`t])/($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2)) (((-$CellContext`m2[$CellContext`t]) (((((
             Rational[1, 2] 
             E^((Rational[-1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
                Pi $CellContext`m1[$CellContext`t]^2)))) 
            Pi^2) $CellContext`m1[$CellContext`t]^2) (8 + 
            Pi $CellContext`m1[$CellContext`t]^2)^
           Rational[-5, 2]) $CellContext`m2[$CellContext`t]^2 + (((
            Rational[-1, 2] 
            E^((Rational[-1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
               Pi $CellContext`m1[$CellContext`t]^2)))) 
           Pi) (8 + Pi $CellContext`m1[$CellContext`t]^2)^
           Rational[-3, 2]) $CellContext`m2[$CellContext`t]^2)) ((
         2^Rational[1, 2] 
         Erf[((2 Pi)^
             Rational[1, 2] $CellContext`m1[$CellContext`t]) ((4 + 
              Pi $CellContext`m1[$CellContext`t]^2) (8 + 
              Pi $CellContext`m1[$CellContext`t]^2))^
            Rational[-1, 2]]) $CellContext`m1[$CellContext`t] - ((4 
         E^((Rational[1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
            Pi $CellContext`m1[$CellContext`t]^2)))) (8 + 
          Pi $CellContext`m1[$CellContext`t]^2)^Rational[1, 2]) 
       OwenT[(Pi^Rational[1, 2] $CellContext`m1[$CellContext`t]) (8 + 
           Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2], 
         2 (4 + Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2]]) - (
      E^((Rational[-1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
         Pi $CellContext`m1[$CellContext`t]^2))) (8 + 
        Pi $CellContext`m1[$CellContext`t]^2)^
       Rational[-1, 2]) (((
         2^Rational[
           1, 2] $CellContext`m1[$CellContext`t]) \
$CellContext`m2[$CellContext`t]) (-
         Erf[((2 Pi)^
             Rational[1, 2] $CellContext`m1[$CellContext`t]) ((4 + 
              Pi $CellContext`m1[$CellContext`t]^2) (8 + 
              Pi $CellContext`m1[$CellContext`t]^2))^
            Rational[-1, 2]] - ((((((2 2^Rational[1, 2]) 
             E^(((-2) Pi) ($CellContext`m1[$CellContext`t]^2/(
                32 + (12 Pi) $CellContext`m1[$CellContext`t]^2 + 
                Pi^2 $CellContext`m1[$CellContext`t]^4)))) \
$CellContext`m1[$CellContext`t])/(4 + Pi $CellContext`m1[$CellContext`t]^2))/(
          8 + Pi $CellContext`m1[$CellContext`t]^2)) ((4 + 
            Pi $CellContext`m1[$CellContext`t]^2) (8 + 
            Pi $CellContext`m1[$CellContext`t]^2))^
          Rational[-1, 2]) ((6 Pi) $CellContext`m2[$CellContext`t]^2 + (
           Pi^2 $CellContext`m1[$CellContext`t]^2) \
$CellContext`m2[$CellContext`t]^2)) - (
       4 $CellContext`m2[$CellContext`t]) ((
         E^((Rational[1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
            Pi $CellContext`m1[$CellContext`t]^2))) (8 + 
           Pi $CellContext`m1[$CellContext`t]^2)^
          Rational[
           1, 2]) (((((((Rational[1, 4] 2^Rational[-1, 2]) 
               E^((Rational[-1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
                  Pi $CellContext`m1[$CellContext`t]^2)))) Pi) 
             Erf[(((2 Pi)^Rational[1, 2] $CellContext`m1[$CellContext`t]) (4 + 
                  Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2]) (8 + 
                 Pi $CellContext`m1[$CellContext`t]^2)^
                Rational[-1, 2]]) $CellContext`m1[$CellContext`t]) (8 + 
             Pi $CellContext`m1[$CellContext`t]^2)^
            Rational[-3, 2]) $CellContext`m2[$CellContext`t]^2 + (((
             Rational[-1, 2] 
             E^((((Rational[-1, 2] Pi) $CellContext`m1[$CellContext`t]^2)/(8 + 
                Pi $CellContext`m1[$CellContext`t]^2)) (1 + 
                4/(4 + Pi $CellContext`m1[$CellContext`t]^2)))) (4 + 
              Pi $CellContext`m1[$CellContext`t]^2)^Rational[-3, 2])/(1 + 
           4/(4 + Pi $CellContext`m1[$CellContext`t]^2))) \
$CellContext`m2[$CellContext`t]^2) + (((((Rational[-1, 2] 
              E^((Rational[1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
                 Pi $CellContext`m1[$CellContext`t]^2)))) 
             Pi^2) $CellContext`m1[$CellContext`t]^2) (8 + 
             Pi $CellContext`m1[$CellContext`t]^2)^
            Rational[-3, 2]) $CellContext`m2[$CellContext`t]^2 + (((
             Rational[1, 2] 
             E^((Rational[1, 2] Pi) ($CellContext`m1[$CellContext`t]^2/(8 + 
                Pi $CellContext`m1[$CellContext`t]^2)))) 
            Pi) (8 + Pi $CellContext`m1[$CellContext`t]^2)^
            Rational[-1, 2]) $CellContext`m2[$CellContext`t]^2) 
        OwenT[(Pi^Rational[1, 2] $CellContext`m1[$CellContext`t]) (8 + 
            Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2], 
          2 (4 + Pi $CellContext`m1[$CellContext`t]^2)^Rational[-1, 2]])))}, 
   0, 4, 1],
  Editable->False]], "Output",
 CellChangeTimes->{
  3.9158138852613277`*^9, {3.915813920416024*^9, 3.915813946744397*^9}, {
   3.91589139246408*^9, 3.915891411954207*^9}},
 CellLabel->"Out[18]=",ExpressionUUID->"f8e749b1-a75d-4f9c-8ee1-b0f695e3c978"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     RowBox[{"m1", "[", "t", "]"}], " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
       SuperscriptBox[
        RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]], 
   RowBox[{"m2", "[", "t", "]"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", 
       RowBox[{"m2", "[", "t", "]"}]}], " ", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"8", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
           RowBox[{"5", "/", "2"}]]}]], "-", 
        FractionBox[
         RowBox[{
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{"-", 
            FractionBox[
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}], 
             RowBox[{"2", " ", 
              RowBox[{"(", 
               RowBox[{"8", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
          "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m2", "[", "t", "]"}], "2"]}], 
         RowBox[{"2", " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"8", "+", 
             RowBox[{"\[Pi]", " ", 
              SuperscriptBox[
               RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
           RowBox[{"3", "/", "2"}]]}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"Erf", "[", 
          FractionBox[
           RowBox[{
            SqrtBox[
             RowBox[{"2", " ", "\[Pi]"}]], " ", 
            RowBox[{"m1", "[", "t", "]"}]}], 
           SqrtBox[
            RowBox[{
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], "]"}], 
         " ", 
         RowBox[{"m1", "[", "t", "]"}]}], "-", 
        RowBox[{"4", " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox[
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}], 
           RowBox[{"2", " ", 
            RowBox[{"(", 
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
         SqrtBox[
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
         RowBox[{"OwenT", "[", 
          RowBox[{
           FractionBox[
            RowBox[{
             SqrtBox["\[Pi]"], " ", 
             RowBox[{"m1", "[", "t", "]"}]}], 
            SqrtBox[
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
           FractionBox["2", 
            SqrtBox[
             RowBox[{"4", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], 
       ")"}]}], "-", 
     RowBox[{
      FractionBox["1", 
       SqrtBox[
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{"-", 
        FractionBox[
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}], 
         RowBox[{"2", " ", 
          RowBox[{"(", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         SqrtBox["2"], " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", 
            RowBox[{"Erf", "[", 
             FractionBox[
              RowBox[{
               SqrtBox[
                RowBox[{"2", " ", "\[Pi]"}]], " ", 
               RowBox[{"m1", "[", "t", "]"}]}], 
              SqrtBox[
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"4", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
                RowBox[{"(", 
                 RowBox[{"8", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], 
             "]"}]}], "-", 
           FractionBox[
            RowBox[{"2", " ", 
             SqrtBox["2"], " ", 
             SuperscriptBox["\[ExponentialE]", 
              RowBox[{"-", 
               FractionBox[
                RowBox[{"2", " ", "\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                RowBox[{"32", "+", 
                 RowBox[{"12", " ", "\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
                 RowBox[{
                  SuperscriptBox["\[Pi]", "2"], " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "4"]}]}]]}]], " ", 
             RowBox[{"m1", "[", "t", "]"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"6", " ", "\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
               RowBox[{
                SuperscriptBox["\[Pi]", "2"], " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                SuperscriptBox[
                 RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"4", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{"8", "+", 
               RowBox[{"\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
             SqrtBox[
              RowBox[{
               RowBox[{"(", 
                RowBox[{"4", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]]}], 
          ")"}]}], "-", 
        RowBox[{"4", " ", 
         RowBox[{"m2", "[", "t", "]"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            SuperscriptBox["\[ExponentialE]", 
             FractionBox[
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}], 
              RowBox[{"2", " ", 
               RowBox[{"(", 
                RowBox[{"8", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
            SqrtBox[
             RowBox[{"8", "+", 
              RowBox[{"\[Pi]", " ", 
               SuperscriptBox[
                RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  FractionBox[
                   RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ",
                 "\[Pi]", " ", 
                RowBox[{"Erf", "[", 
                 FractionBox[
                  RowBox[{
                   SqrtBox[
                    RowBox[{"2", " ", "\[Pi]"}]], " ", 
                   RowBox[{"m1", "[", "t", "]"}]}], 
                  RowBox[{
                   SqrtBox[
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
                   SqrtBox[
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], "]"}], " ", 
                RowBox[{"m1", "[", "t", "]"}], " ", 
                SuperscriptBox[
                 RowBox[{"m2", "[", "t", "]"}], "2"]}], 
               RowBox[{"4", " ", 
                SqrtBox["2"], " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"8", "+", 
                   RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                 RowBox[{"3", "/", "2"}]]}]], "-", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 RowBox[{"-", 
                  FractionBox[
                   RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    FractionBox["4", 
                    RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}], ")"}]}], 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]}]], " ", 
                SuperscriptBox[
                 RowBox[{"m2", "[", "t", "]"}], "2"]}], 
               RowBox[{"2", " ", 
                SuperscriptBox[
                 RowBox[{"(", 
                  RowBox[{"4", "+", 
                   RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                 RowBox[{"3", "/", "2"}]], " ", 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  FractionBox["4", 
                   RowBox[{"4", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}], ")"}]}]]}], 
             ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", 
               FractionBox[
                RowBox[{
                 SuperscriptBox["\[ExponentialE]", 
                  FractionBox[
                   RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                   RowBox[{"2", " ", 
                    RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
                 SuperscriptBox["\[Pi]", "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
                 SuperscriptBox[
                  RowBox[{"m2", "[", "t", "]"}], "2"]}], 
                RowBox[{"2", " ", 
                 SuperscriptBox[
                  RowBox[{"(", 
                   RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
                  RowBox[{"3", "/", "2"}]]}]]}], "+", 
              FractionBox[
               RowBox[{
                SuperscriptBox["\[ExponentialE]", 
                 FractionBox[
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}], 
                  RowBox[{"2", " ", 
                   RowBox[{"(", 
                    RowBox[{"8", "+", 
                    RowBox[{"\[Pi]", " ", 
                    SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}]]], " ", 
                "\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m2", "[", "t", "]"}], "2"]}], 
               RowBox[{"2", " ", 
                SqrtBox[
                 RowBox[{"8", "+", 
                  RowBox[{"\[Pi]", " ", 
                   SuperscriptBox[
                    RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]]}], ")"}], " ", 
            RowBox[{"OwenT", "[", 
             RowBox[{
              FractionBox[
               RowBox[{
                SqrtBox["\[Pi]"], " ", 
                RowBox[{"m1", "[", "t", "]"}]}], 
               SqrtBox[
                RowBox[{"8", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], ",", 
              FractionBox["2", 
               SqrtBox[
                RowBox[{"4", "+", 
                 RowBox[{"\[Pi]", " ", 
                  SuperscriptBox[
                   RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]]}], "]"}]}]}], 
          ")"}]}]}], ")"}]}]}], ")"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.915891467791185*^9, 3.915891506410089*^9}},
 CellLabel->"In[21]:=",ExpressionUUID->"be4a7bc1-934e-439f-9e77-c16b1bb856f7"],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"8", "+", 
       RowBox[{"\[Pi]", " ", 
        SuperscriptBox[
         RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], 
     RowBox[{"5", "/", "2"}]], " ", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "2"], "+", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], ")"}]}]], 
  SuperscriptBox[
   RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"2", " ", 
     SqrtBox["2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["4", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], " ", 
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"m1", "[", "t", "]"}], 
       SqrtBox[
        RowBox[{
         FractionBox["16", "\[Pi]"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "4"]}]}]]], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"8", "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"]}], "-", 
    RowBox[{
     SqrtBox["2"], " ", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "2"]}], "+", 
       FractionBox["4", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], " ", 
     SuperscriptBox["\[Pi]", "2"], " ", 
     RowBox[{"Erf", "[", 
      FractionBox[
       RowBox[{"m1", "[", "t", "]"}], 
       SqrtBox[
        RowBox[{
         FractionBox["16", "\[Pi]"], "+", 
         RowBox[{"6", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "4"]}]}]]], "]"}], " ", 
     SuperscriptBox[
      RowBox[{"m1", "[", "t", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"m2", "[", "t", "]"}], "2"]}], "+", 
    FractionBox[
     RowBox[{"48", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        FractionBox["2", 
         RowBox[{"4", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], " ", "\[Pi]", " ", 
      RowBox[{"m1", "[", "t", "]"}], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], "+", 
    FractionBox[
     RowBox[{"8", " ", 
      SuperscriptBox["\[ExponentialE]", 
       RowBox[{
        RowBox[{"-", 
         FractionBox["1", "2"]}], "+", 
        FractionBox["2", 
         RowBox[{"4", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], " ", 
      SuperscriptBox["\[Pi]", "2"], " ", 
      SuperscriptBox[
       RowBox[{"m1", "[", "t", "]"}], "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"8", "+", 
         RowBox[{"\[Pi]", " ", 
          SuperscriptBox[
           RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], "2"], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{"8", "+", 
          RowBox[{"\[Pi]", " ", 
           SuperscriptBox[
            RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}]}], ")"}], 
      RowBox[{"3", "/", "2"}]]], "+", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"8", "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "4"}], " ", 
         SuperscriptBox["\[ExponentialE]", 
          FractionBox["2", 
           RowBox[{"4", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], " ", 
         SqrtBox[
          RowBox[{"8", "+", 
           RowBox[{"\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}], "+", 
        RowBox[{
         SuperscriptBox["\[ExponentialE]", 
          FractionBox["4", 
           RowBox[{"8", "+", 
            RowBox[{"\[Pi]", " ", 
             SuperscriptBox[
              RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]], " ", "\[Pi]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Erf", "[", 
            FractionBox[
             RowBox[{
              SqrtBox[
               RowBox[{"2", " ", "\[Pi]"}]], " ", 
              RowBox[{"m1", "[", "t", "]"}]}], 
             RowBox[{
              SqrtBox[
               RowBox[{"4", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}]], " ", 
              SqrtBox[
               RowBox[{"8", "+", 
                RowBox[{"\[Pi]", " ", 
                 SuperscriptBox[
                  RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]], "]"}], "+", 
           RowBox[{"Erf", "[", 
            FractionBox[
             RowBox[{"m1", "[", "t", "]"}], 
             SqrtBox[
              RowBox[{
               FractionBox["16", "\[Pi]"], "+", 
               RowBox[{"6", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "2"]}], "+", 
               RowBox[{
                FractionBox["1", "2"], " ", "\[Pi]", " ", 
                SuperscriptBox[
                 RowBox[{"m1", "[", "t", "]"}], "4"]}]}]]], "]"}]}], ")"}], 
         " ", 
         RowBox[{"m1", "[", "t", "]"}], " ", 
         SqrtBox[
          RowBox[{"8", "+", 
           RowBox[{"2", " ", "\[Pi]", " ", 
            SuperscriptBox[
             RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]}], ")"}], " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}], 
     RowBox[{
      SqrtBox["\[ExponentialE]"], " ", 
      RowBox[{"m1", "[", "t", "]"}], " ", 
      SqrtBox[
       RowBox[{"4", "+", 
        RowBox[{"\[Pi]", " ", 
         SuperscriptBox[
          RowBox[{"m1", "[", "t", "]"}], "2"]}]}]]}]]}], ")"}]}]], "Input",
 CellChangeTimes->{3.915891577369829*^9},
 CellLabel->"Out[21]=",ExpressionUUID->"2944b6cb-92d0-450e-a86d-275beae0cc79"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Out", "[", "21", "]"}], "/.", 
  RowBox[{
   RowBox[{"m1", "[", "t", "]"}], "\[Rule]", "0.4"}]}]], "Input",
 CellChangeTimes->{{3.915891692605822*^9, 3.915891711364647*^9}, {
  3.915892933079574*^9, 3.915892950971006*^9}},
 CellLabel->"In[29]:=",ExpressionUUID->"37ec219e-aa95-4bca-930f-bc9d9c34739d"],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.0023718304073581204`", " ", 
   SuperscriptBox[
    RowBox[{"m2", "[", "t", "]"}], "2"], " ", 
   RowBox[{"(", 
    RowBox[{"35.985058665469495`", "\[VeryThinSpace]", "-", 
     RowBox[{"78.72767343525616`", " ", 
      SuperscriptBox[
       RowBox[{"m2", "[", "t", "]"}], "2"]}]}], ")"}]}], 
  RowBox[{"0.16000000000000003`", "\[VeryThinSpace]", "+", 
   SuperscriptBox[
    RowBox[{"m2", "[", "t", "]"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.915891703649343*^9, 3.915891711716634*^9}, {
  3.915892933708354*^9, 3.915892951382765*^9}},
 CellLabel->"Out[29]=",ExpressionUUID->"1806131e-481d-497a-a84d-afaca04ca683"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Out", "[", "21", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m1", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"m2", "[", "t", "]"}], ",", "0", ",", "1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.915891581275117*^9, 3.915891629724862*^9}},
 CellLabel->"In[23]:=",ExpressionUUID->"317d36eb-82cc-431e-ba5e-96ebbff014e3"],

Cell[BoxData[
 Graphics3DBox[{GraphicsComplex3DBox[CompressedData["
1:eJy1vXlcjd33/1+ZZcqYmaTITAjVkQxlyFyZp5AhUmSmgUzNc2keVTQLhRMN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    "], {{
      {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
        GrayLevel[1], 3], 
       StyleBox[GraphicsGroup3DBox[
         TagBox[{Polygon3DBox[CompressedData["
1:eJw1mgf8T9X/xz+fe+/53JafbEWyQkMURSqEhPb+NUlSP5WWSGkoKg1lpIHs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            "]], Polygon3DBox[CompressedData["
1:eJwtmgf8j1Ubxp//7zzn+Wlok0glGQ2RQr1vRJlp0N5ltieVFgrtMppGsors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            "]], 
           Polygon3DBox[CompressedData["
1:eJwt13ncTmUex/Hb8zz3LVsIyZY1JRlESqWylZYZ0dRMKTUYM+oVTZY0IWNN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            "]], 
           Polygon3DBox[{{1463, 963, 1090, 1798, 1300, 1301}, {1776, 1051, 
            858, 509, 508, 1393}, {1601, 545, 501, 738, 1143, 1600}, {1598, 
            1141, 1098, 528, 517, 1687}}]},
          Annotation[#, "Charting`Private`Tag$50534#1"]& ]],
        Lighting->{{"Ambient", 
           RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
          "Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{0, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 2, 2}]}, {"Directional", 
           RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
           ImageScaled[{2, 0, 2}]}}]}, 
      {GrayLevel[1], EdgeForm[None], 
       StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFV2lsVlUQfe9+792PpRaCiREUkUUFi0RlUQqoUSOLtUBbuoBsDQiUQktR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           "]], Polygon3DBox[CompressedData["
1:eJw1lmmoV1UUxe+9//s/f5+aikGkOVupadFglj4tKcgSc3y+QUvLylnf85mm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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt0E0rhFEchvFjhplIQ1aTspglJqWIr6CQxsKGBRYsvG5HQ+zIxoImbwsL
FkoZr0WKja0VC8oHEL6C39NjcdW5r3P/zznPk5uYL8wlQghZ1KA7FcJCdQgj
qKsKIS23IWFd4EbRLlcwbjDPF82V5Sd7P9Y7/DZ2uVtu1noGWd0l+ddFD9bL
XAkHerXpEOaiLsrOGNZ5487leZ3okXVyr26X2b5kCIv2euQV3VczrfIJGvX2
+A0z6+iw98E3peKzv82OyWm9d+5FzqDdua3yKQbN3egcokHvk/vRyaNTLydf
ufdRPtJ55UrcZSr+3ui7i9XxmzNcs/1JfiIR/6sm/tp+BR32WrhNfFkP6dzx
xzold2xxa/Iq6rkzXFgP6PUjk47vjt4wLU9h//+OJDcm3+s/y3+brDko
           "]], 
          Polygon3DBox[{{1686, 585, 1210, 1204, 214, 1407}, {1702, 587, 199, 
           1050, 1175, 1806}}]}],
        Lighting->{{"Ambient", 
           GrayLevel[0.8]}}]}, {}, {}, {}}, {
      {GrayLevel[0], Line3DBox[CompressedData["
1:eJwt081Pz3EAwPHPr+c89SRhRIkoeQgVkkg1c+vIxdwqKp0c3G1dbW3Nw0+1
WLNKo5mLx/+gCynSzcHBbCXPXh9zeO/1efj2+ba+n0oudLd1JUIIL3XOII4H
UkLYpPXK0kZt0FBGCJncrSptV7meWN/BbO3RXu3UPesV3KUV2qf9StVje4eZ
pmpVaqWOqF5HNeqZdObqgI7poBb9kiVM2m9ghvJ0SE16kRbCH88sqdR82HNl
3KbNyletTqlGI/bXsVirVKDVum29iF+ds4VrtFbPnT9pLxgv29vKbyzkA+s5
bFaLjmvC2gk2qlXfPfvMGSeNx+0l+MNaHcfMfxr/0h3jFGtPPfvb/LVXtqeG
8IYdnGEnL+qt8SXOsotz7OY79vA9L3OevfzA087Nc25SC+Y3WKa+9BCmza/y
VTyPj3ieI2xjP5t5jXW8wkpWqN04l2fjn4hnuOhd9fzIKs6ymF/sf+ZN783h
deZrKv69zR/Gb8HJ+G04Ee8Jx+Kd4v147zga7yrvxu+pTOPheDc4SK8JyXjf
eCvewfgzJguJf58x1Bp/+v8/8BfhQFEY
        "]], Line3DBox[CompressedData["
1:eJwt0jtPk2EAhuFXUUxYNDoyEOJK2B1YtSoUBApqVbRqOSgUEIUCCojQFiwF
TxgSTUgIMeokYIzAQtgZQCd/A7+Bq4nDled+v0PTUCoTqcaeYyGET+ycCOGM
7XZhT1folP6nq3WkNIR+55riM3pb1xaf0Ts6rqN6Up89GUKX85Su0mmd0Rd0
Vuf0Rb2oY96ZdV7VLTqvN3SrLuhdXaZP68/sOy/Z8yRLQjhwbrd/bIf9a9d9
58jxEH7by/a796/Yq6zqWltHlG/O9XbTsw32Go008dW9ZhujhVaWXbtub3CT
OLc4dyqELZ9xW9+hjbvc44d3EvY+D3hIkjXX220HnXTxiMd0s+5+j03Ry7bP
77P9PGGAp2x47pkdZIg0w4wwyk/3n9sXjDHOBC+Z5BVfPDNlp8mQJccMv4q/
kX1NnjkKrLg+bxd4w1veFf/urr+3H1jkI0uUc8nvdvj//+0IrP9Otg==
        "]]}, 
      {GrayLevel[0.2], 
       Line3DBox[{1243, 1440, 1831, 1242, 1439, 1830, 1241, 1438, 1829, 1240, 
        1437, 1828, 1239, 1436, 1827, 1238, 1435, 1826, 1237, 1911, 1725, 
        1236, 1910, 1724, 1825, 1235, 1434, 1824, 1234, 1433, 1823, 1233, 
        1432, 1822, 1232, 1431, 2017, 1667, 1631, 1632, 421, 1604, 374, 442, 
        1177, 311, 375, 366, 1721}], 
       Line3DBox[{1256, 1448, 1840, 1255, 1447, 1839, 1254, 1446, 1838, 1253, 
        1445, 1837, 1252, 1444, 1836, 1251, 1914, 1728, 1250, 1913, 1727, 
        1249, 1912, 1726, 1835, 1248, 1443, 1834, 1247, 1442, 1833, 1246, 
        1441, 1680, 1832, 1809, 1245, 912, 1642, 1633, 1634, 1636, 1989, 1635,
         1556, 1512, 1610, 1523, 1803, 1988, 1609, 1611, 1511, 1640, 1703}], 
       Line3DBox[{1269, 1454, 1847, 1268, 1453, 1846, 1267, 1452, 1845, 1266, 
        1451, 1844, 1265, 1918, 1732, 1264, 1917, 1731, 1263, 1916, 1730, 
        1262, 1915, 1729, 1843, 1261, 1450, 1842, 1260, 1449, 1841, 1259, 
        1637, 1681, 1163, 1682, 1258, 1662, 2015, 1518, 1643, 1517, 1644, 
        1257, 2008, 1516, 1557, 1515, 1582, 1597, 1800, 2004, 1514, 1613, 
        1513, 1719}], 
       Line3DBox[{1282, 1458, 1852, 1281, 1457, 1851, 1280, 1456, 1850, 1279, 
        1924, 1737, 1278, 1923, 1736, 1277, 1922, 1735, 1276, 1921, 1734, 
        1275, 1920, 1733, 1849, 1274, 1455, 1848, 1273, 937, 1272, 1638, 1668,
         2018, 1805, 1669, 1271, 1663, 1794, 1919, 1605, 1527, 1270, 1996, 
        1525, 1558, 1524, 1583, 1599, 1995, 1598, 1687, 1705}], 
       Line3DBox[{1296, 1460, 1855, 1295, 1459, 1854, 1294, 1934, 1745, 1293, 
        1933, 1744, 1292, 1932, 1743, 1291, 1931, 1742, 1290, 1930, 1741, 
        1289, 1929, 1740, 1853, 1288, 951, 1287, 1928, 1739, 1286, 1927, 1738,
         1285, 1796, 1926, 1606, 1528, 1284, 1795, 1925, 1559, 1585, 1584, 
        1283, 2006, 1600, 1601, 1695}], 
       Line3DBox[{1322, 1473, 1867, 1320, 1946, 1754, 1318, 1945, 1753, 1316, 
        1944, 1752, 1314, 1943, 1751, 1312, 1942, 1750, 1310, 1941, 1749, 
        1308, 1940, 967, 1306, 1939, 1748, 1304, 1938, 1747, 1302, 1937, 1746,
         1300, 1798, 1936, 1529, 1299, 1797, 1935, 1560, 1587, 1586, 1297, 
        1699}], Line3DBox[{1336, 1485, 1879, 1335, 1484, 1878, 1334, 1483, 
        1877, 1333, 1482, 1876, 1332, 1481, 1875, 1331, 1480, 1874, 1330, 984,
         1329, 1947, 1756, 1873, 1328, 1479, 1872, 1327, 1478, 1871, 1326, 
        1477, 1870, 1325, 1476, 1869, 1531, 1551, 1475, 2020, 1689, 1694}], 
       Line3DBox[{1349, 1494, 1888, 1348, 1493, 1887, 1347, 1492, 1886, 1346, 
        1491, 1885, 1345, 1490, 1884, 1344, 999, 1343, 1949, 1758, 1342, 1948,
         1757, 1883, 1341, 1489, 1882, 1340, 1488, 1881, 1339, 1487, 1880, 
        1338, 1486, 2001, 1566, 1534, 1553, 1713}], 
       Line3DBox[{1362, 1501, 1896, 1361, 1500, 1895, 1360, 1499, 1894, 1359, 
        1498, 1893, 1358, 1015, 1357, 1952, 1763, 1356, 1951, 1762, 1355, 
        1950, 1761, 1892, 1354, 1497, 1891, 1353, 1496, 1890, 1352, 1495, 
        1889, 1351, 1994, 1760, 1673, 1537, 1712}], 
       Line3DBox[{1376, 1506, 1902, 1375, 1505, 1901, 1374, 1504, 1900, 1373, 
        1031, 1372, 1957, 1768, 1371, 1956, 1767, 1370, 1955, 1766, 1369, 
        1954, 1765, 1899, 1368, 1503, 1898, 1367, 1502, 1897, 1366, 1953, 
        1764, 1365, 2011, 1652, 1674, 1651, 1711}], 
       Line3DBox[{1390, 1509, 1906, 1389, 1508, 1905, 1388, 1046, 1387, 1965, 
        1775, 1386, 1964, 1774, 1385, 1963, 1773, 1384, 1962, 1772, 1383, 
        1961, 1771, 1904, 1382, 1507, 1903, 1381, 1960, 1770, 1380, 1959, 
        1769, 1379, 1710}], 
       Line3DBox[{1404, 1510, 1908, 1403, 1061, 1402, 1975, 1784, 1401, 1974, 
        1783, 1400, 1973, 1782, 1399, 1972, 1781, 1398, 1971, 1780, 1397, 
        1970, 1779, 1907, 1396, 1969, 1778, 1395, 1968, 1777, 1394, 1967, 
        1776, 1393, 1709}], 
       Line3DBox[{1418, 1547, 1095, 1417, 1987, 1793, 1416, 1986, 1792, 1415, 
        1985, 1791, 1414, 1984, 1790, 1413, 1983, 1789, 1412, 1982, 1788, 
        1411, 1981, 1980, 1787, 1410, 1979, 1786, 1409, 1978, 1785, 1408, 
        1977, 1696}], 
       Line3DBox[{1522, 1430, 1521, 1990, 1230, 1429, 1821, 1229, 1428, 1820, 
        1228, 1427, 1819, 1227, 1426, 1818, 1226, 1425, 1817, 1225, 1424, 
        1816, 1224, 1909, 1723, 1815, 1223, 1423, 1814, 1222, 1422, 1813, 
        1221, 1421, 1812, 1220, 1420, 2019, 1679, 1678, 1219, 1419, 2010, 
        1639, 1628, 1629, 883, 1630, 1520, 1581, 1698}], 
       Line3DBox[{1701, 1627, 1562, 2000, 1462, 1549, 1530, 1856, 1463, 1301, 
        1857, 1464, 1303, 1858, 1465, 1305, 1859, 1466, 1307, 1860, 968, 1309,
         1861, 1467, 1311, 1862, 1468, 1313, 1863, 1469, 1315, 1864, 1470, 
        1317, 1865, 1471, 1319, 1866, 1472, 1321, 1868, 1474, 1323}]}, 
      {GrayLevel[0.2], 
       Line3DBox[{669, 1196, 885, 2019, 670, 1159, 898, 2017, 697, 1161, 912, 
        712, 1189, 1078, 2015, 1165, 1167, 1168, 726, 1190, 1919, 1086, 1171, 
        1173, 1174, 740, 1926, 1088, 948, 754, 1936, 1090, 963, 1856, 769, 
        1092, 978, 1869, 784, 1093, 992, 2001, 798, 1094, 1994, 1007, 813, 
        1180, 2011, 1022, 828, 1215}], 
       Line3DBox[{671, 886, 1812, 672, 899, 1822, 698, 1197, 1198, 1832, 1199,
         1200, 1163, 1166, 1164, 1194, 1195, 2018, 1169, 1172, 1170, 741, 
        1927, 949, 755, 1937, 964, 1857, 770, 979, 1870, 785, 993, 1880, 799, 
        1008, 1889, 814, 1953, 1023, 829, 1959, 1037, 843, 1967, 1051, 858, 
        1977, 1066, 1214}], 
       Line3DBox[{673, 887, 1813, 674, 900, 1823, 699, 913, 1833, 713, 925, 
        1841, 727, 937, 742, 1928, 950, 756, 1938, 965, 1858, 771, 980, 1871, 
        786, 994, 1881, 800, 1009, 1890, 815, 1024, 1897, 830, 1960, 1038, 
        844, 1968, 1052, 859, 1978, 1067, 873}], 
       Line3DBox[{675, 888, 1814, 676, 901, 1824, 700, 914, 1834, 714, 926, 
        1842, 728, 938, 1848, 743, 951, 757, 1939, 966, 1859, 772, 981, 1872, 
        787, 995, 1882, 801, 1010, 1891, 816, 1025, 1898, 831, 1039, 1903, 
        845, 1969, 1053, 860, 1979, 1068, 874}], 
       Line3DBox[{677, 889, 1815, 679, 902, 1825, 701, 915, 1835, 715, 927, 
        1843, 729, 939, 1849, 744, 952, 1853, 758, 967, 1860, 773, 982, 1873, 
        788, 996, 1883, 802, 1011, 1892, 817, 1026, 1899, 832, 1040, 1904, 
        846, 1054, 1907, 861, 1980, 1069, 875}], 
       Line3DBox[{681, 891, 1816, 682, 1911, 904, 703, 1913, 917, 717, 1916, 
        929, 731, 1921, 941, 746, 1930, 954, 760, 1941, 969, 1861, 775, 984, 
        790, 1949, 998, 804, 1951, 1013, 819, 1955, 1028, 834, 1962, 1042, 
        848, 1971, 1056, 863, 1982, 1071, 877}], 
       Line3DBox[{683, 892, 1817, 684, 905, 1826, 704, 1914, 918, 718, 1917, 
        930, 732, 1922, 942, 747, 1931, 955, 761, 1942, 970, 1862, 776, 985, 
        1874, 791, 999, 805, 1952, 1014, 820, 1956, 1029, 835, 1963, 1043, 
        849, 1972, 1057, 864, 1983, 1072, 878}], 
       Line3DBox[{685, 893, 1818, 686, 906, 1827, 705, 919, 1836, 719, 1918, 
        931, 733, 1923, 943, 748, 1932, 956, 762, 1943, 971, 1863, 777, 986, 
        1875, 792, 1000, 1884, 806, 1015, 821, 1957, 1030, 836, 1964, 1044, 
        850, 1973, 1058, 865, 1984, 1073, 879}], 
       Line3DBox[{687, 894, 1819, 688, 907, 1828, 706, 920, 1837, 720, 932, 
        1844, 734, 1924, 944, 749, 1933, 957, 763, 1944, 972, 1864, 778, 987, 
        1876, 793, 1001, 1885, 807, 1016, 1893, 822, 1031, 837, 1965, 1045, 
        851, 1974, 1059, 866, 1985, 1074, 880}], 
       Line3DBox[{689, 895, 1820, 690, 908, 1829, 707, 921, 1838, 721, 933, 
        1845, 735, 945, 1850, 750, 1934, 958, 764, 1945, 973, 1865, 779, 988, 
        1877, 794, 1002, 1886, 808, 1017, 1894, 823, 1032, 1900, 838, 1046, 
        852, 1975, 1060, 867, 1986, 1075, 881}], 
       Line3DBox[{691, 896, 1821, 692, 909, 1830, 708, 922, 1839, 722, 934, 
        1846, 736, 946, 1851, 751, 959, 1854, 765, 1946, 974, 1866, 780, 989, 
        1878, 795, 1003, 1887, 809, 1018, 1895, 824, 1033, 1901, 839, 1047, 
        1905, 853, 1061, 868, 1987, 1076, 882}], 
       Line3DBox[{693, 1080, 1990, 1081, 694, 910, 1831, 709, 923, 1840, 723, 
        935, 1847, 737, 947, 1852, 752, 960, 1855, 766, 975, 1867, 1868, 781, 
        990, 1879, 796, 1004, 1888, 810, 1019, 1896, 825, 1034, 1902, 840, 
        1048, 1906, 854, 1062, 1908, 869, 1095, 1096, 1097}], 
       Line3DBox[{876, 1070, 1981, 862, 1055, 1970, 847, 1041, 1961, 833, 
        1027, 1954, 818, 1012, 1950, 803, 997, 1948, 789, 983, 1947, 774, 968,
         1940, 759, 953, 1929, 745, 940, 1920, 730, 928, 1915, 716, 916, 1912,
         702, 903, 1910, 680, 890, 1909, 678}], 
       Line3DBox[{1079, 1187, 1188, 1157, 1158, 883, 667, 1121, 1122, 1082, 
        1113, 1177, 897, 695, 1123, 1155, 1124, 1083, 1988, 1149, 1178, 911, 
        710, 1125, 1139, 1126, 2004, 1084, 1150, 1179, 924, 724, 1140, 1142, 
        1995, 1141, 1098, 1151, 1184, 936, 738, 1143, 2006, 1145, 1144, 1100, 
        1209, 1185, 1217}], 
       Line3DBox[{1193, 1156, 884, 2010, 668, 472, 1160, 421, 696, 473, 1162, 
        1989, 424, 711, 1077, 2008, 1148, 361, 725, 1085, 1996, 1099, 312, 
        739, 1925, 1087, 1101, 313, 753, 1935, 1089, 1103, 962, 2000, 768, 
        1091, 1105, 977, 2020, 783, 336, 1107, 1216}]}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzsvGdQVVu3LSqCEsyIgAEwAYKiiBEBu4IBTCigIAKCgIKKBFEQiYKA5KiA
5Bwl59DJOWfJSTJrKiICgty57+GdW7Xrear2re/U+6reWX8oWo0aa8w2+mi9
97FWW3seaEupr161atUQ7apV1ORfasnfAtyJiKw3/vobD6r/+38CUs0sKqTj
b4l8G9/UyJ4QmBf+a5l8ERCjNTyQNX1URJRd9VjjU5e86d//gY/uoXYzur5b
ZP3NagGOO2/znJb/A39za877Zg2jiGxw+/boftO84hX8YWXkx1+RdCJ3HNTz
pAIN8npWcK8s1TvvX1OJPJXpPSgap5c3voJ/v2T+5dSWBeF7SRIHX3A/y5te
wQ/fV2wy2z4jLEh11iMqUSNvdgU3oeHmjs0khCn0G7PptdXyFlZwZyt9L2b9
MeFf16sitq5TyVtcwenXsZ1kjxkS3mFZeeWLr0Le7//nfe35uZyJPuHSVevs
2zjl/hPfv7dcq+J7p7AtY55U7yuZ/8SD/WMvvD/WJuzJHWYxoX0rb9X/fn2F
Vf+vr69Q0Xq7MEkBcRJYUkOsP4GrSdcR32QCjJu9hu00nOH50CNvqx25uHT+
lcpEBQHr5lcbuvW7glY798/Xorl4gmOaehOJU5/Y/pNPxg7Yl/Ldmp0zsI/L
ltbmMwFJBvPEtyOWMFG0ZcP13SlYY8ARID5MwFqK7PNjecbA1mRxQ84yAZ2O
RdXmUAho03h5/S3HS6jh2LWLSSwGo621HojOEKAcrC1X/lAXyq/+KqgPC0fH
lq/3R38SICsvdX5b8xNgjH1ZLzgZjEEPn7PfWyBAxZi5ns3mIRze/bpqoSwA
q+0LytYsEnDtpFxkiMYD8IunytlT54PeJms6Di4RQHXzjIbDDSXYdU529nzq
e/R0VkicI3GPpLLj2qx34XuF9rnRG+54W6gpyfY3AfP7+KsPD8jAaF9HmaCR
C96WyCuhkPifeG4S/RKd9aMPHT6KhjE7tEDu4aUTn0dGoSMtViRKIQ/dyiJj
nPfFgNDlp+s9swiwUpuSiDDVQ2tpdbtr2cm4Nauzz36EAEuOud6nNzzgw6a1
czL+OXjcQ9CGtoqAo2Vnv8if+wBc1LRDGyZz0FJplkGL3JfCzAi7xg2ekGSW
dlnYMAtty3723m0kQNdwTGPumyvMts0blN9Mx6bvw6EJXQREzT/Mvb3GCTjc
BxJCjqbgll81zB++EHBfMWLvyQVbCPolpUh7LxEPe1+MtJsk4Oz6uSnTEivA
qcy+zuw4XL54wSX/GwHPzkVVcF2zgDUZtif36EXh6Z3+9p4/CDjjx3lQs8cY
NrA9qaeUh6F/nlWc8hwB9/bZBEdxGkLBrFeVUWww+quHCmmQ+zh7J57QAH1o
0uCc3EofiOcUHrj2//ozz/07nNdPMY4iv5EVjb5dOyTlJkj67u+HGKt119xm
W5BNur8vm64GntnF5pXwTsH0+coM5Zgc1Jak+uXQHgYCIOf6o5iAlwJ9r76H
umG0BOM6Vo9YvHVjVq6HfK5qtg9MNw2dITBOjbkmMQOXte9INrUTMDFwsyfo
oQ/czryfzR+TjRzR410Xa0j9cXm/qZnBF3hvPC5zP5yNLu+DS7xrCdhsyjIj
cssHjqYkv6I9moktN489fNtCwOD1Hh8Row9Qs53rhHhEGoaNGbgmdxOwaFFu
xKfjAQ3vA7hnaVPQPuc5H5D70j+1s+eLiytcK7V6HG6XiDc3vnB9N0GA0Y+e
8eBFR7CeZZMbd/yEfG9d+N5+JaAn21bN2/wdlDT7/n5tG42XmC+I3iPPl30b
HqGLeAujCYpmb6gj8LLp261iP//MsxvjqTLzlxO4hi82bO9EKwwyyzTM2baB
0X5zomhbP/ZcOKS4zq0ZSllHyrPXjsFLvNSWXVuPdvXj32hsi+FkOP9hIz0K
bKvl+Mh4KQu7TTIw5Yw/XOX8/oOrgYBe4/vyMtxeeHWuWVNeIBI7veJCXMh1
NnNcfyqyaAt7WZTv6tSm4k0niWN+/QR8rZBZkHT/CJW6s3XvAzNx/Dnrmu4m
AvKN1oUL8geC0uqGynKBLKTVZFTsrScgUdZkyPdQIIT+mFBXYczEM97kczcT
ED0TU13P7Q8Z5ad5O/amo29RUvhoBwHyDOefnGf/CLc0XPMlhlKQsW/rSCX5
vj9Vr/DvHvoAAblcbvR+ScgjVjTBNEqAXHlikmylB7zYJXxkWjcBzQ50i6tO
kefohu7EjxlX4GC0DaQfi0Wlw4/YY779mecr3YeOZx+YwtdU9vLqT5oh/4Hk
Le/YeoiM9n/xVPcLHpu8dt5zuhWE+l5an6keAt+7YltLb3YgJddB3VqjDqhc
e5PqWSbhvdSAFrdMFRYeNmDcRJ8LdF3ftJbWE3AlMVVI9Vg6VhNY7L3gCGPS
P4U0yHizHTJhjLz1Ab0LR99/DY1AMcenB/eS57eZj+a+b4YtjF8ZOq9zIgV1
yk+daSXjUPURT6/oMT8YL+S8HvczHUtZUvfEkueimV81PWM0CHhGS4CYzEB/
cdN7DCTPAj03iiLMg4GoELdcvpiBSctomk7G/+xqnU0yqUEQxKl107kwDSnf
RdxCSP63dezebyQWCJFPy9Y9bU/ByGPpe8P7CMjOLjeN4fIDStzlvu21Sbhq
9ZGld2R+efoj2N0tyxsqzwY8PVWdgA8ZHq8umPgzz/TTW0cTmSi4tE9yT/im
Rqgurn6mYl0OmwsV+fwej2LQmL1R7rU2sFdavvuIpR96nyupt53sx/0zsYUH
6ZtgLkv5jaPIGBgqBbKo8bage3HgyaKbZSDllyYUFzQF9auuiGyzKcXQknrO
dc+SgW77DzsODQJWUw2retokY5drSGXvpesody23gIOMH8Y353UPLbqiur8X
o/3xKAx/JKtQQ8Z/ZQrdyxe3nEDI4PeHUPtk7DN6cZCfzAulMbrOPgsBwPzk
jppucxryMgpx3O0kwMyTU8r6YwiIpR/zFylPx6FXQ63vWsl53Pu+7jIOBauM
kKMfbqVjHR/f63ttBHz76do+0hEC6ZeP3Utdn4b0rsJc98l5In9d2eqkHwza
22saZ5RScKCSIfETyf+C2I1VzzIC4UT30K6btknYEjRItXv4zzz/CTen3+CW
pTWO9zZ/NfsQ1gqecXJOvSxdsEWa59RD/SEUP8jYz1HWDPZli3dpJIdhevrb
80PQheEWEwxBZTWQPiN+wS17Aq4asWu2iTag0r7jxmHe+XDGaFzc2ZYCp2V/
CRyWLcR7VPFtI8Hh0HLvpoRyCJnvrv5esqz4hE/8vy5yG7vg0TJieBepkw6W
pqcDDlqinIeh5vvyGPxEzbPa7TsBhn0eh1gFPKBz5mTyom4yZh9dvpBDPu+t
wUah1ikybk+9a9nEmoarVD0Y1ch8qmRxvyJZIwyMZax5TrSm4YG1Djac5Ll4
2B04PCseDjWnRZIqH6ShVd3lV3/lkaw5aQWb6DBwXYzbYyeUiruFzZU0yXny
yui+XYNQSHh2wLMzJRkjzGZGxfr/Oc/FlrIhWjUTOLz0/rmIYwv0tepEVZ1p
gzmtlprmH8PYxhI0CbotoFrgNJtkNwhb/N8IpZzrx1sKlDvjmxpA692G3b4u
Y7BEWZfHd6UNs01XpW87Vgp6z+v4hsSnoPDDiwL1n1V4nNnJmHsoFbI71ZOk
dxLQQt9CvWY4B/lPj4iPvXSFV3nf+XQqyXhLuWj7hhKGWMNZem3SH91jZStz
yTgvrOR3Ti6/BB7Tz90NYz7h8qNJZwlSJ0312PbEJfqASlVdq3xAMsaplL7Y
SeoP+xLN7kPnQkHAQjHO3CcV1fpvqMiRvBXfSRTguxIBdpE12WpkPNvM8lmv
J+vSwGSvlv7vEdDJcGP3aqtUXFXFWEhN6kzHG4/fCaciwOj4lX6KegquSbau
N+v+5zwPvLydTBRMooScVWjsjWaYvaDjZqvSBE0qpku7ekaRK1VdavXTFqji
8Vi9c2M/CBOMWgyjg/gxKdzUT7kRRrraqbZIjkD58WLJVqpuHL6zPVj6dSV0
v3Tx7cqbAMVVJ+ro1zbhow/WumrrEQwfBzxQvkGBPi9mbZ+9pdjLeHvHUEIk
bFc90jBsRMChJ8q01W9T8e4TtpIMNMT3cl2f2wcIWJKr1TiH3qgi/1t/TWsY
Rq73EJshdZ5/vcS2tb02oOZ856JoagIWjFyYmifz11qSZ6G5QEj0O1nyvD8Z
I5uDh/LIeQIVQ9RL8sOhTvtkR/SZVJS8aZcVRerGN8Ej+9p5o2CLx31Rpnup
uClf88Abkn9jE6ftaBQFst9kRCWSU1D1hG3GUsc/5/lPuEpT3bkpyXF0m4rS
sV5qBrWaLsN7xd0ww/JIuoR1GMONI0NN1jWB6bMNFdGsX+BDYZtE6I5+3Fi2
KNrsXANJWiF8rDTj4JOTyh23vh3PVNYUe90qggSKyYio6BTs+yUgfFGjFul+
PblbbpcMrw6JT/YvUuCVUUw7X1M+yr3Au1/0XWGV7MOIjHSyHmtWz1i1Jw6f
hfNTXo5544CTQdgOUmcYqWlvOraaYZN8Zcr48RisEHEP5SPjf4v/T0r/1Q8Q
+SpX/Gx/IhIcfl49Y2TeZBYaSosOhbZx4kMoawp6+8dVriF1eDb5xk/Bc1HQ
KsH0XK8/Bakd6OuSST7nPXkvENPRIB5MsRpMScF8LZbZos//Op4HHVHHVWMC
c3duDz8s0wwfKngNNtF3gP1y7LGc3hFkHkmXZocmMAmam+tZPQhrDeB3ovog
VlOJ7l32qwPWmT2JwkdHgXqD6tyFvi68cqtShOlOKUib0B+NoJqEhVgbK2Gj
JlQ2t4jd25wJ1OdsT1hJUqDmY+gdmldlWDRhMegfEwKbx86/nHpG5iN3/tq2
2XQM0mx/NWRrgT1+2muzyDh8ddOm5/WpQKzQMZc3nQ3FJnuuJzRknNMfYCre
nGsBGxJQ2MIqHj2uqS1wk/tyeJQzIZUlCIroT1OPlCfh9wvZyndInWnR/kh1
8EQk+OVGHBQ6loLhZuwPLpD68AyK5Sy9YuCOjwBNjHkKXqigvpn7L+SZRymF
7vvZSRS5ZLPZ2LEJzi0/ol/qaAVNWlGrC9fHsHLELyV4dxNUnTKGg9v7Qadc
pEjv/hfklCP8Ep7UQ4iesPf+e8PAw7bQkxrfh7RaJqd9g8pBNl95itpnHA4x
aTAs57fhtm3083q8CAeJwLqjL6bg3b5M00NWtVjkfUo21DkOAlIntqatISBj
/NWo9bEC3P/2o3aPhgm8lt/lbZRKgLNA7o8k/U94lmNZGer88LCd93Yasq93
0Lk5wLBogUoeNq0s52Mw5NR49hYyzqcuhF7cI+oFu2U09jxRT8TxJ44vCscJ
+MTlISa2LRyYvddJ0jxKxj1SDv2VZJxrzUw0hGrFAK/fw5wbPCn4QfyXWsG/
UDf+hBdKR9N/0h3Hy7f6WOmrG+Fr02OxBuwBOc5lrF43gpKHOtAxtR72aVBf
DXIdgrV+W+uKswaQ2edx0bB4JTRz75SM3j4G+7vP20pNdKKDS4ZlXnkBDPew
PKd5PgklnfvDBwYbMU3+c2QRTzJ085yYmjOiQGSnFjtvcymutc93kBR6D5tc
wmWSSD0v41ZvaDqRjiMCITn9Um74dMHV/RuZ7561DM15U/zww6cJ/tRdEVjN
b3yUk+Q5R954dYuzDYS/Wr3RaVUCbqkVrtcmyLqdzZ267VswrHl+5Pw3xyRM
GVFzax4iQNf1oX2/UTTYbD4d35mbjFs19s987Prv57n7hcVR+3sTOFMoFOl+
uxGGt2iMpMZ1QkNLxpE7eqP4oWK3k0hBPZR6r3mk1TsAZ0W+vHnnMIQbV498
q1atAskD1X3cTiMQb6/hunmgF1vrA0t/2xUBZR3PbbabEzDluq/ouGMr8qgH
bPgwnwY+TMXHz9ZNgbNjZ+CFwmq0G9y3SAwEAV9JuOhTHgLY9LYVlU8isvnZ
npV/YophXTaejUjqgMaY7cHaaNxwLTP0OF8I0o26PF5N/Jkfnuv9G3hz/eC7
eXSpXEoi9g2NsE6Sdb7IM9/396ojofPCmjO9EslYmeDykrGX7E+lj29g9kV8
d0jt55aH8fA6V5K5NJEAtcX2QLOFETQwXrKL726H/NH2yc4D/WDmfG2L4XQe
1rvJSwqzxsHDDCW+92kEdBfud7VjmkK2rCne5xXNcETAWfNuST1YPkmyffSs
A/VrOvRtXBrgYGw929eKCeCQGatnc6cg3b29om3K9cBSUzraWV8Ij+VDFQPo
h5DWbN/kiy1tcJyRn4jlGAbRm6G5lb8asc2rY7RHphxu3IvfUz499Y/3vf3+
MuHupyvCVTUbcKYgIU+f8h/3mYtuZ59yTvYhp3qFt2p1C3zcwl5wv2/0j/Mc
+/4mTYLpFNSETF9i+WmB6nyPD8eT8/j+ZqahWn8C5kcD8+5+MEdZq8+M2STu
3vp9pGZrK15ULDL89bEWTr0pC36ybgrUpyYPblWaQMnNzxpUxdugZf/t86cD
2mCL1I8f9Qe/oOf0vRDXLe3w7OtVPe3CIYhpYUpLoaHgiCv3+1DNRsg0LqZZ
Si4H/v1jnJaM40h3I1zcZq4NDhz/YScn3QXzbevTzKYo2MrocJbs7OCgp5TP
qFku/GChOSMrOIo/RM+tO0LdDqLonaPC3v/H5w1/5x3EV9CN7Vn6GWMMjRB3
dpj2Zuc4ZDpfoubEcdSYVjOzZGoD1VOFtokmHX+cZ3uOlFP/vkF0M2W9oLCr
BRr8ny/y3B+BUpnj31quTmJExOrm7ZYtoExZDEBshqtu20zKbw2jvGc/R61U
K4QeS7zKQDf0x/kjDvM82yU+hXlfHHFVSxNc0Gw6uPi2HrROCTKPB4+iq8qQ
622tVthz7jqn1JY/P++f8ONmHZPeN8fxi0+BWvdYC3iZeLKEb+v+x/NQ3u11
Fno3gXN0OqaD21rg1lr+rTo97f/tuvffjVNE7r+w/h0GX5iKd1vOJeGBmT7/
IbJ/tE7gHE+yCAXpzexd0eFJOBuu5BwySNarlVeNtz7/LHwr5rlk1YDUf36O
wFaCjk56k6hl/Ml37lMLvHZ2f5ST3gRC01Tmhw0G0UhgOOr99lZwz1B4/qJn
GChvFvzOx5P6MxqcYXasCQb5zp2dNqj+4zrPqjZYMW0dQTO7Q6xZ19pAZpVB
4oHugT+O99I7/mLb2zE86pmw58zGNuiQOcIoO9/zx/Hrnk3f/cY3gcUftcWS
97TC6QxH5fNvP/9xfFm3546nUpNYN07xriKaYdru3uGLR1v+7fb3Y2eA77ms
KIgSebr/jlUyHtVkNy8j61J31sSBizT9yK43NmOztwWeV0fttpkZBVFhI1p+
9WFssFnf0PGlDcwuyjoLGg9CRbRvsXboGJl/x8PpPrXBZyCavm7rgS0sL4rT
fSfw1VifxrJMK9RrXO65+7Dtz+d91TkH+7ZJfDJwn1Uwphl6+15s+fyq8b+d
h630scH75sdxT2XawzfWLUBZrT7Z2vdn3ft3w42H1rsUfhlEMTorwbvxbVD8
teqbNPMwPNbR2T9VPIxvRH5E7ghug0MiZ1RY9wwCe6uDmrrTGD5dvfX1KnI/
mvi9ZE56/Tn+/93wsppNcYMxiIaFU87y/vEgs+H6Wkmyztku+/TU6ZkR3BB+
QjBvuh0CLs4VL/L0Q+RZHSu7Jx24xns1m9rGRqiIoWp8mjYBk15rTGppRjF7
IIutPqsdXlC8nRm4++HhmefS0jsmUe2Mx7LErVa4oHq4v3+6GeYMdRiDh7+g
JKOoTOvmdjgd7ehyeGnwj+tMyLudGDrWh1e6z2q6d7XAj9jF29Y9o1BoeuDK
lpoxfDTLc665vw1Gxrv2D9/vhmG1bCav2QkMv1izIYC3FeTfVLHcb22BGPpz
/vynpjCBc/hzIVczGMUJ8TX51P+389yi22z+aGkSTyowsQ/yNcM1hsMacsz/
/efx3w33f3bi0hZvV5EDdDtuW5Xk533K/I86k2d+cxbBxAzqz2zOnb6qi6wl
n69NkbhbfNDei7xjqJ/xhrtHth02PlzXfoyrF5QWaM1OVk6h+gnhog6aJmC+
/C1v08Eq2N+09cnG5QkM6mr4UCfZCufSHCRtrFog2EOZ2tiLgvs6bVNUReph
2zUGlr35hZC3Wnnmi84Ufu+w23elpglil0yF4ktr/7j+x8o33vCcpeCGG3ob
Ra0byH08WXe2tfQf86CvIPFQWisCHr8PbTy1PxnFOhLrX5L9tZeKlE7QrQZ0
u3rZbOZtGdyReDYtJUIBKc3txm6WXegUm3MKdzcCA80uR3G+CfDpuvg+VG8A
9Z8+Sf/Y0QLdls+7eQtGYJ5l3QynfzsWXb+x9H5tHRyuPTAtbz5J9gsWJn7c
/diF8Wop3U3g8+m33TD72D9e/wbhLqlmZwpO/uaiPHhZDx6VhzKZOgv/OH4i
cVReQI/AQ15t/oLipUCfRFP8TjABuk33D9wJ7UZ3BdnjWjpNsOPW4emk0PF/
fq9+RvG21KYpPKmz/7l2fzOkW9ax5lbVw/mA4c7LrF/wlvr8exqFdki9Ltno
mz8EeRdKnYmLTWid81L/kmclbLh42O1Y+RRcOjfDvXZ+DHfu6Kfsk2qH5yZ2
Ed5qXTDq2jCxyE3g7vrr3+/GkeMb+jLlMR06BQJD2BQm8R5LcZf5hlYwO6op
tb++CRQfLRV32Y7jpfOh6tZdbZDBTK+THt4BF3x8qKp6BnCTNNgFJrZClFfd
84unR+Do9+BhUb8p9KdZOjDk3ATUH/uerov8c51moWa+y0SGgrvgqVvX3QZQ
tt4ek/yqBD6P3Xm/jW0KHZaang8HNQOlMHjXYFY9mOxNO+S8fxTFAt8+3ni9
Ha49uKcet6cfeG/Q3WYsoeBQLPP+Vb9q4SlzE1Hgkw+iC772t0UpyLL8yKLC
oQG24WuPXI1/Huf/g/9r8XB2p92JV9uFxWqtNzJy/p++ICOjQpWGfgKfN/W8
Zt/VBrpqZ15/FvtzXX2yeEvNm5hJfHkqsGv0QAs4bRbwnPz1z/ORUqDXfcfQ
KVRIpt3YcKgJNjun2LQK1vxxvP2ly2Md4lFAv6CkeuBRMp7sNLTV7CHgw4UN
VQ7M24BqcJ1ior8O7vqWmkUh9Z+5+sip+fODuJwoK5nL1QaKl/n3fykf/uP8
kUMDDddrwyHZeJZNmioZI3bohYiQfZa/dPoYlrlA9V4B17y1eSi35vORu6UE
TNaCX9BnBzi6Wzaz60QuDkdpdcRVEMA+rC+WaoGoUiBaF0oXD8SZi9z2SQSM
FE1xlr15CQ26XyT2sGXg7VGtruedBJzLP9D+RtcPqZ4tUy/VRKAj1xxr/ncC
BDmy5zfF5eFN5tYXNIdjIV6qR94gg4ANX1V1zXxysTORW1w8JRI8/J9VaiMB
HGueTYSb12Dd70p/s51FELyzMYc8n/C5nLNn9Fsb3lufdSKtpw7M3hXd2fF+
En7eGQ3b7pyNGwSqjHUDgyHz0APBr5VkPmU59HJdZhluD/K9Xd+UBbrdxTMH
LxDgXJCYdamxAU9lhrx4JVsKVoWH1s2fpkDZfqWTP/hrkU9M8oyDVAG8SOfu
k6iigMu3ydUTCS3oPOKuMWdXCbw6Yfc+Kk7Bd5c+zVGiE3OpOZO92uvhe7+d
TqPNxL8szjvv5BLOqyhYaaKpEmbeCI8Cb6wvwXJwevxudZy0JV5VvxsMlCSM
sWbwPD5GAJeTxfVfhxAP/dT92toXBzZvLZRnUwiw45pPnJAicN+ZfJr2q+Wg
sGNXlNzL5D9/D2Fb0Qg1XyVav1PfM92LkPlYvCZ3CwENP+LzjWWbUc8wm0rM
vhJC1kb67f84BSOaEmzG21sxgB1Eb1HXQbSpEJcx9RToCXvet3nehXVu2Z8e
rWmCwJs/RGQYJuDAbpVRnsJhrPXg+rzVuB08b0j0PuodAK3N49+Em8eR9oR2
tvTrNugue1r5qerP5/dPuEVw1mzoRgKnd+l5LPdXwW2ODckDCln/djr2r8J/
9ce2sGlPYvWNY/LT7M2wlqnlaozKv9/9wD/FLQs2dBQ3T6J0V3mJx/oWyPbJ
XyO7qxGiPsYPPf4yhay/Dl+p8W+E226Fu/rVKv9l7+sW2Too/toF1r612L58
Og/zbdP8QksIKN42QLfL3AN/s5b77ZmOQy/+3wMyXwkwdDvEz4p1qPlRKN19
ewnwvpM0ueFAAW6uSKcXveV4uvhuaZ1QLkhzGJSd4CMgUnnvDa9NbZjsYPJG
Lbkasmb0t0bPT/5/xnORak5lZgiIJOuGcRrteJ/HuvJ95qTtSxqP9lvAtkEL
bn3dNIwWqXc5SNbneT9Csn6eCMPm7jOc67/7o96pwMzTPwgIzDu75SBVHvIP
GZ54vEDmtx9HWsZyCHjyvGehI6sE7+/mpT5tmQaDhY/WD2gQ8NpQaVtQfR0e
8R2NnuwuBFq23BqLYMo/Xr+ym1xnFc0kMtaz/2zybYZzn3ZRJTD8+V7on+IG
r5gbWsItoMKjJHD0WyoyTT6UtCPz6VFH66mwu+7wZk36ptWheXho9hxDSBEB
yVm6R3DpLWTbs7xZH5qFvySTK9c1EdB/7rzw1oB3mCfTrn3ZPAG96/W1pCgE
GHsVvlhlFYNPrNbtvWXvgsrytWdZyLyp/eriZO/eHPw6NLu0cCkUgu5L1I6U
/fPPv3LPX9hl6ETB2uMMQe806+Gcoqe3OW8RsOcrSFuKUzCi9mXXwMMGKI3+
ceXR3VIw8ZdwzPecQj3v145F+5rgydcLL2lFask6x4LBmHcKdaZzxC7nNIFW
u3NZ6bMGaHIP+fZ9+xSaNZeXhWc0wYmFi99nesl6WS5AsydjEj1NfnrGxzcB
W5Dl+9KTzfBIyK1r37tJNFv8pfVKown0Ks6oe5q1gJ7YnsjrVpMozMFMrSfc
BAMio/26+S2gVXbE2VxpEouaygL0FhtBW9ah5HNGK9T/HuYwuDyJ90WaeeK0
G0FpJnJU6GMb6Gn+iE54RsFDIq4RF3rqgVOLh7fgUzFw+68eij43hd9cbygb
hJD9ciPdMb2Zeih5Orts4DaJiqUyvfcNm0DbPZvuIrRAQ/v6husqkzh6xepb
TlUjzB4ybL/S1ArtR3npAx8Q2O2uscfpZhk03tl1lKovEYQalesFDhPIK3X9
Ve6dSuA6H8nYdTIdTPVieRvXEHjASEDHRrwatjg9Hz8gkg27JBsVeJIo6MRf
JKHsXQddMaU7srwKgIm/uF16sg+Zi98et6tuAWEt0fRTfaMwy8rJpzzeh0eP
XMo53N0CLfuIuKHuUXCwP5TOojSBPrwe8vfF26AmcdaLO6ANxnVlpFJpKGgV
tzYhWLMRbLcL188ml4OzhHrxX5/7CC14htxRqAH7+YRzI2a5oN/3c61i9xQG
uucblTg3gsZjgycu7FXgmbfG3TCQ1NtknRrlnU1gaSJzfiyyBmL23GNZfDqF
csK5zWbkPlZNv6a/uFQHC7co9gfHJpH65K3tzb1NcGSXhovFWCNcMGmrPTxL
Qd/LdWMG89UwfXSbn25uDsQts1hk3KVgqryqXBl/A6hcOkvlblMCdC4e+ub7
Kci77Vnw1ZYGoB5+JMg0XwZXX/V0eMZOoeqQqaXo6iY4dGD9Tk+uGhB0+i7r
cmsKLQPXOLN4NoHyg/4JLud6eA3crjXbppDzYTD9QzJuM3xtDpfPNsBmhT21
1a1TON3rfe5rZCMMpzF7TVyrgsSfeyQifadQUEzS7xxzEySMRN1KmK6Buyxc
ndQpiPbbh9dUfIqHr28obOyJBGTpjaSozoygjGLPl+zpdrgd1DOez9MP0Zvl
dzuT+EmOZw2ZJO4W3LLlLc+fP1eC0Vgm7hzEzAvjcSIYD57s1IxTCQT0jB++
ZyFAQa7v7zxkoxqgRW0u8Pb9MnBR57gcMjiFbTnnYpbI+pDr8V791e2VkPEx
4r0UeX4j7q6JaiPPL9xdOuooVgva5UwvvPimkMKufLIvoQnOC2+YayXPve96
08hVWRTcmW/X8UqqDt4YfDrgKlQApxcD2W/LUrC6y9Ht99EGGPVpPSedWQIK
v6jeWUhQ8PmOLikbpQY4lR8b1qdYCuFClQc+Xaega11A25lbDcBoudZB71Ap
nLWvfupO1rHvDdNMfch1qjxMJYLIOrYxuj6/xZmC5y67flZ4SepSXMMATWch
8N5+eKaVxPfSSbXIk/gcrbfvckchMEg97PurjtXczXumhaxj5/sFJqTJOnaT
7tUnf92rKKXJm5wWLwVNtSJ6W8EE0ATnZ3/hryvTxf7CJ988TLQhcZ4ybtci
bgJpNXGRO7oSPnFlsT7rS4dPy6W3FTZN4Zm1Mqfu9TdDoeheOteqenhT0Ut1
l8QzagsoKiQeuts8LYDEi7N2KSyR8xSeljkuE1cJv8Qy0iQxHR7kp1/8Czdv
fXL3Nok/omIbv0XiaoveZhyaBMq5dx56PFQKTwaF3C4dTYRmWfmdkQ8JvGOQ
qNm8oQw8lNObC54ngm2mWSTNIQJ73s+0sD+vBL8+SvOwTjpU7aaOVf1NQeoX
NilcftWQJpb223c2G3qCPJ7wVpM6L55vrhZdC328irZWivkg4LKg/tOcgowa
dpmT3vXQzEdV3dFeBE4Hr1KOU1OwL8Dw8pRAI8Qahh95o1MBB6sS3Ay5KPhI
/YiffU0DFGfeX2s0WgZOSuet+Eh9xgFTLlaVJphOVVk0CmwB2ZfV3k6iBIZd
TeL4KVxB9lFh6r4HU0GwrEpseAeBD6b8F/2vV8EqOX89Ea5MUFB8eDZxJ4HL
0/d0Rs9Xgd8OSXGJHZnQuqandpTEKw+NdrZBFZzy9HlJx5gJfsuq07E9FEyy
WjBdRZ7DyzQLUzy/88D7JddH/lQKNhRSU/Ga1kGwOZNMs34B8Kl3ixwamMQX
ARcLSkuaIFLfyI7pSBN8nHxtF5c/id/ZlqaMapvAeG/Fcu4EeQ4mBqb8yydR
M2fxZQKJV+45y6Gb2wTOetS1TB8n8WyhJIt+eBP4rHl4tPBLM3zUZt/5yIjk
53md4OekepgyVaSb5yyGRhVRscebKHjj4Z3okc2N8DhXT81orBz45A/XsQxN
4kh+Pk3Z5ybQLGaKy9/YBOuYRRTUSZw5IDMqoLQJzPl4Qqt2N4GnXGZfcN4k
jn2dcBNJbAIJ8YRIeabmf7v6/H/w/8H/B/8f/H/w/8H//4wbTJ50EFkmUOTV
06nmPntgGs79Qn319B/HJ1z4JpxpWoNTEcRcL0sBbPNgMeRopwC83DGic1AD
BtbweTOtzcB3aiI89Z0EvC57VmIYzi1SQHeFSzfiXZ7Cis/ahs0CQ3+5wfPH
O5+EX83Dt/4vj9GUEPDpynLP3pTtIgE3uziMVN/kxa6Mr1k4Y7NmvTPId57d
ZjiWhcjqpBrVQMBI+2NHKuXNIjuMHGV5eIzz6lbGDwtJh9SH24B1/ACb4HAa
zufGx/n2EPDSWvZKcPdaEaXfRd5Oqi/z+lfGj2jrBDT+soD911IOHhBMRoYf
F6idRglIv0zQn5paJbJ2DavgljN6eRMr4+dX/OzKf/Oz77RTj3k8/hr2E5cZ
uLgT8EnRJwVjgoDOFV92w9982Qdzglpets8Iqxhw0Koqa/6n/91o3YbrX5Z0
wf2N9WZzwQjUHju/0+QnASbzby1XTX4VLqaVT0w0U8+bXxlvO0Lbb+KmBcJU
vDvDO0LwmGXDUvk8AY76P+MO104Iv5KhIZxvPsj7tTLeLvvUVSorDRA9KZXM
ShuE7UH2b579IqC+TPyRz6YRYUdn/uvWd+/nLa2Md98wlT1koAZUSZOL7lf9
UKs1fnPAIgFq9/a7lF8YFIakgb3nvsr/p4+efr1e/l5+FTjLuO+nzkVvPFHG
EW68RMBZLUW7/QJ9wkIlP40/n5H9z/E8MVtYaKkUYU7+NW1cpyeO9eT1s/8m
4Nx6zW8fpTuF0XDi1g4mmbzllfFjI1YtEa5yQEfR/yk144Z7R2xl35Pj7cx8
A/22DeGRoyb0lq6tkKfwJhNPDMOXLFuTNoYKNCASd180zAP9PbQ3r3OR8WD3
ur3NJBBfbb1UHGgUhhavL0XbkvtittNSUva+GdRRx948dTgDPX8KMu0l49kk
cSaLW9MTJBPUXxhn5yDP9cmf2pUEEBJKj0uT38PIwL4XvJI5GCapI5ldRUDD
jphbqtEe8MR03yrFrVkot2HzxfQmAvRX/OPzK/7x5hX/+PGOBoczBU5Aq6r7
3d0zBWvOm8g7DBEgcsxkmlHEDr4T/W05m5NQVT7u2Mg4ARWiymEyd63h5XkB
qjLveHw77R41RMbbuieyl3voLOHSqiPbN32Iwed7XgrmfSdA6On8eylBcwi+
S8uVwRiJIcHKZZ9mCdjq51QDCa/h002uglaqMNzhXcwyPkeAdth032CkATi8
UsjbJBeMVZQ5B58FAgzubzKzmhnDMN1L3NcV22DUylZCDbrh9UzlzVOCXbhR
67TdgbkGOOL1PEb58gQ0BCrenYMyPCptSLcrLguE3pnNKV0h4ITS2qAtNAYY
vJ7vuJFAEhrb9g1zThAg/bYYBh66wWb6eoVrOplofXL0B0crAey2rDkHPvrA
+IsTWX4fs7HHQmSTbg0Blis+8UMrPnG3FZ/4V8WQmpe2PpBjpfA5j5znzfwd
iG8mgIn57IcN/F6QFfdbpkwiHTULX/zMIfe3btsRq7UennB9K8eTMupU5Fq6
OWA9QECxHGua9yp3OJm1Y79SRRLOdNhdNyP1wb0oi2He2wW8L/K33khMwIu0
TXnGUwQ8kHRQjO12gAtXE7p9HOJwPLurwuYbAbIGcbVP1ryD3y3Wrv0s0djw
jmVLHhlvMzJPAiLdJ7ExbVe2B0MLnOZwNLwX3QRDPvM3ZwYHcbgmf1riUSto
n10n2fV0GL4VnazfldGK3K3nhcUMq2F4/ZZJp41TIHSL0elmWhIWhX/7qTR8
GdZPKfptI+MkIl769JclR3TatPRwYGMc7rls/nacXE9nt93d9AIH+GL52rxd
PA0X3yxls/SRerjiB69Y8YNPrPjBFaPqfjaUBkBdwwzT291ZKBhIyyNK6vCx
74lrrfkCYTRD8qqpfCa+sOC08yPHG420UT1a8IekGJ8bGV3pOPF4wsu1nTyn
t4eV2EJ8YSQqxzaIOg1bmPmkdUh99r32oc561Bvc6X+aBNCnoKtYWbAwGf+z
Jwm/TLYPoCPBVXCNMQlP9Yu+MBwjYMpK53WCtgdcO8L2WlwgAaNalrfNkPyL
jdkaCHdOYSMpCo8iGsHnZ+ZFduoqmG5WMMpIGMFLL9eczn7RBuvWvtFWpBsA
9tiy6QGBPlQa2DR0rq8RTvIf0+qmjAGn83zXO+5mHNv+WGGEqwx2iK8uSq6f
gi20Q+XJpiX48dQTf23fZEjs39F/9jkBSoO/t2j2JmFXuu6Jd+6iuHdqij6V
XGdW/CNuqy43/LA5b8YiLwp3zpxjAHLfw1f84EN/84PbERdy3Fk/QlPY9wYn
s3Tcpx136F0HAWUqFuVzTEHw2G/rxYj4DFw/Y1ci0kLAG8VmwfjLwSDwyOaL
j1UGinyXMmUl8bn35hbUO4NB8C31pxtW6dhqfP/+KZJ/LoavLdG8QZB1YOty
NUMaJj6ZvTZD6o/+rqbor58CIM2quavvdgqy5X8u4SPjX6WqevhIpi/kZbho
DTgmYd/Nh6cFRwjYyza/f+3+cQzlfxAOU62Q+tZISI3SBa6eWtQGx4bw2ot8
PkVKM2xhz3pYbT4MrJkufEWbulBnP2vB7cVaePxFYupF0gRIzUjpUds2YC6W
EIevFUItfrrAqU0BkRT11FzFInx9juYXzdY4OMgUpC/lQcZzC4PydEQiLjjI
M3g/Nkb9ezyJVycJOLPi+779N993cs72tHI6a8gaxctf45KwTvoZawK5L/Jw
h0Wr9CNkDyyeerU6DaNuPJMPJeOQ05hmQvBcMLBKeLp2PU3H6QrXc49I3kol
DkQ0rguFiZnrHycc0vE9h6/4DKlLnlyDHHEQCrd4gzjK2tJQs7H+6iA5frkp
wVzWIgTmjoUsXg1Kxd2znss5JM+M9vqnNooEw5qvug3796cgF432LrX/wo/s
EFtmGZAzgYwzvG0lOS0gdq1Rv0CpDfZSSl/3zg2j9XJSbEZuC1w6Sev0VXcQ
vJ1oU9r0+3GB46xiDFUjqMhw3bkhNgbDFlrzD8Takbr7YRwslIOfkqPjqulJ
UKdtUV7rUIuuUrq3D1dlQ8j1M6+1+inANphcwLamAM8rdix6VASD2Q/56oRE
Ug9XfN+if/N9j3W0XrvP7IJfxr3CU+SiUGjNRotvJP9idNl71lm8g8aHVTF7
NyXh8fvp8jOkLk2yahaoLvpBEP+Fw6t2pKI8r/Yab1J/aJ0MOq7HhMC1sXPe
hwzS0D1BhEOajH9uyeuzNTlhMMVQKUGJTsOylB3CGiTP+fSMq5T2hEOF76Lt
Emsamkbznf3LPyiwMKq5zyQMvjaJeKczpOLB9VZR9P+FH9lI8qmSV/UkRixR
ZOjvNUPpyV7xKKYm4D0tdf/82jGsEsErvUktIGcgf+ZMTh90fXhgxHdlCKve
Mg6YaTXBls4LYxcLh2G9PkOZsEkPGt5JoHNqrYGUHxoVI7snINY92bBybQt+
vxW9oV23CJItzijYNE9BivvbtR3XKpF+lefXz+nJIHs/Tk32NKnDK75vpb/5
vvedMZTueBqNqhwMV9QHvHBI9EFj5DRZjwWEXDbtscLyb6IJlN5o/KVC/LxM
8n/sfe+3nu8uUDwQ8h5okvBx0fluZ5L/GPmKouDqQLB5v72Y2S8F6ymBd+ZJ
/hUuO7dOq4bBJro1AcIlqUjbsP02J5kfA/QcBT/qR4B6yauha+Op+Mqg9M1V
kmenR7MOil0RsJadXf68ciq6611LevFf+AqbfUOUxUzG8VfLxpws2xbQ+SA9
+zq7CwLNL4q1uw6jduIdwYFNzaD4/fcNlBsCyxSpLam/+9E6nfuouVM9LDkq
ZM7uGYNLwpzdwh87MCmvbOhzUxmE6HyZqzOeBFu+Y2fXbWjEndLJnPV5OeCp
uOGTugkFJlb83T//5u+u+O5SYKSSgUcf3OltuCYOXs36y4Xk+o/MRs0sPA3F
0+zdIyYHgtAioM+vl+Rzel3OEJ+rCh6/a9X0gikO2SUrewpI/l9JQLDO1/cQ
nhpgk36VzFPbpguWyDrBqvTZxNt9IdDAcr97lWoKXvz9lVeE5NlHTufW9XsR
YKB1m6tcNBW/j/XBfpLnkFdEcMvxKGA6ePLxzkup+DKxVj3p/8IPmyGd21gf
OIGVOx8cILKb4beRvJ9KQTsc+BVoyaM8iket2FnyDjSD0b3NSYtsA2Cu76Ti
dncIFwqyK1sdG0C7bGSb4rYR0Cqdkdlf1YuaXGVnXXZWgTedn3c+ZRw4HHuN
TBZaUbYIZJm5C2HhoULIstUU8K/4u5lX/N1GK/5u5grrpxXvCrEvl9Z23RZv
4Jw+k8AZQcBVQzb2R3eTse/Gz2s7eZxQ+Hz0xjgyv8wSN33bmn2wd8LC6mtP
GD4V3rgt9QcBp4OujsXFmUJYRa/ypHE8cjz7cluM1J+u79QRdZv84fIS52lh
sg7qDm6hdRgmoMSwNH1ffRh8viRzafBKCp44kD1WSOp874flWNeXUdCqMaHT
35mCPwUk9n34v/DD3vGZdop5NYnM/TYZKS1NYDiUHzKq1QL02gVnbavGkHVN
rQHDaBMcOX+8+uquPmAafOQZKTWMulc2HX+7qRG4rS002bd+AeYF/ywloQFc
zS53vuxxDfhwiyrnwRicoDm7c21+J2Yyf8Q9AiXAp173nkduEqji/sPfrfU3
f/dJiS5fE+0KfHt87WJhYgTMf5GxiZUm4FFp9xhrbi4ecqwPvbvjMbBpRq42
Kyfgx7Jw1leOWKT9wX6e/Y0fjrWPKQiSfKac1oj65WqDC9XWOwUhGsfjX5jF
k/H/Rvhu9GVFN4h5lPpp95cE9Mrvnmog829i+8hmvt5gyP7Fafh+XzIyraX+
YjJIwL2fbRt8giKBv+6w7qRwCpq6CH5q/7/ww36TfGDiPDqODr/cr01rN4HE
s5IYpZguOGbpFPfp+wgm1DTcrz7eCIIVR88JHByEXzQXC13Fh3Cf0lugHa+F
YUeWhguWI/B53bvAVrY+zNW4trrKvgyMfp7CntUTILDi496z4uPmWfFxC3PN
XDKUrUdDFW+hts8JsLXa8iFjDwWshUuZ3zoV45GFiUBhKQ9w46nopiXrEwEn
6hd12mmoYyd+an2pM15r+ehs3EtArMkJS//XQWjuRXE1Zg5DkU+of4HkM33+
qqFcwxNQfUt76cu2TyjZonWsmqzPk4Iul70T9gOXD3SjVMOJmFWW/duH1JNt
wzI77+aHAw887r9tlozb/Q1O/lW3/1M+/4Rb53oJxZdNIEv0B+ng2UawaUng
ZzH+DAmMx0UGxcdwVu3w5wjWRuisEFuqetgPJ+/8LjLcMIzelhp79hXWwbev
7wqvV3yBjYd/PU4+OIBDXrGeRy9VwN56aqvrbmPAu+LjdlvxcQ+t+Lgn68/9
SFjfjE+aUiy3QioEFqo09lykQFTxql2nfCtxqnE4O3Q6CPI1Lu/tvUzW20pi
4slRiCa4zczquwYO8nMWbiog64TJqa+TqZ/Qk086WpMzEDc8NWM5SPYFJU+6
BJc9HVDD4fCV8efR6BWt7/TXPQxTFtvgEUk3eFjtGnksNAGvCgbJK5Djt5x/
d59+MARG8dT738lJaN62tml08F/H89KD4e48pXG84upqPlPXAJAhtLjRoxeo
hDrU05xGME7cfv2l9fXwhD9CANmGYK0vO2Mr9RDWRCd8/PKyEnIWX4ze3DoK
qSt+7c4Vv/bkil/byEvjhnBhG9Kt1htkp8uEfXdkr990mII+rpfpJvr1+NKQ
KiD0eyT4f/N6bzNAAZ8TLmseVxZjT7r220N3LcBpn/WncTcCaOICtj7+lIbP
DqjH8y6/R8qerWmpZB2VLB5z81thILp576Yy/fUB3xfZKCrME+DX2y3DX2AC
BSbee/LSXNHf37nD6TcBPD2Dd49rI24ru/chtOwTVAtcpWZKJmDowQFPmrMu
cCV997owl1zsfjC6iovUpWxF/1y1w9ZQZyz0wrU0HXsfjyjsInVjek5YY6eC
ETCJ7TIW/hCJ784qXleeJfvuUUsBuZqncDA4L47npD8m3xJgfbBIwLrZKa5d
BQogzn/Rne6tCzLelumYINfjOT8WqLH7ElQU1nsKX3iNvo50GxuWCShfua/L
/tt9nbQ534U0/Wfg/3mDSEhDCNaNueTXkM+7vcw+Nr9XDXjWebVdVvVFJmYn
3ibyfeX0426k8yiAiuN4l2u3O74ZLBbUI9/3UNGmhnWaUiCdOO6YXWeHO2LU
Zq6Q72t6XbUYsi/BOnEPk+N0Fng2IX4ujcRfrVlWC2cVBINdKSIsks9x+xZh
+9G/7glzjhALBgO46mhN2OXoVhiIJ17ucxiBvJh94YxvNYDhTufaIZp0vKWi
dLWMzHfflPfaUbG6Q2P45WtPvubgHtpwlY1kPbnAECcbMu0CZvKtORkCWdij
urari+zf2/J9G25O2MLnmNBLsWmp2K4mPNbz1/fHOpNahzdZAO2xW7qCion4
Q1H0wmdS/5+s3Gt9/9u9lrp967WpcHsIp5+72nw/GUXZobGAzO9J/i7SDaNW
UK27g9YwKR4XjxZUdhIEbPXS+sB6xAzuJ18SVv4UhUbzb9Wfk3n/ScPPvhOU
lxAR1dMnGROK1FsvOR4l+eflo4sFDx34mifALugQiGrvSk5G/CJ14GuhhKbO
IzhNNxMlpeSDlT4hq84tkXGowWvqwaAMc82L6QojHqjlDD8vkftSdLNj6Z7S
GB63vmQrLNYOp/PdlKrse2BB5UcPKuXiwWwZJuWlCJhykFzVkU/mu3jzrvQP
biAs15vXxpmNYdu4xvXqyb6vruvjN3ov+My93arrYw5G5rM2apI8tyWL0BhM
ecLEPhmN9c5ZmP/Qhmm0gQDzP9xfvfXXA+WL3qBRKPmc4UcG7ghICjMk+00P
3qd7nil4ggTn/I8Z+jTM3BrBWk3ml+xORg22F67QVWFgeoI2GatvrjvJSeYL
22dHMyq+2wOXmt/F+8cTUPqgUXAthYyHYLfipxut4YmARUqUQgzmKnPKN3wn
YH/d4qL3MQsgVO0fDcyFo3WNz/KLnwTw25/WQDsjUGY4LPjgVAheaqiW27hA
wICwpFeQ7CTuPFygdrChBbjPezOWHWyG1mtmW0dTPdDPeTOrNRGNJVfLbyyQ
dXLJ8c+1ap8dIUGv4CrDfDqm0Mb17ybr3jM9b3pEHHzg0mgaZVAzG9fXNZ/Z
Xft/fp+w+m/3Uc81Lu0pagmAgFDt8xelsnCmX/yhD8m/3eFe3fNt/sB+NPv6
5h2ZaMH5YUNlMwHnQvM0i8I/wpV4Y3f7mTS86pGxfhUZn4dmvOfPl32AE0IN
q3lepuCe39Pc7qTOy+2Pu7L/qzs4U7Fcc/+WiKqWplZXyb4pTSzyvpyuC6g/
7lrS2xePbEosO8vIuH1TwSdWXmMHFb/uXXBrjkbBpg+fGEjd0NU7NWSDU1h3
Tpv69eom6PQdI+6OV4HpOp86WY5M/PLi94bvll6g/aH3/nZyfw326DmOffuA
91oMz6zaFIl8UQUqqeQ8e5fLqqu/24K8wQFl6Y9kX8ZQWndg4P/8ruDE3+6R
tBY4+CSWfeHKS02V2kMZuGy0oMhC9svKkzdbfI2CwDfH5OyTs5loPHP60yWS
zyYj5VruoCC45yw2G+WWgTOdVzZdbSHA2T5kc7BaICTrhO3Mmk5DkON3qSHr
5ET9tfl2nH7wYi8ta2dvClZ+9vyhSuoDXdXHo2XHvWGhLij3ZlQSil3YYZRO
nndBl/glZQ0ybtdvkxE2SUCVnSwDR8k8e/2UccnZ2AE0au5d6/KxGbanXxFQ
6xyBEarHt2+VteGLk+Gnuh9VwdTFe4Meo5MgaiW5xuJdBRY94uw5qJsJ+yWU
ZcePEnDzYRV/nHgark8MsWOitQZGobE5LbIuulH40v1X+Hv8JM1HPdIagVsO
fsrdSeoJ88p9kdrf7osehIq33PN3BJUw9g29gcnYr3DccS25fu6gmJ4K8QAI
F9oqfIEtHdv2ORz763ei7m5ZzDWZC4acI29WrT2Zga9+BgUEkbxxmm6ff2ga
AusIl9/1Vek4Y7qT3pXcXw3f21u1LYPhR2DLtIppGn7Qctr+lZzHh/rK/YK6
QDA/O7J6S1YKUltdexdLrt/ZdNn+e7wflG+IH1MpIfk8kdxn+l/8TuD21RKr
/J9MYJC2Ae+t3a2QLty4fcOrdlAtPJpypPcLSm1bpoqYaYHA1rhRUf8hEN/0
O57zcS8W7h0O5KVqgCUrTqszjuNgJFFt15XehO82ZrwNri+GRNcc7prfU7Dd
bPzYceMSdEkXLCx/lAgZ9pGTdoZkHz2b4KZAnYwnG0cfNgw+RKlPl2tlxwj4
tHJfpPK3+yIz8cumIhffolOxDRv7yxjcpXaEoZjUn5/V6mFFhBus37jpvaZh
Mr69KkfTQz7vBfOA7rBjQfBKX+lGhhLJ24U68zXk+Q389erZnjehkPEqUvGs
ZDrqPoHXSm0EXBGi+zx9IAxoThyk3zSXhlNmCQUUEnftY3BuvBEKp13FvbXa
U7H+zmuucFJ/Wn1Njo/EBUNDg8/6ZIkUdL5paln0X9TVv+prT+l+mMQNd99S
SWY1w3qVt5ynxprAxPDN7U7hUQymtjFnPtYKbybKlg2T++Gj3rMmYnQAz29+
Fjkz3wjDm9YlbF09CvoKVIdTn3bg7ymngzbzleAwuG9rlPwkjG+YPrikV48j
k30yTKp58IquprAzgQI7fuq8Y+oswFOrjwUYDIcC621HTaooAjpX7ovEVu6L
jFbui/ay1nauY4jAjVLSfMbsfshc65r3gIxzlh1vn2+tVsStCl3m7dNxWP51
ruQH2XdUDjX2dJ33gtjxtihFp2RM3hhUUEDqyXL0mjkalhDw0cj/cO1zKn40
oXP863cay8pUTl9kCwcGqyO/7OzS0Hz/g1KLv37X19UlKyU5HNZby7jvPJiG
zc4tA/s+k3nkLD/74a4wuO8yLNi+OxXhm5CO03/RD+4YHFmzb34Mza7PCWTX
toCU5O/gW4o9EOCUUi5r/gUJ06/7dsw3AZO6q7G46RdI+aCponauDzvshFlq
btYBRwNvnvSzcVjN33fSUqQVZ5vS2Yb/V3tvHs3V//2LRyWNklSUlEhUSBKi
rSIiKalkKCpRCaVJEiFTROaQeQyZ52GbMs9e5nmevRpMRfU73c/5/O667urz
Xe/Pet/1ufeu++9eZ71e5+znPns/9j5778erQtC+rDTJ6DwBGfl8DPuOlqOZ
ScPGrMQkSG+Qvtq8h8ClZL1ofFG9SIl5ucux+ykoevWXMEvLLVwmfNBVl7AT
I8WoYHoZP6wrSB2UORqCqlxWjrQELj1dkK5zfvg5BM5MO1sciMOTelWX1Yl4
cfOtgfb2c35wXUTG3SA3EQ+bjth/J+KOS/fbxlsCoVDjEVvi9igZZXZpHWMj
9MPAzDCrmh8O6em7dJm6k/FyyIlf+wl9NjNv4kTOCLDmaHo6fisZ3ZV993P9
G3WMy37rpRNgDMtoHTLMmRognj9qucW2VjgAT0X5iXyka2Wi2KA8EdfjQt/6
cvRB/Kh5gMhAL7qJtPu/WV8Lnc7betg0h2HdZ4zkqGjD16VqZ0JSS2BV3sFs
be5xcHrjqXLFsQ5nFKZb4v2y4XyFgm7+zUngJetFjGS9yISsFznYhaYWm+bh
nT3iNBeM3OFXdKLvxXgqhEVlZhw/E4dSJj94Q+bdMGBtmn4IEUcui9Asaznu
iLr8m/RCDkSi2/sDQhKEnz+2P1Cx+N0bYO7TSVOWj8d1H6p/MhJ4NTCbgeaA
WhCcs+kS5JtJRNrG2vtFRPyqtekWDdMMh4XKX8yanMm4b7RB+h7hH3YMH0xt
vx4Ja2+4uymeTMY+z0Ezh3+jLrcr9EZ5/oFxLHrEzqbET4GlW6bkP79uhB/C
Dp02vCNowX7z2dn9FDC32vyc+1c3DKiauiXsHECf+oXU5V21IN6utzLozCAs
ALOQw8NuvCI23ZRZVg5iNRWWug6j8Ojkd1cx0yZc++xw9bB1Plxdc7X4uc4E
/CT3Ad4m60XLyHoRfey+macqJfjCjn/kJGsYNNa2FMRco4J+Tfe1dTcycOCx
TWFxvBZG1tjHXSBwVJ4MHb8vQygWVUVUnJkJRNemvM/LCH/CL+HO8XWbBNwW
ubeWXiMG+5WPsFkReG/n1KvPilo+wNcSvpdfJAG72bnV5QhcqnX3mJyqYyh8
qFfnP8uehM1eG9uvEDjWYOmL49KvIqFUd4ukWgOBx4bPhPw7dTmLbw664Xqj
KCKy+U5scT30VJednz3QCfOn1w5lLgziJ/krH0TF6qCH8VuEo2I/ZIpNflPC
XhwcLfwuNVoJ2bEcTzopw1DXo3m5WrIda8IeTqm9+AhaHdVJdkLjwE/Wi7aT
9SJesl600+T6j33u1bj7jERWN28czBt7GzZ9ngQV4ZCrD4rycffeGCPT5NdQ
Piet9yiMCsHHj3KMvUjAO362pkfH3ZFhfc6DD4R+ni8R5/qc4oYrH9zSP7st
AmHHxuojhD037zz48peMI3j0zO5xuRqHdUe2GVwn8Pz3cfWnnJeCILanivXp
pwT8Odt+TqafCudY0zIlfCPgYCyj6RLBJJxfF2g/92/U31adLlVz0x3DvIlN
F3lF6oHVa0xFpaMVhkcOHWG2GMaHRqObDY/XwfJZw3ptw14YC03RDMvpR0t1
Gu6rktUAE4aimzYOQb7skid2at24Mv/xzYWyYtjgRmN6sHUU9pB1IWeyLjRA
1oWMWw1F51/U45qwrgMPopNgRdAZcaYrk+D35i2vUEEJlpz2buN54g8up1aY
ntaiQpz6/SvatzPRif3Xt5PaLzAiba+WJ5EX3J9uPtyaEob+MYxbe2iDcXRz
sZcMYZ+G0Udmlkicx/3DJSa2K2PwlkiVQDUhpx2J3B323gfufEgVDIqNx/X5
5c13CTyzkD104EdgGGxTq7Lov5eIqafKohT+xvrbmjbaG+7c4/i07a1sYEId
MFaIPBX82QSrQg8uzOSMYNbkUpZdjHVQs30Pg2BaN8wfvdjN83AQt70/oqIy
Uw2hqQnjzy4PQGq+pPwD7V7sltDxcn5UCsejD39r0x6BRLJe1ErWiybIetGK
hSHPIPEmLGEbNjNyToOZWcq5GxETUB64ubiTvhrjjWKHpmnDQTWQ5i79UiKf
Osj2JupVPqp5HQqmjdWDHS4N+ywIHBLumc/6SjEBGcK7Lyqr+GKwa8nnTgI/
dzY8kspNccGCbZbfbgz64msVgCtEnp4nJ+CvIe0MU5d5z4TcjcMLquXLNhL2
XNT66ud57y5cvjpwvyFXPZiEP9iRv2MUop66c2maVuNd22mZB1YFQFXd2KQe
OAl3zXcUb+i5IqF00eZuUn9IDt+3f/QL1TBeD1HeuBn23XZ+xD2rhfov+758
J+QXxiuaQ04ow5p99+O3ZjhjwctC98GfVOi6nBLp8qADaVSK22gJex4FxQLW
oVEQ2NXXzRkwhJyfkhSFM5ogSeP5o5QVvWA/tOznfssxbOqTOf71fCM4H1d9
+KSzCSw52CvUp/rx3PjJGot3jbAumXdoTHMAfGyXlxx80opdHDoiNOI1kKXw
jvXQ/BgczpHQ1788jPyN9xs/HmuCo5xCT50O9oDB02s75XN7sI5D53x/dz1w
NjAbyicOQyPFiZ329Sh2sWkEbXZthNq5yFUHo9ugKe9kPGX3AF5IWfalxLcB
FDKvFrrfG4BjozuseGnGkcW0LPOhagPcmV7C53S3EfhMHWRj4obwvHDb0qdb
G+F0p+hT6we9kNV7KS/eaQS7t4H+5c4G0OyuO+sV1wX2Kvn3n3waxbGuJxff
iTbAMvMF1a2SbbDzpM+LFcnBcGCX+1bviASkTDNv3EH4n0m6XUXhYQFA3fDC
y2R5Am7PEt9xgbAHY28l+tsyAXD1pa7wwqd4nKLkPEsi5A2lil8zlSZwsqTn
w6+ieqj+BFVL5GvAasbj57lfA5isccfM93ATzF1+b7KXox8KbcXO3IJJ7I66
w55mWwuVFXf2bE8qAsGWrVSTNSPIBCtMHc41gYGSaVoFZ/cf3zvla10fvZeP
4aMM/tYKzUZYv3W9+Ou5P89xY2kiwzqlcRyd/vT08ZoGaJj66l+46c/zy43T
mjcF+Scw8sKyDs6yejDu+3b0ONT+x/o/L5yLVN1q1oXWOr7861vqYVL+2PI7
K/76/pb/lHxP7+0Lbg9rMWmd1Ok8uSKwFdxVvEFmEpymxhPpTzZjXqI215uE
GpD8lr7hiu44eDgLdlUU9eOU9AYH00dN4MUos2FUaQA0gjcuUQ8fRD9+wXzD
R81Qibwd6jR9cGy4LDLx1ChW8fMlZPs0QSLz0/XslDYQ/fz60rrdY5j7KvOb
lGATXB0x4r8Y/3/+nsP/1fI1bzt5+XJHUfdJy648feJ9ZF1SXMjTCok3meU+
5Yyj1qk2Hu11DeA2UzPFFFwHMuvcvojyTmBlQY6GwDUKJIlt8tKJqYE3tpQE
6blxfEar2qiZRoGg4/OXp71qQYjdUpnt6wQmdESx4tU6wNAJ5sptZcB8Z1pJ
bt8kci3lWaadXQvfEiiBQUHFwJLq7HSXcRJ9efouLqwhrueYNxytLPnLz5Wj
yxE1L9uDKz6xGJoUUKCf68nQgZZhSDB/kz/DMozf4+2ezQk3w2lznvVqIj2g
mzer8BzH8Ihv69bThP+tkg3UsA5vhGz+Nwus9yewFcv64mLqQYG/vHfF8uq/
Tf8S35cNzpYM4PNVn5RUWZuhaeUp31DWfrj/w7z5fLU57Fz/bebcxg+4JC15
hetnKmw4n5dt1OeGLMuyf0kwJmBhVgpXB4F/Jnl8dn3bEI3ce5kg87UPnt35
RCHpExXswscG1117AUapgdxVN9NxxPJtwskmKkwbVn4/ejAR7+9oy18j/BAE
6rp21hL4djnz5lpGxxQUW/jk2nzlDbDfM70z10ngATuBqsJsCjqtlBxoPVsO
3+eqm7c9n4Bv5L4UBnJfSga5L2XNpX/IeRbJD38cMa4Vr8VJzWZO8dCPcOjj
86L4i5NAQ17Pvuj6vK+FU7d06nD+wXrj8IvFcDO01MZsE5GHDmXy0kg3YELo
kQvbsQwKzh431NCfgBJy7wrfor0rtaT8ICl/QMqtffQsXlW3oVpQindufw3M
zles3f16DCrJ6w8sut6/fsvm5a3tSEfd3hx6vxauXmkLnRYcA9abPoevHOhC
45u+I6HadfD1RYzf7Wt/3W8/1l2WePJAD2od2USvZNUAxXScYm65w+BD/1bE
qWQYrbgdQqPPNINYsY/ESYFuKCvjbt7IOI5Ts3WNnTsJnNPVyddyoQFGuuoj
J6bH8FxezGUJLQrsObRnZ5D137fHoGT2rcs5nwkckNAsm79YD4+uLytV1awE
ykjPUindSbSesxGan6qBt+wegVvmC//4O3qG1hG1FuZwZm+cbPPJD+goH1im
Tdg5vxRN9vbh12DGKZ1/PzUbmRuY7nwopsIymyiaO9alqKZbpbLldQ5ovpI+
nMBOhVUP2H5lNzVhMlPh5MbOShA9dmc/Q85f34ORo1t7UaxcRGKJrNW+sBOu
OY7k/gpDcu+EzqK9Ew9J+d1F8msKSlnzz5+C72GB0atP4nAq8fTRNgI/t5F7
G3LJvQ3e5N4G0WP/kCcuktuR+xzOLtrn4E7KxRbJ/67z/U/JYaPeQtn5SXzs
2rLq8pFamJd9HG8/+vF/+f9O3G7bKHVuHJeYNMjscKkDs5ueEsVniXxh6SGJ
juBxzHpxQE44sh50fW9JVSZQwHTi+U3hUxNYbHJ4z3HferD5JL39WV4NrEzf
sK7TiLB/ziBm/vIaaPazc/a5/2f7t1fVvuNk/gpm2nJ6R03SceX7pM2/v0fE
L7WQDzrrBOt1eb8u+KVj56TA7uEGKswaPVGJW2MDp1pXyH4wT8bu4Zhim14q
3HXdH3W33BwuLqRsqHkXj/oJdT8UxqnwXNObfoTbGLgdvZ84DUXjeJk1pZjI
o0tv1jmoqRuB7y3hL2Ft4Wgvf9uUdpYKc5MH/9v3dB+u3YK/v6dvi/b8b9/T
f9gZdKxS1QWVhHDrZU4BmB91KzaGyBMv3bGLf55yHV6dp5qpV/tgUsfK61ML
VPjCvHtD6lZN+PRNuOrxQ08c0B5ybPhBhaC65xMjVqpwVKJ0X3anKxrSC2n/
/v5ue1PR2HT6AvA+s1q7c8AZp1e/Du/+F/yDY3I7Xq1dfRZOTazm27I9Bd1b
bl/W6KGChLBOp/FLF5CPTpQY9s7EU798vXqrqBAi8v7lSKMrSEaYVvxMz0Cr
7MNfY2upEGNrkvnN4w1ESJbR/ppPxXRVr8ncViLftGaKoItzhIcPBJ0LB5Iw
+kLoeHkfFbQk+ZIC4m0hRMqcxvp7PHoKZm3eP0bosyY17I6xFfh8ETNQL/yA
WnWanKVE/LWMOHSkb8EcRu8UXL5+8j0KKDrfG58i4vWXzgfJ8AyetgqVVRmE
YXXAtadUQv/ioXQxs68ewyZWOXOn/cEoHhsdwPadCkZ+DvSTMUYQK9egpXon
ALu2rdgRT+hfOlrWvMzUED7e8am7uM8X9Rly2RoW/qy34lePbXV1E1D0Edfb
a5rXUA7NWItGqZBZxZM5t8cQaePnP1+JTkSoO1ifTOR9jzhEuUcdXWDjMtnl
wzIZuJLlYphGPRW4ndVuaWh7gbZ35F12kUx8slPcRLSaCg8eF7TkHPOC86d2
3YnITEdTIeO3ghQqjDffwG0bPSDQNKPB91wqTt5VZaBvp0KPoQM1UM0VlPzz
o+miktBxYNXOMkLPyYXnp29EOYPJ53cqxluI/DTwYfAd4j5tRNbyrbnvAJXC
LZVWT2Ix+n7MZCqVCu3yHI2t3LZwbLVO+gWpKLSh/dxWSfjDL7ssnXweW4GZ
+iAbn0c4rm2PjOifocKNLosibeUXIKqmzJWpHYIWs4ILBwk7VyT3gjqQe0FX
k3tBd5P735jI/W/3yf1vE7f2Hgr8QeAztzixL9/scYJL20yKOPdcZv4m42ZD
lCl82lKjk4BXn5t/zyDuP+LK3cN1913B00LzkVZ2Gh65c3bDvmYqyO+lOrFW
+8C9eDHddzoZqPzCda80YZ8ehUua+lXeweeAVZQv8ekovtUlAAj9N55iduwZ
8QEzQ33e6fZU5HtVJnqyhQp9N8r8BE6/hVPnAjVd3JPR4prQCaVuKtizft1X
cMkDNpS+nQ04nIi1lAjWyUEqdBR+YtS85wq5+xtdd36JQ0MpDVNHwm9Ur539
bPDRGdyGtXpvpMSgPF/sxGYiLlvUszWElDjA+mzVWL2ZSFxSnB4URthzSLnY
84i+Xqz3v7buRHYDWGQmr3mpPwSROZ2Mvc8oKB/YdjCXoRQ+szEuU4ucAP/8
85pW5vnIzOKd1yIfC4wnmK8886YCnkwaZPoWgYWMkw7bw7xwRv6zXRdxjrXS
8jNf5xUw+daHGUMC9wYs3yb75vdcUkDGgx1d7mDcYK3f65WKLWEnZaCNCiuE
WVvc+f2h3dnofKx6Oh4XLT7V83v+5fvR1j31AZBo8KJdZVk6Jg0vKKsQ9tlg
rH02TT0AisIujTA5p6LA6lOb6Ah9ttXUpC094gfZT7/Gpnomo8brXCPRLipo
dKPjmZ0+sH/4sPcNo0Q8G6zhbzBA+M+jiWxME56wqs9axV05HjvuxHPOEuc+
ENGhw93lBgEqmr8+vf+AqVL87B6E3f5zX+4UuS83jtyXa2VgI5t5chDpDn+m
U+RsAv7wpWdjm/uAKTHiC9xux4TGluW73GrA9u3ajO77Y7BPLTHZc1c10tIP
pVRhLiwNvyp8LG8SDsk9TaLEZ+E3Tfebikl+MDquJRNVQgXV92vOvrUKwojh
woFNbYHIcCRWJXyasIf5or2OLEbwsGApk55iAgr3TSyfJO5/T/7nrZNxb+FM
78Z+ansKBu16+C2aeH832RT4D94NhCNMdAztN9Mw9UIBwyQRp358DtbQLA4C
61P8Ms670/Dbxd6UCULu72fGs0onCK7vOcl2cTAFhdWvSDUTemYamNqpwRNI
3B9jgg1XMvLvNTG8RujZ5tq5rsub/eEHT3abmmAi2tmfauEi9CxpqfZAOMIH
higXLWWPxCPXNYPvesR9YkXU9TieSTyWSb27tbwWXNdbG1t9KP6jP7ybG2Zu
kDiM47f4P/BDE2zrCC4/lNANm7283c4H9+DCUi213SfrwYjXJ8hscBgYSP4+
GZK/z5Hk7zs8RA0K29CIc6m98TVcJTB9pHfjI70JmCB5/YJIXr80ktdPtCB/
YdPqEnTr1LTX4k2G2FtetAHnqCBL8v2pkXx/4iTf3+DTNen6H5Ix4NX7ri+G
RuD3TuqeMRH3D5I8gAokD2AjyQOoG8h2acHAE9P3b6KJ2RSOP29VB1sR5+tD
fvd/sei7P9U6q5Cfwxakz3RRaZoSMOfwC7HDRF6pT/IGapG8gbEkb+CjHwsM
0S/8QHZ7aeAR3RTkFHevHSbswZzkE+xYxCcY4RfLRtEOBqcSppfiLqlYZhSv
IU/koUokz2DQIp7BV+Fxp+PehkC5yI8Xe4//nuvJtHzY9N/5B01J/kEekn9w
OMj/WdSeEHhB4/jVeHMKlnwQeLKe8AM3/sBLaL3FLuZsWxDQWDiLvnqahMU8
+5p/76NLX8RXuJPkK+QIEWI9Q9jno4i33IMxCXhDdr+GA2GH2Yt4DCP/Cx7D
UZMFPZr3g2iz6sHPTZoNMJMxUsYw1Af16i12fN3duPdDnTRNVQ142OXUv2wb
gY3D5wV3OzZi/Iom7neWHyFf603WxMMJYHpNU3GkqAxN3Aa1l7klAccZ05VR
/IT9hLPcvnw4E6cpu6XN79vD9qDQwd4aKmzhTiiwKQtGHf/Y721LAtHVW2uZ
GmEP+fce2x/muwUu9UynqhNiMW95xCog7OFh0XWjn40+cKvv2bjpZCK67OMz
3tJPhfcrdu0D7RCYXO78+FteMh7LSzzVQOjZ1XW+i443HDbfGRw7QOh/kH9w
xW//uXXtxPm09+Fwdfp8wdTTZGyRyupVIvBVm0ltW3hzGNiUzT2qVkxCa1qJ
FT/+xRyQUkfV0fe3hnGZV/fO4/cbANt+sSrH98D18uIlvSf6MPUuXXABYx2U
JOfaPh8cgqO1x3ab+rRhb+folLhhKRSlO8tt4hkHD5bw7yNFtVgfrWBCLc6C
81/vBby2mYTx3ULzcyKFKHn1+MfW5BDQWagwOe9CBbUtw3OCfQkY2HM8Qwdt
8XnSku4NxHsx4GStf5bDFcf5n498Wh2Bp21HDtkQ+jweZM+uLukEYi+SYsYN
4lE04G7iMiKeanGY9UiWBQLzhpCWPOJ5+2c9TgsTdtKdVja1oy8Mdn9TobAa
JGMVc/b7ZYQ+txieMdnaEQG7LKytzmonY+8r66xgQp90av2lP0ciQITO6Py0
fxKGBy9VC2r7s952/Ry21CsbQbGbQtlCextgm/mvTb53uqDoNIes3+kB5Dsj
OFxbUwdsHYKbNL8OwCuYTO7n6sZQfabLhYYVcI5PMV0sYRRqPlZ4evI34uSt
ZPPYkTzoa3GmX/lhAr7dcbxyS6kc13OuSrZrjYOMYokA2gNUSH2stfrttmyk
fGE978f/Aq69jol9U0boc6mWwI2V4UgjoLC07VQAvo/mcXb8nc+25gxmTQAq
hri+NLGLwXW71baoEXmK2dey3dmnfOCJlEno7cAErDJnUFYncCmTf/JFWqNQ
aLcXjNN7mYTGkh8O6HUSuLpzYuqQSCTo59yKZ2BIRvqNUquPE/am2zjU3an9
Hhw6hRbkkpKwR1Ix5Mi/8f360IVvDCe7R9HSUP7c1ygK8F7du6N/tA24bA/X
RNAMYSCreEMVTz2oNefrPNvQDw57KNyi0r0Y797kfM2/Cp538Wr57Rwh8N7g
7HrTVlztNTlL11IIPIWCapsjx2FXZiQHqNbi5sP6Xo8SU4AtpIvWN2oSrKb6
1vHvKUS5bk4e2lu+cOF+fpOnBxUKyrdzfpBKRFMR0fb2S29ww1RooDuhn5aV
t98XCrqhoP+Gt8c3ReDoisfWFwj77CwSNVBhdga/C/WX+mvjkENB6uypCSrI
rXf5eqwnCFQlgqprDRNR82BQcR4RXxrilYqTMiLgeltdiop9Eo6Eh635Rdib
QcPaqnTpKGB4Oh1S7J2E+lsYRPL+jb4Ls7YFweTMMdSLvDoevpoCJfanYo62
NsOepcfZ+/WG8ZjE/a4B4XoYM/3hK3emF/Z+1/FP4u7HUL/hu6Jra4Chfpk4
vfUQ1Bmv4HPw6ESLhBefdA8XA99eNcU08zHYYb3LXWlLA+4a9/4q0JIJu63a
whNoJ0FVyGHDL/YyFFIsjgy8Hg4qNOvHa+WIeHRKdsCuNxN1jda8byrRxrsW
X86JEXnNqoQXAyucQjHq8XFW/fgg5NCYCJAi7LZB/N7D8itaEGU24+s0FoPW
yv2X5wmcfLFY38nhkR9EVr2ciDyRgG8E30iaEucy/eXad5Fb4dBp1pL9fjAR
lRs7H7wj7PbaT1oFQ9soMFylljx8NQmZjtSeYf837PPpZFRny51x3GxkyBlw
uR5WmKWdieBqhJmELSNfvUbw6cHB07pr6+G7zY59dtHdQHncf8q3cgBj1vq9
MTGvgbuRQ+vbxgZALeD+gV2HelAyeNcTRQK3299Mm12QGIXjmWpHOquacbXs
mqqjnLkguiP+nbXIBGTxj9Iv3VeDD56wj1gUEHj+dOCN5oFJMLKMqnjvm4/s
qy1/cu22hval2X5GEVSYcY3NjhaNx3Crow86P3ljlhNjhCeB3zpCgxIjHzjg
4f09zAoi77FI44XDQyK/cGr7nPd+lzscPe3peHJNPF48w12xnvCrXBZj7vqn
Q6HuEs/pjwKJ+GGjeHsj4VfDovfQTwtEgbVqVub9dUn48+uwhOi/8JN/Vf6u
TMxgs/MoNksbKDPk1MGnezKtg1c6wavF6zK32BBabNoyuj2tBpofzickqvcD
t+TX4GczvWj9vCPlsn4ZZI0K2R8YHYaHbHnVUnrtWPO4qUCNNh/eaJ5dk3t2
HFpmDlayqdYjn4f6pvqQRChgXKPIpzMJlftzutJdilFp4AvbPSLPYFqdIu19
jwonl1gt5VBIw/Sy6+f5FpyRjb/4cxfxPh6iClDk7wfg0sQs+Wm/MKw22dX/
u59TW8jp5HJ/K7jkFuz+mjYatyekfjpLyEd8jicYGQRByKnlOwvuJ+DNyO2r
NQmc0xOdXpou9x60v3SHP41NRIantHeGCFzEo5g7K/fFCe60/oxxv5CNsWdk
/FeWEnlW3br6GHEnmIy+EzWsn4mlHC6vOon36MKeI4FfVtsAB+P49R9myWg/
fD3GjvAzn658FGEsN4cD1LI9Bu/i8RVDceMZ4nwTT6157cNtDEmdh62Fh6Kx
6vRXrhIiLuiQcx9R5NxHDTn3MaNfxrlwWRe4fd0cvr8OwEhB/6Tfdaqv+SPx
hinXQaO3v1K22gePq6nq/K5THXJoPROzVRPK+7UCbz30xC2OL51/16m6+BJu
dlqpgvuGjy5Jna4Ycdbh5u86lYfyx/TH0xdAgjk6YtuAM/JZ74r4XaeKUf6k
N8F6DnJiaI/vPuSIbtJ8rjy/CHy1/Mk5EUZJWGt8KdlsPBmVpnbtHCLsU47n
WtzhRFfIZlVq1CzOQuHxR5mviPjIEt28bzbDDT6GST+SbMjEuC9Jc1hJhev1
oXFhAi7wLknfNaY3DTm2aesNEXg4m5zXoCya1wiWGnNxPvcChHc74jH6KHws
oDj4e+443J3/gErBM2CR/+VYti4cj6xfY/VsltCD4lKfFVOPIdw4KC81LhjF
r65MriD0ueZinC7QPIC0R3scWZoDMJwiVfiY0Gcu/3s1rjxDKDwxKPagxxcP
Ml0UiCb0efSV4PdWOwf89k7hgPVALCZO2D2UI+5HMtUMuYzeQL1x0q8k3gzs
k13oHPjd3y4iEaYg8ha4qvMW7Hdl4WFq6sf2cirkkXMTXeTcRCU5N3FozxeT
c+gIX2tObJm2i8MWwYs8yycJvCHwi8tRzA7mbVptfIOjsWDF9uOOhJ14C9St
4VJ9Ca++KVzJyo1A5tOtgd+IOMio1Sf5gsECKmcYUievheKckxWD7RwRTw8I
3j500x2ZDiTFKl5/jy06HlJKxHvxfUwiTkfMAdo8x81EJVOR9d6dG+oEXhUg
5xSEF80pDH7ZdNSBOEdOx8si3UwJ6Np1q+X3d7qkFjN69f43oCmkQDOdFotl
z5RYfvNsZq9b4D+T/BrO7lSzrEyLQmNBf38G4n89vb2YhZo8sbZCg/H8j3DM
SMiPLCbOMfkPff6jr54ksHS8hVXHqh2NYhPQI7BA34aIO/dTT2y8H+IB5jxz
l6td4zByst+ngni/fMn+9hdkf/sysr9dYmsUwxFRP1D/GeQRmZWANV++cBv9
i/52S5LvXpXku3cg+e43kvmyHJkv25L58gyZF0eTeXEymRcrkvnv9UV89+Jk
nquzKM/1IvPTS4vy04d/4LU/+1/w2j9flFdqk/lj1R947V0X5YlNf+hX/yff
ffyiPLFFmLvS6dA4sqj8kNm+uwG+pFNitN0aQKJt9IbgzSF8UUmz+ntSAwy2
Jx659KkXmhMsi2RjelB33PXLhEMtsK+JW+8iMALdDWUzU+NNuOTGyyVFPMUg
c1vTlnbbBLQEfxoUL69AQ8bYtyWKqXAwKkaedTUVlouljmfoHEdlj7vevIof
UDspuSmQwC37eorYc3rewuW5nMn4t4koO/dQVJnw/xN2hzb2TQfD7tnrj4Te
J6OTfK2POvG8zsIKfb/WhsP00KGAAK4UrFZlPPmF0A/fuZ/K1jnhkDXWN9Hu
n4xbo88c6ybi0dMLy26vpQsHF+VWDDZPQvGASumrxHtUwCykKOA3gmu3CKgn
xBH5XVOv067ALuju42O9ntaPr+hMrXIE6uHp9EyJ8J1BeJo2/9LqbidaH+Pb
GmpQAWjUsUdVYgzCi1NX8W6loN4mruRlh/JgaKfth54Nk3C0Tujrw+MWYCk1
FmigEYfevM+Zxwi/EdQp1XxzfQB4MJTnfq1JRL0ruxg0ifdXQZDuVdCOMPgw
NpERrJSMxlsSn7US+GGuN9cyLiECTKp7dt2xScbDH2/W6BLP1elYk7iKJRKC
XTMmjYeSsPP61enf+woMZHnE5YWGsI8jaa74Zz380CpTWRfcBzWRhrzpB3qx
0yv340HeGpDNP3DGeu0IXK6dL0n73IKNQmzaHCuLwPDzxKnUjHFQqnnDr7TS
FZYGrfteZxiPg+NXRRzGqNAY+25LjUwwqG+pvPV9aRKaLRfdt4Wwq22FdXP3
z0ZASX5+7hhtMkaL0yluIu5f5LyU4qgMkQfNLpSKfE1CJdPJ2lji/idb+noY
K/rxEgNlJ/OTWriy+kDNu4RBsLdVCJB424XGWjXnlv4qhVOtHdr968agmFZO
oiDbF/J1Vz7mupCA0raPr2cSfubil5p33wzCoKOftXaWKwm3NkeExhP4dtz+
eOB1vffwULfg/Yb4JPwmBj5HCf3Q8cp6n7ndi9TmB+L6ayuhd2RVsSbnCNQK
P+NvmQkCp/0uGZLLEvFbx/rGDOJcThoWXta8HQlt5uyRtvxJKMHM9u23HbaL
PTJL5gsHx8o+4YJnibg/qXKhsosKn++VFae/nESJoy8HSlhqwFajwvImzUdQ
nm0N287TjZXbeTS7TlIAV3AX/4gbgR0kXzAtyRe8huQL3k7K15HyfaT8Lskj
vJLkET5I8gjrkPLlpFyUlJ8g+YVbFvELi5PyKlKu+F/wDj80n2Q4wd+ORXx+
czLldVCyxOPamd1jsI/sn5zd+4/+yUKyf7LpdNHore9noeSAhadIhwOuebPf
jY/AJwMStxwF5wdwQZr+iLF8M5Gf2+imUvpAwjJJpmTlCMbfUv9aOdcEW7l4
Dic0doHTySZqZNQgzqdm59VrN8FQ+Y26a+f+zDMYPsm9r6e3E6vk2DmWxNfB
/cH8Ckm9UVjiLiP0UakfG+g7RmTXN8KngQcsttsHYY8hhaVtbAhXCFXM3GNu
Ag2uDBr2lh4wIeOLOhlfQsn4ImhJXy+2bQzVvXbZ57c0wEWnFREH1v51fsyC
9D01asFj6BnhrCct0ACsZzYzOSr99f6xk0XGRauZxpE90+QcRxQFPvTFvBpJ
bfzf7jv73yXfeaTyULNaJFw4pD/k5JCIGeNeNL/+RR3PbNE5viXP8U/XB8Zd
8k4JG8OMzwliJxIbIEnn2YxO1Z/7WORvmAjsfTWO39Oadn31p8CF4WNjrHJ/
fd91Yu1c+qqb7ci0b0/xXvM6WM1NHzDJOfY/8YYLk+/1nmCWZfKlQxg081ii
b0kzsOgVpjil9wD1c7WjxaFR9Fp3a9LzRhO80Qh70KDQDvxVB0+vKxvDUEGZ
ooKdjbA+koPyLfvPdvJP/tm7JP9s39/MP8tTkxh/MmwU+zcyyl1Ib4CqfRXP
0hba/rezt//T5TGrc5XqCDwTIUTpDkpoAnb3HWf7FAdg3yJedUGSV/35g6Kg
OLExnH/M3/CtsxGSpFJ+7ApphhGSjzWE5GNVIvlY+0j5e1J+i5RvcPXsWB49
gTbH8t+xs9eD1iXt59S+CujcJ//Q7fE4qoVrDqyXbQDVTMadfKv+790Pz79I
z7yknmXJvtZysq81luxrdYzrDC0VHcer71Z1cS9pBFEtS5UWPwoEkPynvCT/
KT/JfxpCyreT8uWk/K/e5xNtubHN/KV4sTEq/9pUDuivnp9z4qBCZuaWgiSz
dgzOdop5dLcW3IRy6R3lx6BexsntM08vqjyKoxa+oEA+/8LJYKnhv/y/C+p+
xh/HxnDfUCTP+duNQKlnzcioaABHij5f6pp+zA1UzpK83QR5F0XFni8fhLXc
yrzdqhP43GP39hV8FHjnw5/xaOuf+2PZSRy1ksRRLCSO+qv3+f/k/5BHkXFB
l4wLjWRcSLp579NLtxScEv3wfT7aCU7Mu9zaRODhkspRfb30FFQTEfZ+H+4M
kTcsml0IfC4doGpIE9GAmy1/qu6KKIOsK+fevdWYgNxwuo+bNscg0/7p64P8
7mhQbBFMS+SJBaUaM/pDCbgfdzssy7oNt+Q383uOEPjfmL3HX7oI9ddP9W5Z
SAX5qOcn712hQn3ENloVjxoEb6XPDYEfoYVXkkqrPwnBjhKt2oIt2P3ifq5+
Xg1M288I2AiOQzUB0pkM6lEygyWK3rsULuixv5SungAq2W88f+B/7BM+cG1f
qNCSMkzUdCny/5oJCnZX0vl2UeHxcam5FXd1UUqG93JycjJGduT/MOol8lbL
H07z16io/GKF+mW5YsirjBrja47/o56X2XOzHIzKw20y0zSPjsWD9ojHmUI/
KkiSuJ2yCM+fJvuIXpF9RGvJPqL/lJ38Sf6D5PsrJ/n+fjD9g+9vjpRXkXLm
/0t4AP8k30v2d21b1N9leVp51YBmIwrcGOOc8y8Hb86U5Mf7/pyX/VW5IpVC
c/GWCxrX7mY73x2LkdaUX8WTVKBs6Orl3FKBt0OTTCcDEa4027zqmZ2EkoSZ
6AhKHR5NMd3Pk1MEprIHD/Wv+es8d3+SM1tab2mNGEMtOfFv++YoIH1qIoTz
djN8J+2hkrSHlX+zPfBYeh+MmXsFvW22NSNnM9GtZFz3UQ0VIihR1LdpzuCZ
lKui+iQLw98wvmSuoAKT+u7y0aueaJKSJKtPeY8aEYmPfb5Q4QvpH2gWzRHs
JM93DXm+RuT5/l33/ye5mODnLi4i3onOpkduFq0Br/tDWn2XCv54/dRC3rYm
xwlUCaHWrRCth63xUuWvLP7Mn/53ybdefWZk9m4Chc8P8WltrofhBOOfZr2V
/z8vUjXJixRA8iLRfGt9bnN1HAVyP50qHK0D34vJuQ/z/5y/PM+udKVP70ed
x3OW6QTutdZgkoogcO81Y9WsH+cn8dmBIy4d4rVQcP3E/JWeP/d7M5I8a59I
nrUukmftT9eLOtvG//bzrO9yD10i/HzBuMeNvf/Cz6u0fjjEz0JFl1enDT5q
lsN4Nt/Ic9X0v0//GxzGJK0IvdXZK51RqIcQlti1ufENcLD/lMcV73F8yEq7
wyuoHmwMRPbITFD+Jz6pEpJP6vGXGf/45RN4Ov+2vEVpPezibluTqlgHYwvf
+gRPTGCF1iZmlcB62Purs19noOY/5lf/yecVTPJ5FZB8Xn+6XmbIffw3j5vK
0jT23zxuh+9lL9C2/Rkfqp9+K3xC3QhMw4WW2rWF4/vMBdfffezHfhqknbJ8
DZGTCp8b3iWj68IDP0oPFWw3TCrclrWDfZ41IlOOCTiz21qQQuCWxtXrm3/c
eQvJmw4eOjqagUtClnIwEP4nMfvpdu/9nsCqQFdNZ5qGeUkPZc83U+F87pFw
cwU3KGLTypbOTMYla48Y1fyu8weoqK344Q1re67yfwnNQAN1Nesg4nc8Zqf6
ow75wRNOMb3kuAxcejeC9WM1FUYVOJ9KXXgHbp7a/pk70/Gd1f51axuo8Isl
14Ox1hvS1HU6WQZScKaAfq9qOxVUT1jZDvfawtUTrjmbDiXj/Ry5A+J9VOjQ
fNOozO8LXIwB1TI06SjQd/J9MvE7DcdaV+s3BMBJgR8KfmnpOKsmdH5LHRWm
/HLoudYEAp1IolH+xzRcd+5O9Q8KFdRWGKk+WB8Aq4fNdxb8TEHaRsvMhlYq
cNAOafuua8EulopqoTuV8KIxZ+V2y3EImhKviucow3Mftm1lC8mAl/fjWb9x
UeF43lKeMwvuyJat+aadPgJdb+Zu3zhNhZ9Djt8o2+3hRHsl869VSeiTamjG
P0gFpZ7uTraBd3CGJ1Wy90MqrtEITlJvoUL7vfpogwtBcDRmuXlxcBoGvH5/
Oo64T64Wg+e2v4Jg+wuXmBH6NNyc8Gn37kYqxGSf6848GgSO63WUtrmn4JGX
crebiPtvnzUf1WruxhfnJllV7eqA/2dGuInbCDy/tNbFJJaCtQp0V1c9K4JO
W0tt97wJCDfyjMmiKUKGruYlP28nwE56q4ePDYl4pEPPe5PqjGICDxiYbSJx
09Ytr+OmqPB076qsalcnSE5RU7xnm4iWwSqPOYeoMFfZi1ePBMCM0rkVQ1kp
qHNmO5NpG3Eu84b9+xuC4eon29yfkak4CsInc4n7P3NldntGcgjUVMrl4sFU
ZPSa1XVsosLbLk+Djo0hsMrbPfPNl2QUDxNabvkv+hnGkq9fKu3KxgnrIKuL
n93AWnSOqlBEhexJd86Bt8VoMrP+1GPjGFhCucqfpk2FIXj1yOdKKoErdKOK
3hzAT5Kqj8r/RR1PndxLU07upYkk99K8th7npYbWoNq13Q5jXanAtWzYfkne
JJi1uzk8rcvHzQvukVSDd3Ba0vWYdTAVBh+A7ar98djd3jTiZOWCQrIWeYLj
hP2Te1csyb0rz8i9K6qMUylBpQ0Yy/Ut7BlHLpSmWvpx106Avqklh+lUGT5h
qvXyvxED9HbJTcZiVPgw9nDfo5osrGhf182vdQ+G1lH1O8upoL6MTaglOgw1
ZDWyts0EoONLQY5HX4l8wcqj6seHUfwWIXXt3EQ9/Kh9o3Frbwf8JPeTfCX3
k3SR+0lyOI7vqvjRitMNcnYhlALYOHxK1NNjHBpzFXoThmvRpUTsRmRiMnCY
3iyj9Z6E8+2e99fs/IgxTxQ04lV9oLPrUGm4AxUKLSJ0mOOTcJ3OLZN7kc5o
4/KmfWs/FQwNohVXh3oi97KKLVNK4RjNpsuiSLxHkn1sxgNNY8h0o2lrknY9
PLw5HdPW1QwXOPWjfIuHMfiEw+5WxzqoD1hRLv+rBybJvR/25N4PCXLvh2rC
teP6dN1Y5dCm+OVLEbzaVJk3v2UMVOOpp01eN2JxXGjZFoEs4MGiZZuyJ+CK
+gM6a58KrLxg95QyHQGUX0qlpbupQKWsE3f2RWzfpRNl2agAl2trVirkUWHv
rjAjOo/3uJdelePWdAAm9k69uf+JCgOX/SKNbuiju8paw3v3onH84M+fcoT+
WzZ/i+w+PIpa7lWMP17XQaSl7r2n4V2g41Fy91jeIF7uWCI3plIDm8WV30nP
9EMauU+jj9yncYzcp8EV/qui8EQbbn4TUFVPkwc5tVeENgWPQ9XVUocTF+qQ
M2nk+pn+eNC4phhW7joJv/gOe9h++4gjLgKx/C9cwOF436VlL6kg9CDmtPlC
Ml7aapJrTHHDFt7y/BWEn/c1kl/lf8Ab28R/vfkoGoLVFt2y4zOEPHyHgMJa
B1ALXLd12+E4nOJ/FPMbz78h90u0kPsl8sj9EkKL9ktIk/slqJky/htPdePr
Vr7oYqc62LByhekz6ggIuPkk2tiO4OmpidqR743A7bWnV3mhE5YUvL20z7MX
jZpMjdxn6sHO/1xH4ro/138EyDoYHVkH20HWwf50/Z/ksYvmqRXJeeo/Xd9s
WS/HTlONTw+Vvb67JR+42lQOiqb+ffnLuFZgxNX9wagmH/PmsHIw9m1K0tad
+us4/9HG8bEoD3uIyfHT7zmRirs1bsjqEv7wSNSB5WuvWMEkd9297w2JaExr
yD5LxK8P2/e5J+83g+X7HcRFU+JwgTuj9BRx7jyWO0x7zj+BVbQvdwzyReNh
8ZtXDQg71yP7lz4s6l/SmvcqExG9BcYp9OLCdIEYPCig/5sHatuTEpbsldpg
/WSS+vT8OzToCOr1XaCC8PBSde5wLXh17fahCqW3aL/jUp7xDypIe954fqZI
AwyZgurjx9xx6a5fM1t/UiE6P/fppcOX4VN/sM/25a7YCTfTXQn5k3waEfhk
D2ksF5NSnTIwXHv12IZ6In498hYXCXCFXPq9BRvTMnHhgnSaUhUVzvLmZ+2R
c4XIiR9Xhrdl4MotLRLVxPXnhGw36h18A4GrmrwWPIg4fpNOeIGIU7lkn1Lz
oj6l06NOxw43v4DU8Z54//AoLKKz688g9FOQ7KXNa/4cPKRPal/cGYHLc+b1
ooj3q9B1q0wXy1OwPbRRWnp9KH4Uu/1pYI4KjnuyptM1HoHSu7hZ3ZtBCB+/
rPD4ToVy0VCrnQeMYMS433x0UwCqpzSLdBD63EfmjwaL8sfLn5joxVJeAM25
8stvXVJx3snAs4/AXRQqo7C9iDtcuNTgIEGXiZSoglMPCVz3xcl3ff9bL7h0
Z7m8w55MfPp+8t0NAtcVkP1L3Yv6l8Toc6qOPH4N9he9maJb4nC/k8rb8xNU
8Et0eTBnaQ+rZD7tffsxBqOCyx8bfaZCpO+YbQm9DXgKbhcbOf4e7bfZpSUQ
9qysa6p8Y8ESKC4qjnZc4ejjXtV1hMC9GeLT5/Uc/VFtQXdniUkoCiqoXO4n
rqdlWC3EV20E5xRV0k0pSSjF0uybTcQX9jW1lvcuuIPPa4dZj8PpKL/uhdJV
AocIkn1Nhxf1NSlvSmto3+kO4+9qE+vUE3Duzu6zuwn8bJtzZqb7vQvcvu/3
5KxOHGqvfsxWSTyXRHHYCbztDGOy+1NpDsfg59Kdh94Sz8UVd2bntHQAHr9y
sdyJNQRzJR9fsSfiWuVcpFsFvx5QpC91m7El4tQ95q3MxO+nkP1Ojxb1O61W
uae9/5Q3ZKg2S338lID6FtSTTcT7+GQwrMPOzBMY6GTtlDfG420W+eUeY7/x
p9uOHZbv8BDfjl+CX0Kw/Eba3Szif9+RfVAWi/qgGPR9LeQj/MComKJoOZuA
HG847SsHqLBjEc+LLMnz4knyvHwjeV6ukzwvvSTPy6/2f/C8+JM8Lxokz4st
yfMSQvK8bCZ5XgQX8bxUkHwunxbxudwg+VwaF/G5TJN8LiEkn4sayedCT/K5
KCzic9n9Bz6XnD/wuTST/U51i/qdDiziedlH8rycpJgkHykcRvML+408OxtA
+7OQmi5DDyTI3Z2x+NqHLmwmH4SU6sHL4qPYDgKfxLMu+V4c14HTsSn3HGQq
4eUX5s7l18fgptfyIz+lKXjM+Oemopx8cLSOSPu6MAGDCwIvlFlL0WFNIaPX
zQRg4S0OOiNP+EnZ+q2bvJ6gxsqos89uRePQ2Y1RYoSfOc1aNg7XXUH82pHs
9zYJ2B5SybGKsLdASa05uBoI8ZGMFJ7xJBRVfvKhvYvQzzJ512V2ofC0ad33
xPFkLKiYZw4g9EZvacX5UDkcTsSsVWKdTsaAxFJ1aUI/0k+X5xx0DYeKe4IZ
By8lo6TJjgeFxPWHPJ47lK4axI0OLjT0dBQoVmwwZp/oh8rmDWbZZ3rwTu13
tTahGvjo3y2e9H4EbCWir53c24Ln3YrFVuYWgVOlRH1rxzhYqL+OLCmvQa1f
y90rH2XA0omqC1cSJ2Hb0hgWvZh7YMh2+PSUbCx+uRDz8R2Buw7xFH5rCfAG
vZbCnB10ifjkEJOUC/G+zDj9WmY+HQz3zLZ6HatNwvGQo+f8O4m4w7JbIcI0
HAZOcLoefpyMN7j2n39O3H/mqoTtLEMRsNlkfdWls8n4K+ntPgrxvI/cWgWD
CoZw75UC3/ETFLhO/UkR7u0F0w/H63Wf9WFUH49clFQtGOwbTn3TOQTlq3OP
MNd2YMvLPVoXJ0uh2ovm9VbnMSjwK9q6sKUBr1GavXwycwFWdE15jk2AUZUg
m/Hx1+CtFZ3OOxyHhmo6zCKEn8nUrzicQhcILtHWMxKPEtGUdWk6Ev5qy8GR
Ql2vMPB584AnNDUJKXU+99l/x/FQtWpH/UhIFjlQ/XxlMu69cMTh937O1qsb
Ob9eHUABUZldxSO1cGjrUAJl/SC8iXQLE2DowZyTjtWXL1dA1xP1XK6do6Ci
lKxidKEFG9TH3W/GFsArRZ36gLlxOCjmk5Lv+hYu6tqeuzUVjzbKeR9PEHbl
KNkwERYRAnfqfqbfLU9EW1r2ayXE++L1uFCIgzsS4jdT/OjdktBEIWPPGyJu
TnEdXClB24eTnyPGGDdXweCqRkctv2EIpBvM363bgV9vpGtWsxRB68E6B5Ge
MeiLZ+NVTQsEFnHWuE2FCahipLR6FeGv8lqjB2Q3RoBkybHNsz8TcavlyT09
hB5YC544cPh34/v1DMLLl5aAUeatC3djRqHaHx3dJMJgGXI5F11MxPzIifON
xH2WkHsDfBbtDegj5+WfLJqX32ImXLbyhy04ycgng1QCplr0fH9B+KXH5Jz4
xUVz4qyOEhun73lAhoytlEFyKjKZK36tIc4l+4ror74FVwA+cRs7zWTMleJy
qSP8/6k/zE2fH7irzuL8DibKTVeGfU5HY5dZ9ht1VJAr4B3y8veFa7/yxzXM
0nCjo807ASK/PkBpzu8w8AamA8v5xN+k4FnuMxUahH48SdzeSeL2HBK3nyLn
jh8tmjteLQJZn9z9wGd2SZmuXDry7f2ZIUk8F0X2ocoGSgCsNVHnenQ6HXu5
3JuMCLzU9bI9YOFjAIylZWUPnUpD9+1b6wKI+KsoRiOTi/4w6EnHOZeSgten
b277zYcoQuYLAmS+IEnmC/BDN79eogclL1l8fudYD+pVLzl12EfgktTWDLr5
BszltT1rLV8K3V8rnI20JmB72CmpiAMl2EGTzR1mngorbeI2s5yigjk5/2u4
aP53l6/JU3YPT/C9LaCQfiMF404f8rxN+Ac5pZCbHN4B8CZFWv01TxqKJO8/
zkroM9L2UrLuayJu6aUU7NNOwz0SJjxnG6jAZh/rlFIRBDOWW8wZI1JxS9aV
ezeJ65V7g5Ws1gfB4zgen/ZLKbggPvjCj3jethZjGYvLo0jZ3ujsldsIc2rG
u+oV2kF5kmWo6mU/2izovSzgaQCBx4XXU7gH4Tt/l6z9SDtyfz4tqJxXDXRb
JDz26o3BT7OaIdsTdVhnt3vZ110FoFqb/V1QfhL0ZuVQ4m4hjkTQUlI+x4KN
2/KOZmsqOJPzs5GL5mezP0S/tE8wgwA3xnn+b/FY4jv43Y7AFXy/0t5rK3jD
k4FTGoIeyVidedJ6G/G+pFnNZFitCgJGARhrEk5FCb/sDZyEn4zO/fH6Jk8I
UJbV2JubpiJ1zJGXgdDDbSbDVwaOIfDhcIeyfW8K5nrGuroQ8fdHCDowDwfD
1rH16h1ZyejtmKwjSODS8+S8p0jD/zjv+YWcZ1Qm5xlvkvOMOuucXbl2JuP7
7d6b6k4box7r7JV+4j2l0fvHHN9Wco4vnZzj+zFQtmdoGlGa3l3Dk9kJQs8P
J0zlUMH42hLPX24f8GRL/HiDkCfeAbo1UgSeX1i0L9eCrNvsIefaOMm5tm3k
XJv9QxVhuo6P2HTj3UQxTRD0rBBWemJBhaovUhsrV6dhQm7emqW0T9FhyRHv
d4Q9OFE2jcraBuMU2JXa5wThyQfDZvb/Ir/bM1F6V1J6FGkyh7INauqh92Pr
nrCkTvhO1nM+k/WcfrKes5ucF+Mn58U4yXkxze/iTy5srMDcI2EJW3WjgCLO
RL29j/Bv7UNqm+pzcQMHa3esnwXMBKfdcU+jgvgVOrHxjDhk82KwlJr2Qu7Y
fLM141S4SaFOPDdxwXSR67lbQiMwy7p2497pP9+/UPzpKhOeMbz9LKEwSbke
IvdHBsp9bIOH7e2P+M8P4+NmX7NzR+vAVVlwjCW2F0bIOo8FWec5RtZ5TpFz
WxvIuS0Rcm7rrJ90tJpkLR6M3hNW/SUeQuvY9ZoyiXw8Z7qTf+Yjrja8zHdj
lRfsPpFrK2ZFhZHJqxWzd9PwiYSPGTOdPcatMBb+SthzXVqj9FmWEByJ1EzI
XxOCfv3Ho7UJfBXwY8Z2olsYSh5ms9Fej8F3n8ISnn/58/NWW9+AHd1jeOn0
k/VfB+rgDQ1P2Eq2FuiyzW1MNxzBgQOrn5tuqgPBnMIXY/t6oMuyaMb52CC2
Dhxq8WqvBmtxruXBbwYghawLdZF1oRNkXciEnLdqJOetnMh5qyZfCztRCwqm
b442uJeeDPu/xxyoFJiETyNwO/xyOU6JzXXsLg+CA9euNXJLUKH408Dt+au5
GIGlgWxG6khTK8Mbk0WFFS4u53i3xOG0xAL32TP+aPA4U2Ca8A/vO5LP0do5
Yech+rWrHoTh1FIhJy4ibt4NkLgtI0fky6WM78Zt4/DSwJROOoFnFu+pUyDr
KnfZPiVtU2vEI5l6ctt9K8HmWqer+roJEPtD3+9frXv8Sa6yqN6bTNZ7/7kP
sIrsm0oh+6a63ddfizYZwEpm9y1W441Q6mk5fbag/2+7n1ck/yYTyb95kuTf
rK5zj+jkGsXDdz54z6U2ADXuMjulruMv//4/98e2kvtjXcj9sX+6/p97C9+R
ewsL/4u9hdnkfkI6cj/hALmf8E/XjzAcam86YQlzP5fajZRnYAdfqUAQgWdC
G/uFtm4cR8/3qmxPZClQNNUSs2T137fnTYjc1zdK7usTJvf1/el6t0TOxNzh
FxijvuXU58kETDdW3itJ4N5Wsp/h3qJ+BrplVo7PVZ1B0645s509C7flGWaq
V1Jh5byN0NGEcQxh05NqsKfA0j0ZIpvN6uH/A+jsZxI=
     "]], {}},
  Axes->True,
  AxesLabel->{None, None, None},
  AxesOrigin->{Automatic, Automatic, Automatic},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGrids->None,
  FaceGridsStyle->Automatic,
  ImageSize->{389.4219778476976, 237.17783841438165`},
  ImageSizeRaw->Automatic,
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "RotationControl" -> 
    "Globe"},
  PlotRange->{{0, 1}, {0, 1}, {-0.32565106843037034`, 0.06697138429974941}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-0.998626511020538, -3.0168611683585436`, 1.1624516258052395`},
  ViewVertical->{0.10795490213739647`, 0.32613289212543234`, 
   0.9391395400995565}]], "Output",
 CellChangeTimes->{{3.915891607718153*^9, 3.9158916304100847`*^9}},
 CellLabel->"Out[23]=",ExpressionUUID->"1fe886b2-24d2-4ef8-8706-18e920081eae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"srl", " ", "=", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"mu1", "*", 
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"sigma", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"2", "Pi"}], "]"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
               " ", "-", 
              RowBox[{"mu1", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                   RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                 RowBox[{"2", 
                  RowBox[{"OwenT", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
               RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
               "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                   "2"}], " ", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigma"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"mu2", "*", 
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"sigma", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"2", "Pi"}], "]"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
               " ", "-", 
              RowBox[{"mu2", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                   RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                 RowBox[{"2", 
                  RowBox[{"OwenT", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
               RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
               "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                   "2"}], " ", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigma"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{"Evaluate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "*", 
            RowBox[{"1", "/", 
             RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "*", 
            RowBox[{"1", "/", 
             RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
           RowBox[{
            RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
        "srl"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "0", ",", "40"}], "}"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"0.0", ",", "1"}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"sigma", ",", "0", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.90907415467695*^9, 3.9090743002714367`*^9}, {
  3.909074371961789*^9, 3.90907443292245*^9}, {3.9090750755581293`*^9, 
  3.909075114254817*^9}, {3.909075180521305*^9, 3.909075182254713*^9}, {
  3.90907604343714*^9, 3.9090760456488733`*^9}, {3.909076298355321*^9, 
  3.909076320956622*^9}, {3.909081004927211*^9, 3.90908119303507*^9}, {
  3.909081356151176*^9, 3.9090813583006153`*^9}, {3.909353478780287*^9, 
  3.909353490089417*^9}},
 CellLabel->
  "In[381]:=",ExpressionUUID->"64d29de2-d632-453c-9412-f5e77c9dc3ec"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`sigma$$ = 0, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`sigma$$], 0, 1}}, Typeset`size$$ = {
    360., {117., 121.41472488142543`}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = True}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`sigma$$ = 0}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> ($CellContext`srl = 
        NDSolve[{$CellContext`m1[0] == 
           1/Sqrt[2], $CellContext`m2[0] == (-1)/Sqrt[2], 
           ReplaceAll[
           Derivative[1][$CellContext`m1][$CellContext`t] == 
            2 (($CellContext`mu1 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    8)]] + ($CellContext`sigma$$/Sqrt[
                 2 Pi]) (($CellContext`m1[$CellContext`t] \
$CellContext`sigma$$ Sqrt[Pi/8])/Sqrt[
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
                Exp[((-1)/
                   2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                   1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    8)))]) - $CellContext`mu1 \
($CellContext`Phi[($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2) (Sqrt[Pi/8]/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)])] - 2 
               OwenT[($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2) (Sqrt[Pi/8]/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]), 1/Sqrt[
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    4)]]) - ($CellContext`sigma$$/Sqrt[2 Pi]) 
              2 $CellContext`m1[$CellContext`t] $CellContext`sigma$$ (
               Sqrt[Pi/8]/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]) $CellContext`Phi[($CellContext`m1[$CellContext`t] \
$CellContext`mu1 + $CellContext`m2[$CellContext`t] $CellContext`mu2) (
                 Sqrt[Pi/8]/
                 Sqrt[(1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)) (
                   1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/4))])] 
              Exp[((-1)/
                 2) ($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 ((Pi/8)/(
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                   8)))]), {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigma$$}], 
           ReplaceAll[
           Derivative[1][$CellContext`m2][$CellContext`t] == 
            2 (($CellContext`mu2 $CellContext`Phi[(($CellContext`mu1 \
$CellContext`m1[$CellContext`t] + $CellContext`mu2 \
$CellContext`m2[$CellContext`t]) Sqrt[Pi/8])/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    8)]] + ($CellContext`sigma$$/Sqrt[
                 2 Pi]) (($CellContext`m2[$CellContext`t] \
$CellContext`sigma$$ Sqrt[Pi/8])/Sqrt[
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]) 
                Exp[((-1)/
                   2) ((($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 (Pi/8))/(
                   1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    8)))]) - $CellContext`mu2 \
($CellContext`Phi[($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2) (Sqrt[Pi/8]/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)])] - 2 
               OwenT[($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2) (Sqrt[Pi/8]/Sqrt[
                  1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)]), 1/Sqrt[
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                    4)]]) - ($CellContext`sigma$$/Sqrt[2 Pi]) 
              2 $CellContext`m2[$CellContext`t] $CellContext`sigma$$ (
               Sqrt[Pi/8]/Sqrt[
               1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                  8)]) $CellContext`Phi[($CellContext`m1[$CellContext`t] \
$CellContext`mu1 + $CellContext`m2[$CellContext`t] $CellContext`mu2) (
                 Sqrt[Pi/8]/
                 Sqrt[(1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/8)) (
                   1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/4))])] 
              Exp[((-1)/
                 2) ($CellContext`m1[$CellContext`t] $CellContext`mu1 + \
$CellContext`m2[$CellContext`t] $CellContext`mu2)^2 ((Pi/8)/(
                 1 + ($CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2) $CellContext`sigma$$^2 (Pi/
                   8)))]), {$CellContext`mu1 -> 1/Sqrt[2], $CellContext`mu2 -> 
             1/Sqrt[2], $CellContext`sigma$$ -> $CellContext`sigma$$}]}, \
{$CellContext`m1, $CellContext`m2}, {$CellContext`t, 0, 40}]; Plot[
         Evaluate[
          
          ReplaceAll[($CellContext`m1[$CellContext`t] (1/Sqrt[
              2]) + $CellContext`m2[$CellContext`t] (1/Sqrt[2]))/
           Sqrt[$CellContext`m1[$CellContext`t]^2 + \
$CellContext`m2[$CellContext`t]^2], $CellContext`srl]], {$CellContext`t, 0, 
          40}, PlotRange -> {0., 1}]), 
      "Specifications" :> {{$CellContext`sigma$$, 0, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{407., {161.1875, 166.8125}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.909074300720319*^9, 3.9090743747455397`*^9, {3.9090744151378193`*^9, 
   3.909074435545457*^9}, {3.909075078193379*^9, 3.909075117996467*^9}, 
   3.909075183330357*^9, {3.909076046318943*^9, 3.909076056814396*^9}, {
   3.909076301000022*^9, 3.909076333820966*^9}, {3.9090810320426483`*^9, 
   3.909081035052453*^9}, {3.909081072673254*^9, 3.909081084421227*^9}, {
   3.909081114479457*^9, 3.909081195904853*^9}, {3.9090813586493673`*^9, 
   3.909081361738826*^9}, {3.9093534831887503`*^9, 3.9093535030451727`*^9}, 
   3.925251278147324*^9},
 CellLabel->
  "Out[381]=",ExpressionUUID->"71b3e6fc-9cbe-462c-8a34-0eb7ebab11f7"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "ndnum", 
   "\"Encountered non-numerical value for a derivative at \\!\\(\\*RowBox[{\\\
\"t\\\"}]\\) == \\!\\(\\*RowBox[{\\\"0.`\\\"}]\\).\"", 2, 6, 162, 
   33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329089354*^9},
 CellLabel->"",ExpressionUUID->"390cb659-161c-41e4-a9df-8ae7369b443e"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", FractionBox[\\\"1\\\", \
SqrtBox[\\\"2\\\"]]}], \\\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"-\\\", \
FractionBox[\\\"1\\\", SqrtBox[\\\"2\\\"]]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{RowBox[{\\\"Power\\\
\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{RowBox[{\\\"Power\\\
\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"t\\\", \\\",\\\", \\\"0\\\", \
\\\",\\\", \\\"40\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \\\"}\\\"}]\\) is \
neither a list of replacement rules nor a valid dispatch table, and so cannot \
be used for replacing.\"", 2, 6, 163, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329147084*^9},
 CellLabel->"",ExpressionUUID->"b695c284-eb85-42a8-8513-dacdf709c938"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.0008171428571428572`\\\"}]\\) cannot be used as \
a variable.\"", 2, 6, 164, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.9253143292044992`*^9},
 CellLabel->"",ExpressionUUID->"14acf31c-62e1-4281-af0a-0a067d7b4f92"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", FractionBox[\\\"1\\\", \
SqrtBox[\\\"2\\\"]]}], \\\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"-\\\", \
FractionBox[\\\"1\\\", SqrtBox[\\\"2\\\"]]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.0008171428571428572`\\\", \\\
\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{RowBox[{\\\"Power\\\
\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.0008171428571428572`\\\", \\\
\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{RowBox[{\\\"Power\\\
\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0.0008171428571428572`\\\", \\\",\\\
\", \\\"0\\\", \\\",\\\", \\\"40\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \
\\\"}\\\"}]\\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"", 2, 6, 165, 
   33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329228507*^9},
 CellLabel->"",ExpressionUUID->"d0a08707-0f7e-4013-9eaf-bb81d4eb527a"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.0008171428571428572`\\\"}]\\) cannot be used as \
a variable.\"", 2, 6, 166, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329233479*^9},
 CellLabel->"",ExpressionUUID->"c2477990-77a0-4faf-af86-b88c9bf7aca2"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0.`\\\", \\\"]\\\"}], \\\"\[Equal]\\\", \\\"0.7071067811865475`\\\"}], \\\
\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \\\"0.`\\\", \\\"]\\\"}], \
\\\"\[Equal]\\\", RowBox[{\\\"-\\\", \\\"0.7071067811865475`\\\"}]}], \\\",\\\
\", RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.0008171428571428572`\\\", \\\
\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"2.`\\\", \\\" \\\", \
RowBox[{\\\"(\\\", RowBox[{RowBox[{\\\"0.7071067811865475`\\\", \\\" \\\", \
RowBox[{\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{\\\"0.7071067811865475`\\\", \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.0008171428571428572`\\\", \\\
\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"2.`\\\", \\\" \\\", \
RowBox[{\\\"(\\\", RowBox[{RowBox[{\\\"0.7071067811865475`\\\", \\\" \\\", \
RowBox[{\\\"Phi\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{\\\"0.7071067811865475`\\\", \\\" \\\", RowBox[{\\\"Plus\\\", \\\"[\\\
\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \
\\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \\\",\\\", \
RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0.0008171428571428572`\\\", \\\",\\\
\", \\\"0.`\\\", \\\",\\\", \\\"40.`\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \\\"}\
\\\"}]\\) is neither a list of replacement rules nor a valid dispatch table, \
and so cannot be used for replacing.\"", 2, 6, 167, 33972518729475469538, 
   "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329237111*^9},
 CellLabel->"",ExpressionUUID->"e9bc7073-e30b-4d6b-96e3-dc93ab6ff3fa"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"ReplaceAll\\\", \
\\\"::\\\", \\\"reps\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"", 2, 6, 168, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329242353*^9},
 CellLabel->"",ExpressionUUID->"13606502-bce4-4814-ab5d-04734f19a583"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.8171436734693878`\\\"}]\\) cannot be used as a \
variable.\"", 2, 6, 169, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329246065*^9},
 CellLabel->"",ExpressionUUID->"06a0f183-a99d-4420-b740-719713ca5b00"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NDSolve\\\", \
\\\"::\\\", \\\"dsvar\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 6, 170, 33972518729475469538, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.925314329249687*^9},
 CellLabel->"",ExpressionUUID->"ec7fb7d0-edc1-422d-90b3-5eb6ade45349"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
       RowBox[{
        RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}], "/.", "srl"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.909074317129642*^9, 3.909074328331188*^9}, {
   3.9090743600582323`*^9, 3.909074365463604*^9}, 3.909074897589901*^9},
 CellLabel->
  "In[368]:=",ExpressionUUID->"6c5f920e-bd4b-49e9-b1bb-3f828ea36327"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwdy3k81AkfB3CMnGOm4elQYYgmZyiF8P3yS8ckUomVLmFYR0uNJG0lkV1F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       "]]},
     Annotation[#, "Charting`Private`Tag$2458821#1"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0.9999999999999999},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 40}, {0.9999999999999999, 3.921117621689702}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.909074322545603*^9, {3.909074365817895*^9, 3.909074376846013*^9}, 
   3.9090748980710077`*^9, 3.909074949050701*^9, 3.90907505437539*^9, 
   3.9090760489489937`*^9, 3.909076269574214*^9, {3.909076313105508*^9, 
   3.909076340774844*^9}, 3.909081043375247*^9, {3.9090811514926558`*^9, 
   3.909081202466707*^9}},
 CellLabel->
  "Out[368]=",ExpressionUUID->"c602745a-0803-4c9e-8c6d-da015890aed8"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"outrl", " ", "=", " ", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"t0", ",", " ", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], "*", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "*", 
                RowBox[{"1", "/", 
                 RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
            "srl"}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.1"}], "}"}]}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.90935235039353*^9, 3.9093523769861107`*^9}, {
   3.9093524138455772`*^9, 3.909352461214772*^9}, {3.909352541095726*^9, 
   3.909352561098724*^9}, 3.909352622773678*^9},
 CellLabel->
  "In[382]:=",ExpressionUUID->"b899abae-237f-488c-aec5-49574481b316"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"outrl", "[", 
  RowBox[{"[", 
   RowBox[{"All", ",", "2"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.909352565397786*^9, 3.909352571749555*^9}, {
  3.9093526328185472`*^9, 3.909352632947235*^9}},
 CellLabel->
  "In[383]:=",ExpressionUUID->"cadac2df-1515-4779-b04c-054e177416f2"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.04992719003844208`", ",", "0.09942172261584627`", ",", 
   "0.14806949153672105`", ",", "0.19549189180233276`", ",", 
   "0.24135930842087974`", ",", "0.2854001428189083`", ",", 
   "0.3274053349927645`", ",", "0.36722851697334014`", ",", 
   "0.4047824022430835`", ",", "0.4400326666556871`", ",", 
   "0.472990197634435`", ",", "0.5037026571130715`", ",", 
   "0.5322461647664084`", ",", "0.5587175398583428`", ",", 
   "0.5832275222957378`", ",", "0.6058950639016164`", ",", 
   "0.6268427182384405`", ",", "0.6461930442079988`", ",", 
   "0.6640660149530632`", ",", "0.6805769881953994`", ",", 
   "0.6958354910794778`", ",", "0.7099445371195291`", ",", 
   "0.7230000913663356`", ",", "0.7350910639580563`", ",", 
   "0.7462994107645253`", ",", "0.7567003122923935`", ",", 
   "0.7663625822893011`", ",", "0.7753490279193354`", ",", 
   "0.7837168464015999`", ",", "0.7915181326562787`", ",", 
   "0.7988001750752085`", ",", "0.8056060011662614`", ",", 
   "0.8119746444987054`", ",", "0.8179415937396635`", ",", 
   "0.8235390645817936`", ",", "0.8287963479294769`", ",", 
   "0.8337400675389322`", ",", "0.8383944471800955`", ",", 
   "0.8427815404517041`", ",", "0.8469214386304718`", ",", 
   "0.8508324649520964`", ",", "0.8545313415334725`", ",", 
   "0.8580333466334232`", ",", "0.8613524552410298`", ",", 
   "0.8645014414434208`", ",", "0.8674920358395859`", ",", 
   "0.8703349972619414`", ",", "0.8730401762384841`", ",", 
   "0.8756166538418559`", ",", "0.8780727940190034`", ",", 
   "0.8804162683589927`", ",", "0.8826541727087411`", ",", 
   "0.8847930708566805`", ",", "0.886838995734402`", ",", 
   "0.8887975436064874`", ",", "0.890673913433138`", ",", 
   "0.8924728949591033`", ",", "0.8941989414909373`", ",", 
   "0.8958562076065534`", ",", "0.8974485317740267`", ",", 
   "0.8989794887406266`", ",", "0.9004524266446864`", ",", 
   "0.9018704492332578`", ",", "0.9032364502025028`", ",", 
   "0.9045531495287154`", ",", "0.905823078195235`", ",", 
   "0.9070485975849177`", ",", "0.9082319347716434`", ",", 
   "0.9093751721184159`", ",", "0.9104802476828683`", ",", 
   "0.9115489930591129`", ",", "0.912583139964688`", ",", 
   "0.9135843005837249`", ",", "0.9145539872485469`", ",", 
   "0.9154936356976084`", ",", "0.9164046046479334`", ",", 
   "0.9172881590108819`", ",", "0.9181454944051465`", ",", 
   "0.9189777495985975`", ",", "0.9197860011696738`", ",", 
   "0.920571254116467`", ",", "0.9213344644699777`", ",", 
   "0.9220765451393425`", ",", "0.9227983570639211`", ",", 
   "0.9235007083342491`", ",", "0.9241843713474281`", ",", 
   "0.924850084869239`", ",", "0.9254985437875048`", ",", 
   "0.9261304049735314`", ",", "0.9267462984596148`", ",", 
   "0.9273468270236517`", ",", "0.9279325568342106`", ",", 
   "0.9285040270878488`", ",", "0.929061756262291`", ",", 
   "0.9296062396787094`", ",", "0.9301379431282262`", ",", 
   "0.9306573130763803`", ",", "0.9311647799178728`", ",", 
   "0.931660757047909`", ",", "0.9321456291004651`", ",", 
   "0.9326197642787741`", ",", "0.933083518053662`", ",", 
   "0.9335372337383684`", ",", "0.9339812430334562`", ",", 
   "0.9344158638130179`", ",", "0.934841391339835`", ",", 
   "0.9352581081313884`", ",", "0.9356662876405026`", ",", 
   "0.9360661946320749`", ",", "0.9364580855476189`", ",", 
   "0.9368422084218316`", ",", "0.9372187963256655`", ",", 
   "0.9375880694129161`", ",", "0.937950241113724`", ",", 
   "0.938305518537907`", ",", "0.9386541027239548`", ",", 
   "0.9389961888697034`", ",", "0.9393319636254677`", ",", 
   "0.939661601552255`", ",", "0.9399852714362522`", ",", 
   "0.9403031373902473`", ",", "0.9406153590269603`", ",", 
   "0.9409220916249433`", ",", "0.9412234855983387`", ",", 
   "0.9415196820759384`", ",", "0.9418108161484718`", ",", 
   "0.9420970193960486`", ",", "0.9423784200140841`", ",", 
   "0.9426551429311146`", ",", "0.9429273098561947`", ",", 
   "0.9431950366982524`", ",", "0.9434584329796675`", ",", 
   "0.9437176053366173`", ",", "0.9439726578250426`", ",", 
   "0.9442236920056482`", ",", "0.9444708070256611`", ",", 
   "0.9447140988044455`", ",", "0.9449536575116325`", ",", 
   "0.9451895704227279`", ",", "0.9454219228225207`", ",", 
   "0.9456507980665755`", ",", "0.9458762776412067`", ",", 
   "0.9460984410610617`", ",", "0.9463173637682014`", ",", 
   "0.9465331178763934`", ",", "0.946745773911403`", ",", 
   "0.9469554008905323`", ",", "0.9471620663672021`", ",", 
   "0.9473658364787421`", ",", "0.9475667754062788`", ",", 
   "0.9477649434137223`", ",", "0.9479603989338546`", ",", 
   "0.9481531992157207`", ",", "0.9483434003578781`", ",", 
   "0.9485310573405652`", ",", "0.9487162240568245`", ",", 
   "0.948898953329608`", ",", "0.9490792957563947`", ",", 
   "0.9492572990216198`", ",", "0.9494330097480532`", ",", 
   "0.949606473676282`", ",", "0.9497777356880392`", ",", 
   "0.9499468398288212`", ",", "0.9501138293298109`", ",", 
   "0.9502787466116518`", ",", "0.9504416322934058`", ",", 
   "0.9506025248060577`", ",", "0.9507614617987081`", ",", 
   "0.9509184802529254`", ",", "0.9510736164994124`", ",", 
   "0.9512269062341946`", ",", "0.9513783845343381`", ",", 
   "0.9515280858514509`", ",", "0.9516760431591379`", ",", 
   "0.9518222877746323`", ",", "0.9519668504309777`", ",", 
   "0.95210976134911`", ",", "0.952251050249962`", ",", "0.95239074636624`", 
   ",", "0.9525288784538708`", ",", "0.9526654747776074`", ",", 
   "0.9528005623790842`", ",", "0.9529341670375339`", ",", 
   "0.9530663140889486`", ",", "0.9531970284714788`", ",", 
   "0.9533263347343574`", ",", "0.9534542570465897`", ",", 
   "0.953580819205422`", ",", "0.9537060446156299`", ",", 
   "0.9538299556605184`", ",", "0.9539525737561834`", ",", 
   "0.9540739199778807`", ",", "0.9541940150882219`", ",", 
   "0.9543128795438431`", ",", "0.9544305335019093`", ",", 
   "0.954546996826457`", ",", "0.9546622890626456`", ",", 
   "0.9547764288965827`", ",", "0.9548894342697518`", ",", 
   "0.9550013228580037`", ",", "0.9551121120888918`", ",", 
   "0.9552218191467217`", ",", "0.9553304609774761`", ",", 
   "0.9554380542936294`", ",", "0.9555446155443412`", ",", 
   "0.9556501604521205`", ",", "0.9557547041639188`", ",", 
   "0.9558582616170209`", ",", "0.9559608475495939`", ",", 
   "0.956062476504552`", ",", "0.9561631628333344`", ",", 
   "0.9562629206995968`", ",", "0.9563617641081923`", ",", 
   "0.9564597065988821`", ",", "0.9565567609587846`", ",", 
   "0.9566529397747038`", ",", "0.9567482554739445`", ",", 
   "0.9568427203272636`", ",", "0.956936346451756`", ",", 
   "0.9570291458136809`", ",", "0.9571211302312271`", ",", 
   "0.9572123113772179`", ",", "0.9573027007817587`", ",", 
   "0.957392309755062`", ",", "0.957481148930018`", ",", 
   "0.9575692286204728`", ",", "0.9576565590196419`", ",", 
   "0.9577431501998477`", ",", "0.9578290121146285`", ",", 
   "0.9579141546008055`", ",", "0.957998587380507`", ",", 
   "0.9580823200631547`", ",", "0.9581653621474041`", ",", 
   "0.9582477230230527`", ",", "0.958329411881153`", ",", 
   "0.9584104373689564`", ",", "0.9584908079256985`", ",", 
   "0.9585705318971673`", ",", "0.9586496175362134`", ",", 
   "0.9587280730042828`", ",", "0.9588059063729227`", ",", 
   "0.958883125625256`", ",", "0.9589597386574301`", ",", 
   "0.9590357532800352`", ",", "0.9591111772194987`", ",", 
   "0.9591860180172992`", ",", "0.9592602827847064`", ",", 
   "0.9593339784962296`", ",", "0.9594071120530165`", ",", 
   "0.9594796902838474`", ",", "0.9595517199462664`", ",", 
   "0.9596232077276966`", ",", "0.959694160246528`", ",", 
   "0.9597645840531921`", ",", "0.9598344856312145`", ",", 
   "0.9599038713981838`", ",", "0.9599727475962054`", ",", 
   "0.9600411201340348`", ",", "0.9601089948278352`", ",", 
   "0.9601763774358938`", ",", "0.9602432736594844`", ",", 
   "0.960309689143716`", ",", "0.9603756294783663`", ",", 
   "0.9604411001987003`", ",", "0.9605061067862767`", ",", 
   "0.9605706546697369`", ",", "0.960634749224784`", ",", 
   "0.9606983956605072`", ",", "0.9607615989316528`", ",", 
   "0.9608243639286701`", ",", "0.9608866954959545`", ",", 
   "0.9609485984325038`", ",", "0.9610100774925603`", ",", 
   "0.9610711373862428`", ",", "0.9611317827801714`", ",", 
   "0.961192018298076`", ",", "0.9612518485214028`", ",", 
   "0.9613112779876177`", ",", "0.9613703110774244`", ",", 
   "0.9614289519801456`", ",", "0.961487204839171`", ",", 
   "0.9615450737608837`", ",", "0.9616025628151593`", ",", 
   "0.9616596760358618`", ",", "0.9617164174213279`", ",", 
   "0.9617727909348464`", ",", "0.9618288005051292`", ",", 
   "0.9618844500267739`", ",", "0.9619397433563458`", ",", 
   "0.9619946842046804`", ",", "0.9620492761407455`", ",", 
   "0.9621035226995692`", ",", "0.9621574273861696`", ",", 
   "0.9622109936759425`", ",", "0.9622642250150454`", ",", 
   "0.9623171248207743`", ",", "0.9623696964819345`", ",", 
   "0.9624219433592095`", ",", "0.9624738687855184`", ",", 
   "0.9625254760775067`", ",", "0.9625767684944059`", ",", 
   "0.9626277490817344`", ",", "0.9626784208400209`", ",", 
   "0.9627287867455329`", ",", "0.9627788497505777`", ",", 
   "0.9628286127837966`", ",", "0.9628780787504575`", ",", 
   "0.9629272505327413`", ",", "0.9629761309900258`", ",", 
   "0.9630247229591641`", ",", "0.9630730292547611`", ",", 
   "0.9631210526694429`", ",", "0.9631687959741261`", ",", 
   "0.9632162619182792`", ",", "0.9632634532287646`", ",", 
   "0.9633103725176014`", ",", "0.963357022261307`", ",", 
   "0.9634034049158786`", ",", "0.963449522918679`", ",", 
   "0.963495378688656`", ",", "0.9635409746265555`", ",", 
   "0.9635863131151338`", ",", "0.963631396519367`", ",", 
   "0.9636762271866566`", ",", "0.9637208074470326`", ",", 
   "0.9637651396133549`", ",", "0.9638092259815103`", ",", 
   "0.963853068830609`", ",", "0.9638966704231751`", ",", 
   "0.9639400330053387`", ",", "0.9639831587695691`", ",", 
   "0.9640260497752147`", ",", "0.9640687080529159`", ",", 
   "0.9641111356189361`", ",", "0.9641533344751968`", ",", 
   "0.9641953066094364`", ",", "0.9642370539953677`", ",", 
   "0.9642785785928298`", ",", "0.9643198823479426`", ",", 
   "0.9643609671932564`", ",", "0.9644018350479001`", ",", 
   "0.9644424878177287`", ",", "0.9644829273954669`", ",", 
   "0.9645231556608533`", ",", "0.9645631744807803`", ",", 
   "0.9646029856984939`", ",", "0.9646425910546508`", ",", 
   "0.9646819922430343`", ",", "0.9647211909468602`", ",", 
   "0.9647601888380414`", ",", "0.9647989875773073`", ",", 
   "0.9648375888143216`", ",", "0.9648759941877955`", ",", 
   "0.9649142053256046`", ",", "0.9649522238449001`", ",", 
   "0.9649900513522218`", ",", "0.9650276894436062`", ",", 
   "0.9650651397046972`", ",", "0.9651024037108525`", ",", 
   "0.9651394830272504`", ",", "0.9651763792071888`", ",", 
   "0.9652130937392369`", ",", "0.9652496280500263`", ",", 
   "0.9652859835565082`", ",", "0.9653221616666293`", ",", 
   "0.9653581637794202`", ",", "0.9653939912850873`", ",", 
   "0.965429645565098`", ",", "0.9654651279922685`", ",", 
   "0.9655004399308497`", ",", "0.9655355827366117`", ",", 
   "0.9655705577569276`", ",", "0.9656053663308568`", ",", 
   "0.9656400097892265`", ",", "0.9656744894547126`", ",", 
   "0.9657088066418914`", ",", "0.9657429626128937`", ",", 
   "0.9657769585717445`", ",", "0.9658107957290664`", ",", 
   "0.965844475288185`", ",", "0.9658779984451983`", ",", 
   "0.9659113663890461`", ",", "0.9659445803015783`", ",", 
   "0.9659776413576208`", ",", "0.9660105507250439`", ",", 
   "0.9660433095648273`", ",", "0.9660759190311252`", ",", 
   "0.9661083802713296`", ",", "0.9661406944123146`", ",", 
   "0.966172862534513`", ",", "0.9662048857056306`", ",", 
   "0.9662367649871946`", ",", "0.9662685014346095`", ",", 
   "0.9663000960972143`", ",", "0.9663315500183375`", ",", 
   "0.9663628642353522`", ",", "0.966394039779731`", ",", 
   "0.9664250776770996`", ",", "0.9664559789472896`", ",", 
   "0.9664867446043924`"}], "}"}]], "Output",
 CellChangeTimes->{3.909352572078549*^9, 3.909352633306108*^9, 
  3.909353019457983*^9, 3.909353055940295*^9, 3.909353512037956*^9, 
  3.925251293011623*^9},
 CellLabel->
  "Out[383]=",ExpressionUUID->"1fa62ee3-c78d-4f79-9025-1b6e39af8fd0"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outrlsig1.csv\>\"", ",", "outrl", ",", "\"\<CSV\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.909352707701179*^9, 3.909352731575528*^9}, {
   3.909352782654351*^9, 3.909352800063546*^9}, {3.909353059520894*^9, 
   3.909353059682044*^9}, {3.909353515770364*^9, 3.9093535310458183`*^9}, 
   3.925251072732202*^9},
 CellLabel->
  "In[384]:=",ExpressionUUID->"ee2f93cf-45da-4bde-878f-931d89aa308e"],

Cell[BoxData["\<\"outrlsig1.csv\"\>"], "Output",
 CellChangeTimes->{
  3.9093528065253773`*^9, 3.9093530603191347`*^9, {3.90935351664404*^9, 
   3.909353531554701*^9}, 3.925251073426861*^9, 3.925251296331355*^9},
 CellLabel->
  "Out[384]=",ExpressionUUID->"c778c539-b824-42e7-93d1-8b0d29d64b9e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"{", 
   RowBox[{"outrl", "[", 
    RowBox[{"[", 
     RowBox[{"All", ",", "2"}], "]"}], "]"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9093524625683002`*^9, 3.909352470183714*^9}, {
  3.90935251988516*^9, 3.909352528067828*^9}, {3.909352575262294*^9, 
  3.9093525988464746`*^9}},
 CellLabel->
  "In[385]:=",ExpressionUUID->"c62731a7-13c4-4fa0-9f8d-897d6d101699"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 90], 0.011111111111111112`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJw1knlUzQkfh8tSg0F2WfNaS0Oypng/oo1KqzbVbd+7+2JLGrQgoWRNGEUL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      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0., 0.8227241155377613},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{484.5, Automatic},
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0., 400.}, {0.8227241155377613, 0.9664867446043924}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.909352470628819*^9, {3.909352522352715*^9, 3.909352528538056*^9}, {
   3.909352581850559*^9, 3.909352626732036*^9}, 3.925251301342823*^9},
 CellLabel->
  "Out[385]=",ExpressionUUID->"816142b6-c6c7-4a65-9626-9dfb8e97a92b"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"snrrl", "[", "sig_", "]"}], ":=", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"srl", " ", "=", " ", 
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"mu1", "*", 
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"sigma", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"2", "Pi"}], "]"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
               " ", "-", 
              RowBox[{"mu1", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                   RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                 RowBox[{"2", 
                  RowBox[{"OwenT", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
               RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
               "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                   "2"}], " ", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sig"}]}], "}"}]}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"2", "*", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"mu2", "*", 
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"mu1", "*", 
                    RowBox[{"m1", "[", "t", "]"}]}], "+", 
                    RowBox[{"mu2", "*", 
                    RowBox[{"m2", "[", "t", "]"}]}]}], ")"}], "*", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                   RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], "*", 
                    RowBox[{"sigma", "^", "2"}], "*", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "]"}]}], "+", 
                RowBox[{
                 RowBox[{"sigma", "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"2", "Pi"}], "]"}]}], 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
                 RowBox[{"Exp", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"-", "1"}], "/", "2"}], "*", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                     "2"}], 
                    RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], ")"}],
               " ", "-", 
              RowBox[{"mu2", "*", 
               RowBox[{"(", 
                RowBox[{
                 RowBox[{"Phi", "[", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                   RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], "]"}], "-", 
                 RowBox[{"2", 
                  RowBox[{"OwenT", "[", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                    RowBox[{
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
                    RowBox[{"1", "/", 
                    RowBox[{"Sqrt", "[", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}]}], 
                ")"}]}], "-", 
              RowBox[{
               RowBox[{"sigma", "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"2", "Pi"}], "]"}]}], "*", "2", 
               RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
               RowBox[{
                RowBox[{"Sqrt", "[", 
                 RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                RowBox[{"Sqrt", "[", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], 
                   RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], " ", "*", " ", 
               RowBox[{"Phi", "[", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
                 RowBox[{
                  RowBox[{"Sqrt", "[", 
                   RowBox[{"Pi", "/", "8"}], "]"}], "/", 
                  RowBox[{"Sqrt", "[", 
                   RowBox[{
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                    RowBox[{"(", 
                    RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], "]"}], 
               "*", 
               RowBox[{"Exp", "[", 
                RowBox[{
                 RowBox[{
                  RowBox[{"-", "1"}], "/", "2"}], "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
                    " ", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^",
                   "2"}], " ", "*", 
                 RowBox[{
                  RowBox[{"(", 
                   RowBox[{"Pi", "/", "8"}], ")"}], "/", 
                  RowBox[{"(", 
                   RowBox[{"1", "+", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                    RowBox[{"sigma", "^", "2"}], " ", 
                    RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}]}], 
             ")"}]}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sig"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]}], ";", " ", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"t0", ",", " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Evaluate", "[", 
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "*", 
                 RowBox[{"1", "/", 
                  RowBox[{"Sqrt", "[", "2", "]"}]}]}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "*", 
                 RowBox[{"1", "/", 
                  RowBox[{"Sqrt", "[", "2", "]"}]}]}]}], ")"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], "]"}]}], "/.", 
             "srl"}], "]"}], "/.", 
           RowBox[{"t", "\[Rule]", "t0"}]}], ")"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"t0", ",", "0.1", ",", "40", ",", "0.005"}], "}"}]}], "]"}]}], 
   ")"}]}]], "Input",
 CellChangeTimes->{{3.9094197602365637`*^9, 3.909419837178389*^9}, {
  3.909419875142661*^9, 3.9094198766414843`*^9}, {3.909419946747257*^9, 
  3.909419949864458*^9}, {3.909420681177012*^9, 3.909420682215488*^9}, {
  3.9094210206915483`*^9, 3.909421021360221*^9}},
 CellLabel->
  "In[398]:=",ExpressionUUID->"0abf92d6-261a-4f02-a50a-c98a2027ca2f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"longtab", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"sig", ",", 
      RowBox[{"snrrl", "[", "sig", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"sig", ",", "0.01", ",", "1.01", ",", "0.01"}], "}"}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.909419830742037*^9, 3.909419843060191*^9}, {
  3.909419963814876*^9, 3.909420010972857*^9}, {3.9094203817894497`*^9, 
  3.909420391799891*^9}, {3.909420661291251*^9, 3.909420697556897*^9}},
 CellLabel->
  "In[399]:=",ExpressionUUID->"e3ffe636-3666-410f-948e-fc74bf1a7fed"],

Cell[BoxData[
 InterpretationBox[
  TagBox[
   FrameBox[GridBox[{
      {
       ItemBox[
        TagBox[
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"0.01`", ",", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"0.1`", ",", "0.049925945640290514`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.10500000000000001`", ",", "0.05241443492014224`"}],
                 "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.11`", ",", "0.05490178513288568`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.115`", ",", "0.057387942979323904`"}], "}"}], ",", 
               
               RowBox[{"{", 
                RowBox[{
                "0.12000000000000001`", ",", "0.059872855281137304`"}], "}"}],
                ",", 
               RowBox[{"{", 
                RowBox[{"0.125`", ",", "0.06235646899214005`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.13`", ",", "0.06483873122892404`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.135`", ",", "0.06731958925148719`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"0.14`", ",", "0.06979899045717382`"}], "}"}], ",", 
               TemplateBox[{"7963"},
                "OutputSizeLimit`Skeleton"], ",", 
               RowBox[{"{", 
                RowBox[{"39.96`", ",", "0.9665018156573227`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.965`", ",", "0.9665033536249946`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.97`", ",", "0.9665048912551654`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.975`", ",", "0.9665064285479611`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.980000000000004`", ",", "0.9665079655035076`"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.985`", ",", "0.9665095021219308`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.99`", ",", "0.9665110384033564`"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"39.995000000000005`", ",", "0.9665125743479103`"}], 
                "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"40.`", ",", "0.9665141099557184`"}], "}"}]}], 
              "}"}]}], "}"}], ",", 
           TemplateBox[{"99"},
            "OutputSizeLimit`Skeleton"], ",", 
           RowBox[{"{", 
            RowBox[{"1.01`", ",", 
             TemplateBox[{"1"},
              "OutputSizeLimit`Skeleton"]}], "}"}]}], "}"}],
         Short[#, 5]& ],
        BaseStyle->{Deployed -> False},
        StripOnInput->False]},
      {GridBox[{
         {
          PaneBox[
           TagBox[
            TooltipBox[
             StyleBox[
              StyleBox[
               DynamicBox[ToBoxes[
                 FEPrivate`FrontEndResource[
                 "FEStrings", "sizeBriefExplanation"], StandardForm],
                ImageSizeCache->{55.44140625, {2., 7.}}],
               StripOnInput->False,
               DynamicUpdating->True,
               LineSpacing->{1, 2},
               LineIndent->0,
               LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLText",
              StripOnInput->False],
             StyleBox[
              DynamicBox[
               ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"], 
                StandardForm]], DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}, StripOnInput -> False]],
            Annotation[#, 
             Style[
              Dynamic[
               FEPrivate`FrontEndResource["FEStrings", "sizeExplanation"]], 
              DynamicUpdating -> True, LineIndent -> 0, 
              LinebreakAdjustments -> {1., 100, 0, 0, 0}, 
              LineSpacing -> {1, 2}], "Tooltip"]& ],
           Alignment->Center,
           BaselinePosition->Baseline,
           ImageSize->{Automatic, {25, Full}}], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm],
               ImageSizeCache->{49.25390625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowLess"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 399, 33952755406031144400, 5/2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm],
               ImageSizeCache->{55.44140625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowMore"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 399, 33952755406031144400, 5 2],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm],
               ImageSizeCache->{41.6015625, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeShowAll"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           
           ButtonFunction:>OutputSizeLimit`ButtonFunction[
            OutputSizeLimit`Defer, 399, 33952755406031144400, Infinity],
           Enabled->True,
           Evaluator->Automatic,
           Method->"Queued"], 
          ButtonBox[
           PaneSelectorBox[{False->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm],
               ImageSizeCache->{74.9296875, {0., 7.}}],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControl",
             StripOnInput->False], True->
            StyleBox[
             StyleBox[
              DynamicBox[ToBoxes[
                FEPrivate`FrontEndResource["FEStrings", "sizeChangeLimit"], 
                StandardForm]],
              StripOnInput->False,
              DynamicUpdating->True,
              LineSpacing->{1, 2},
              LineIndent->0,
              LinebreakAdjustments->{1., 100, 0, 0, 0}], "OSLControlActive",
             StripOnInput->False]}, Dynamic[
             CurrentValue["MouseOver"]],
            Alignment->Center,
            FrameMargins->0,
            ImageSize->{Automatic, {25, Full}}],
           Appearance->None,
           BaselinePosition->Baseline,
           ButtonFunction:>FrontEndExecute[{
              FrontEnd`SetOptions[
              FrontEnd`$FrontEnd, 
               FrontEnd`PreferencesSettings -> {"Page" -> "Advanced"}], 
              FrontEnd`FrontEndToken["PreferencesDialog"]}],
           Evaluator->None,
           Method->"Preemptive"]}
        },
        AutoDelete->False,
        FrameStyle->GrayLevel[0.85],
        GridBoxDividers->{"Columns" -> {False, {True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}}]}
     },
     DefaultBaseStyle->"Column",
     GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
     GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
     GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{1.}}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.5599999999999999]}, 
         Offset[0.27999999999999997`]}, "Rows" -> {
         Offset[0.2], 
         Offset[1.2], {
          Offset[0.4]}, 
         Offset[0.2]}}],
    BaseStyle->"OutputSizeLimit",
    FrameMargins->{{12, 12}, {0, 15}},
    FrameStyle->GrayLevel[0.85],
    RoundingRadius->5,
    StripOnInput->False],
   Deploy,
   DefaultBaseStyle->"Deploy"],
  If[33952755406031144400 === $SessionID, 
   Out[399], Message[
     MessageName[Syntax, "noinfoker"]]; Missing["NotAvailable"]; 
   Null]]], "Output",
 CellChangeTimes->{
  3.909419843564309*^9, {3.909419952984109*^9, 3.909419964537745*^9}, 
   3.909420019362492*^9, 3.909420400897233*^9, 3.909420677435594*^9, 
   3.90942073447324*^9, 3.909421088305744*^9, 3.925251786678753*^9},
 CellLabel->
  "Out[399]=",ExpressionUUID->"bd5029cf-9eb1-4ec9-82a5-b554628b462d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"learntimes", " ", "=", " ", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"el", "[", 
         RowBox[{"[", "2", "]"}], "]"}], ",", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0.8"}], "&"}], ",", "1"}], 
       "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "longtab"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.909420418203376*^9, 3.9094204304061537`*^9}, {
  3.909420517040572*^9, 3.909420614021987*^9}, {3.9094207888815536`*^9, 
  3.909420795306624*^9}},
 CellLabel->
  "In[400]:=",ExpressionUUID->"d6d63c9d-edfe-4608-b2b0-2be28caf4f34"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.01`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8001986448409275`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.02`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002001679082039`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.03`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002026717577789`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.04`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002061043166431`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.05`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002103996863058`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.060000000000000005`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002154555106311`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.06999999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002211655794291`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.08`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002274002703904`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002340121803181`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.09999999999999999`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002408370016627`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.11`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002476944846794`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.12`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002543894749122`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.13`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002607130151149`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.14`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002664435002518`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.15000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002713478740217`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.16`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.80027518285636`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.17`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.800277696351259`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.18000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002786287221303`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.19`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002777138952504`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002746806350183`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.21000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002692537605072`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.22`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.800261155330685`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.23`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002501057905904`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.24000000000000002`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002358250717037`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8002180336406838`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.26`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8001964534915769`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.27`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8001708090775833`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.28`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8001408274065648`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.29000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8001062412287321`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.8000667875739043`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.31`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.12`", ",", "0.800022208899398`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.32`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.8003410233784232`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.33`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.800286683818738`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.34`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.8002265071393494`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.35000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.8001602626869989`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.36000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.800087727673507`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.37`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.125`", ",", "0.8000086874484822`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.38`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1300000000000003`", ",", "0.800298219665705`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1300000000000003`", ",", "0.8002069075204402`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1300000000000003`", ",", "0.8001085135182124`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.41000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1300000000000003`", ",", "0.8000028576164077`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.42000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1350000000000002`", ",", "0.8002693370861924`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.43`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1350000000000002`", ",", "0.8001500592021377`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.44`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1350000000000002`", ",", "0.8000230452313758`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.14`", ",", "0.8002707719421924`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.46`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.14`", ",", "0.8001292903049497`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.47000000000000003`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.145`", ",", "0.8003639966680702`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.48000000000000004`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.145`", ",", "0.8002075968044776`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.49`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.145`", ",", "0.800042839244545`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1500000000000004`", ",", "0.8002571452837148`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.51`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1500000000000004`", ",", "0.8000768583109565`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.52`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1550000000000002`", ",", "0.80027723802985`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.53`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1550000000000002`", ",", "0.8000810996003282`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.54`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.16`", ",", "0.8002672977462632`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.55`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.16`", ",", "0.8000550421802523`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.56`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.165`", ",", "0.8002268409095746`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.5700000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1700000000000004`", ",", "0.8003915380520802`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5800000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1700000000000004`", ",", "0.800155478574959`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.59`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1750000000000003`", ",", "0.8003055467369317`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1750000000000003`", ",", "0.8000529182237692`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.61`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.18`", ",", "0.8001882523977637`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.62`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.185`", ",", "0.80031636928466`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.63`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.185`", ",", "0.8000394820415616`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.64`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.19`", ",", "0.8001527821575853`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.65`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.1950000000000003`", ",", "0.8002588495095386`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.66`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2`", ",", "0.8003576881342748`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.67`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2`", ",", "0.8000488451652391`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.68`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.205`", ",", "0.8001328723699315`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.6900000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.21`", ",", "0.8002096991368687`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.7000000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2150000000000003`", ",", "0.8002793424501075`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7100000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.22`", ",", "0.8003418220377089`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.72`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.225`", ",", "0.8003971602237758`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.73`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.225`", ",", "0.8000413928257671`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.74`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.23`", ",", "0.8000821251073544`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2350000000000003`", ",", "0.8001157940807205`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.76`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.24`", ",", "0.8001424312006733`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.77`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.245`", ",", "0.8001620698398122`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.78`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.25`", ",", "0.8001747451688488`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.79`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2550000000000003`", ",", "0.800180494041652`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2600000000000002`", ",", "0.8001793548849968`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.81`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.265`", ",", "0.8001713675929469`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.8200000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.27`", ",", "0.8001565734258116`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.8300000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2750000000000004`", ",", "0.8001350149135897`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.2800000000000002`", ",", "0.8001067357638009`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.85`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.285`", ",", "0.8000717807736035`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.86`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.29`", ",", "0.8000301957460868`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.87`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3000000000000003`", ",", "0.8003918457023617`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.88`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.305`", ",", "0.8003375735271415`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.89`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.31`", ",", "0.8002768155531378`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.315`", ",", "0.8002096207655607`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.91`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3200000000000003`", ",", "0.8001360388281029`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.92`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.325`", ",", "0.8000561200094163`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.93`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.335`", ",", "0.8003811830583455`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9400000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3400000000000003`", ",", "0.8002891849996469`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9500000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.345`", ",", "0.8001910049025865`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.9600000000000001`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.35`", ",", "0.8000866947261612`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.97`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3600000000000003`", ",", "0.8003881934653042`"}], "}"}], 
      "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.98`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.365`", ",", "0.8002722275360997`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"0.99`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.37`", ",", "0.800150290063284`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.375`", ",", "0.8000224339819594`"}], "}"}], "}"}]}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"1.01`", ",", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{"3.3850000000000002`", ",", "0.8003012474651168`"}], "}"}], 
      "}"}]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.909420552600753*^9, 3.909420614994482*^9}, 
   3.9094207548062763`*^9, 3.909420795739917*^9, 3.9094210909422417`*^9, 
   3.925251786961458*^9},
 CellLabel->
  "Out[400]=",ExpressionUUID->"5936d8a2-9dd3-4d2b-bb0b-51cdae9afbce"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"el", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"el", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"el", ",", "learntimes"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.909421780125839*^9, 3.909421838994318*^9}},
 CellLabel->
  "In[464]:=",ExpressionUUID->"1bd330da-e58a-44f5-aadf-4221042d4cad"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.01`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.02`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.03`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.04`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.05`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.060000000000000005`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.06999999999999999`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.08`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.09999999999999999`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.11`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.12`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.13`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.14`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.15000000000000002`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.16`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.18000000000000002`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.19`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.2`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.21000000000000002`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.22`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.23`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.24000000000000002`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.26`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.27`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.28`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.29000000000000004`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.3`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.31`", ",", "3.12`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.32`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.33`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.34`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.35000000000000003`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.36000000000000004`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.37`", ",", "3.125`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.38`", ",", "3.1300000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.39`", ",", "3.1300000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.4`", ",", "3.1300000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.41000000000000003`", ",", "3.1300000000000003`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.42000000000000004`", ",", "3.1350000000000002`"}], "}"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"0.43`", ",", "3.1350000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.44`", ",", "3.1350000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.45`", ",", "3.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.46`", ",", "3.14`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.47000000000000003`", ",", "3.145`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.48000000000000004`", ",", "3.145`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.49`", ",", "3.145`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5`", ",", "3.1500000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.51`", ",", "3.1500000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.52`", ",", "3.1550000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.53`", ",", "3.1550000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.54`", ",", "3.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.55`", ",", "3.16`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.56`", ",", "3.165`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5700000000000001`", ",", "3.1700000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.5800000000000001`", ",", "3.1700000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.59`", ",", "3.1750000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6`", ",", "3.1750000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.61`", ",", "3.18`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.62`", ",", "3.185`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.63`", ",", "3.185`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.64`", ",", "3.19`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.65`", ",", "3.1950000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.66`", ",", "3.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.67`", ",", "3.2`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.68`", ",", "3.205`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.6900000000000001`", ",", "3.21`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7000000000000001`", ",", "3.2150000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.7100000000000001`", ",", "3.22`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.72`", ",", "3.225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.73`", ",", "3.225`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.74`", ",", "3.23`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.75`", ",", "3.2350000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.76`", ",", "3.24`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.77`", ",", "3.245`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.78`", ",", "3.25`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.79`", ",", "3.2550000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8`", ",", "3.2600000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.81`", ",", "3.265`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8200000000000001`", ",", "3.27`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8300000000000001`", ",", "3.2750000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.8400000000000001`", ",", "3.2800000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.85`", ",", "3.285`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.86`", ",", "3.29`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.87`", ",", "3.3000000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.88`", ",", "3.305`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.89`", ",", "3.31`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9`", ",", "3.315`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.91`", ",", "3.3200000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.92`", ",", "3.325`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.93`", ",", "3.335`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9400000000000001`", ",", "3.3400000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9500000000000001`", ",", "3.345`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.9600000000000001`", ",", "3.35`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.97`", ",", "3.3600000000000003`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.98`", ",", "3.365`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.99`", ",", "3.37`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "3.375`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.01`", ",", "3.3850000000000002`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.909421825984935*^9, 3.90942183952632*^9}},
 CellLabel->
  "Out[464]=",ExpressionUUID->"8e055a27-fd65-4dab-9472-21d1c19efd8d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLinePlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"el", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"el", "[", 
       RowBox[{"[", 
        RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"el", ",", "learntimes"}], "}"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.9094207673730907`*^9, 3.9094208278447847`*^9}, {
   3.9094210376185913`*^9, 3.909421042908861*^9}, {3.9094210974465027`*^9, 
   3.909421106815522*^9}, 3.909421851019224*^9},
 CellLabel->
  "In[465]:=",ExpressionUUID->"262e18d9-647a-4619-a314-9003c522aa37"],

Cell[BoxData[
 GraphicsBox[{{}, {{}, {}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
      NCache[
       Rational[1, 72], 0.013888888888888888`]], AbsoluteThickness[1.6], 
     LineBox[CompressedData["
1:eJxdkztMVEEUhjdWztkWW4wd1tjKuZ22UmNjgpZiiy3UUthgYQONzSYmJkJi
jILGR8CoqKuAyj5Y9r00WLsz/z9nkpmEXL7dOzPn/N/ZS7fuzs6fK5VK8+M/
/7w/UblWW1zSf1NzD7bOzhfgh8Ybk8u9GxuPs+/XjR+t+vXEeDO8XzEew/iT
p9n+Z8ZSXVu4Ks+Nw3Grm8aX/WPqRVbPS+P18e7q2ivjfrjvtfGVab+2s/vf
GG+f+X/eGpdDPe+MZ8OF77N+PxjXF/2BH7N6d4zv+fIWdrN8PhmXwvqc9ZP4
es1f8CXrL/HKlm/gq3Fod3rPOLRT3cv6/6a41xUXfTmT342RR+I7t/36YYx8
qsb+tIlKYuT1U/GeK3BvYuT3y3gmDMC+MfLc1wvhYFeE8pYPjJHvofHujl+H
ij4c8/5tjPf+KPY55p84POb+GqOPI8XcxH4Sw8+Rou7YX2L4qimesd/E8FdT
nBv7r+vNUIejz8Q4rq7w4Oi3YYx8Goq+HX03FJ5jXk1jPJuKfTG/puLeOA/H
irpjnokxH8eKHGK+LcUcxHlpKXKOebcU+xx/7yeKe2P+iXHOiaKP6KOtmIvo
o63IMfpoc76jjzbnUeijw/kS+uhwfoQ+OpwXoY8u50Hoo0v/wvns0rfQR49+
hT569Cv00aMvoY8+fQl99OlH6KNPP0IfA/oR+hjQh9DHgPkLfQyZv9DHkPkL
fQyZt9DHiPkKfYyYr9DHiPkKfZwy3zL7OWWe5eI/8IDYXg==
      "]]}}, {{}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 3.1052777777777782`},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{
   "OptimizePlotMarkers" -> True, "OptimizePlotMarkers" -> True, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        Identity[
         Part[#, 1]], 
        Identity[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 1.01}, {3.1052777777777782`, 3.3850000000000002`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.909420809574667*^9, 3.9094208283381863`*^9}, {
   3.909421093271912*^9, 3.90942110723239*^9}, 3.9094218517066307`*^9},
 CellLabel->
  "Out[465]=",ExpressionUUID->"21171f91-e7b9-4be8-b872-48a7fc8fb0f5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outrllearntimes.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"el", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", 
       RowBox[{"el", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "1", ",", "1"}], "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"el", ",", "learntimes"}], "}"}]}], "]"}], ",", "\"\<CSV\>\""}],
   "]"}]], "Input",
 CellChangeTimes->{{3.909422254197452*^9, 3.9094222582718697`*^9}, {
  3.9252510562800903`*^9, 3.92525105647438*^9}},
 CellLabel->
  "In[401]:=",ExpressionUUID->"24544a4f-964c-489b-862e-aa2fae2ddcf6"],

Cell[BoxData["\<\"outrllearntimes.csv\"\>"], "Output",
 CellChangeTimes->{3.9094222597417107`*^9, 3.9252510676534357`*^9, 
  3.925251787053007*^9},
 CellLabel->
  "Out[401]=",ExpressionUUID->"31228ff2-ded1-48a7-82ee-7eae7f9364b5"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"sigo", ",", 
   RowBox[{"Evaluate", "[", 
    RowBox[{
     RowBox[{"Flatten", "[", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"snrrl", "[", "sigo", "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "0.8"}], "&"}], ",", "1"}], 
       "]"}], "]"}], "[", 
     RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sigo", ",", "0.2", ",", "0.1", ",", "0.1"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.909420039911901*^9, 3.909420072380856*^9}, {
  3.909420166934153*^9, 3.9094202852323847`*^9}, {3.9094203322777653`*^9, 
  3.909420366253551*^9}},
 CellLabel->
  "In[436]:=",ExpressionUUID->"6199d550-c787-4980-80cb-b72c8822fa24"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "ndnum", 
   "\"Encountered non-numerical value for a derivative at \\!\\(\\*RowBox[{\\\
\"t\\\"}]\\) == \\!\\(\\*RowBox[{\\\"0.`\\\"}]\\).\"", 2, 436, 421, 
   33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366660634*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"159c1e0e-6f66-4d1b-95e4-4ccd62148236"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", FractionBox[\\\"1\\\", \
SqrtBox[\\\"2\\\"]]}], \\\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"-\\\", \
FractionBox[\\\"1\\\", SqrtBox[\\\"2\\\"]]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\
\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"t\\\", \\\",\\\", \
\\\"0\\\", \\\",\\\", \\\"40\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \
\\\"}\\\"}]\\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"", 2, 436, 422, 
   33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366665092*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"54b84edb-5556-47a5-b72c-792af45c9043"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.1`\\\"}]\\) cannot be used as a variable.\"", 2, 
   436, 423, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366670596*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"64d17c37-7d92-4489-8621-9c1902e8a6d6"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", FractionBox[\\\"1\\\", \
SqrtBox[\\\"2\\\"]]}], \\\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"-\\\", \
FractionBox[\\\"1\\\", SqrtBox[\\\"2\\\"]]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.1`\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"0.1`\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\
\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"0.1`\\\", \\\",\\\", \
\\\"0\\\", \\\",\\\", \\\"40\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \
\\\"}\\\"}]\\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"", 2, 436, 424, 
   33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.9094203666741323`*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"a07c9eef-69c4-4a54-a5e1-8779153e565e"],

Cell[BoxData[
 TemplateBox[{
  "ReplaceAll", "reps", 
   "\"\\!\\(\\*RowBox[{\\\"{\\\", RowBox[{\\\"NDSolve\\\", \\\"[\\\", \
RowBox[{RowBox[{\\\"{\\\", RowBox[{RowBox[{RowBox[{\\\"m1\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", FractionBox[\\\"1\\\", \
SqrtBox[\\\"2\\\"]]}], \\\",\\\", RowBox[{RowBox[{\\\"m2\\\", \\\"[\\\", \
\\\"0\\\", \\\"]\\\"}], \\\"\[Equal]\\\", RowBox[{\\\"-\\\", \
FractionBox[\\\"1\\\", SqrtBox[\\\"2\\\"]]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m1\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m1\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}], \\\",\\\", \
RowBox[{RowBox[{SuperscriptBox[\\\"m2\\\", \\\"\[Prime]\\\", \
Rule[MultilineFunction, None]], \\\"[\\\", \\\"t\\\", \\\"]\\\"}], \\\"\
\[Equal]\\\", RowBox[{\\\"2\\\", \\\" \\\", RowBox[{\\\"(\\\", \
RowBox[{RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\
\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\
\\\"Plus\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"+\\\", RowBox[{FractionBox[\\\"1\\\
\", \\\"4\\\"], \\\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"1\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Power\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}]}], \\\"-\\\", RowBox[{FractionBox[\\\"1\\\", \\\"2\\\"], \\\
\" \\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", \
RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \
\\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\\\", \
\\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"2\\\", \\\"\[RightSkeleton]\\\
\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"m2\\\", \\\"[\\\", RowBox[{\\\"\
\[LeftSkeleton]\\\", \\\"1\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \
\\\", RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \
\\\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}]}], \\\"-\\\", \
RowBox[{RowBox[{\\\"Power\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\
\"2\\\", \\\"\[RightSkeleton]\\\"}], \\\"]\\\"}], \\\" \\\", RowBox[{\\\"Plus\
\\\", \\\"[\\\", RowBox[{\\\"\[LeftSkeleton]\\\", \\\"3\\\", \\\"\
\[RightSkeleton]\\\"}], \\\"]\\\"}]}]}], \\\")\\\"}]}]}]}], \\\"}\\\"}], \
\\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"m1\\\", \\\",\\\", \\\"m2\\\"}], \\\
\"}\\\"}], \\\",\\\", RowBox[{\\\"{\\\", RowBox[{\\\"t\\\", \\\",\\\", \
\\\"0\\\", \\\",\\\", \\\"40\\\"}], \\\"}\\\"}]}], \\\"]\\\"}], \
\\\"}\\\"}]\\) is neither a list of replacement rules nor a valid dispatch \
table, and so cannot be used for replacing.\"", 2, 436, 425, 
   33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366679779*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"5ee1f688-012a-40d8-a20c-3dab9bc5ec59"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"ReplaceAll\\\", \
\\\"::\\\", \\\"reps\\\"}], \\\"MessageName\\\"]\\) will be suppressed during \
this calculation.\"", 2, 436, 426, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366685401*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"26ec2cbc-bd0f-4734-a193-d2d691e0c222"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.2`\\\"}]\\) cannot be used as a variable.\"", 2, 
   436, 427, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.9094203666889677`*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"8edcf586-ad11-425b-a162-4980e82ac28e"],

Cell[BoxData[
 TemplateBox[{
  "NDSolve", "dsvar", 
   "\"\\!\\(\\*RowBox[{\\\"0.30000000000000004`\\\"}]\\) cannot be used as a \
variable.\"", 2, 436, 428, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366692625*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"d2fb4ba8-0b7e-483f-92ea-121bc7d317fd"],

Cell[BoxData[
 TemplateBox[{
  "General", "stop", 
   "\"Further output of \\!\\(\\*StyleBox[RowBox[{\\\"NDSolve\\\", \
\\\"::\\\", \\\"dsvar\\\"}], \\\"MessageName\\\"]\\) will be suppressed \
during this calculation.\"", 2, 436, 429, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420366697056*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"ece9265d-68ad-460f-90f2-f674aea00e30"],

Cell[BoxData[
 TemplateBox[{
  "Part", "partw", 
   "\"Part \\!\\(\\*RowBox[{\\\"1\\\"}]\\) of \\!\\(\\*RowBox[{\\\"{\\\", \
\\\"}\\\"}]\\) does not exist.\"", 2, 436, 430, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420368036724*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"cd33ef9b-7f9f-4bff-9966-fb96670ac56c"],

Cell[BoxData[
 TemplateBox[{
  "Table", "nliter", 
   "\"Non-list iterator \\!\\(\\*RowBox[{RowBox[{\\\"{\\\", \\\"}\\\"}], \\\"\
\[LeftDoubleBracket]\\\", \\\"1\\\", \\\"\[RightDoubleBracket]\\\"}]\\) at \
position \\!\\(\\*RowBox[{\\\"2\\\"}]\\) does not evaluate to a real numeric \
value.\"", 2, 436, 431, 33864426363964991828, "Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{{3.9094202495634727`*^9, 3.909420294911001*^9}, {
  3.909420336590749*^9, 3.909420368040411*^9}},
 CellLabel->
  "During evaluation of \
In[436]:=",ExpressionUUID->"03de688b-dcc1-40eb-ba3a-bbf425c43f5c"],

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{"sigo", ",", 
   RowBox[{
    RowBox[{"{", "}"}], "\[LeftDoubleBracket]", "1", 
    "\[RightDoubleBracket]"}], ",", 
   RowBox[{"{", 
    RowBox[{"sigo", ",", "0.2`", ",", "0.1`", ",", "0.1`"}], "}"}]}], 
  "]"}]], "Output",
 CellChangeTimes->{{3.909420216541883*^9, 3.909420296155261*^9}, {
  3.909420337772175*^9, 3.9094203680513372`*^9}},
 CellLabel->
  "Out[436]=",ExpressionUUID->"0fbc2b94-5202-4e57-92fd-3c7a2d700325"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.916765272058983*^9, 
  3.91676531313109*^9}},ExpressionUUID->"093a86f6-1e82-4001-9ebf-\
a164286b08dc"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0"}], "}"}]], "Output",
 CellChangeTimes->{3.9167652965961742`*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"bdb6b479-82f8-4ee7-b5d4-b226c65aaf79"]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.9167640015786552`*^9, 3.91676400930333*^9}, {
   3.91676524040983*^9, 3.91676526905716*^9}, 
   3.916765316945593*^9},ExpressionUUID->"9aff4814-06af-406f-9e76-\
3a19faf1ab2f"],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.925228531457261*^9, 
  3.925228565319559*^9}},ExpressionUUID->"a9cf23b5-cae5-4df3-b852-\
3965fef0e50d"],

Cell[CellGroupData[{

Cell["Variance", "Subsection",
 CellChangeTimes->{{3.925247860713776*^9, 
  3.925247861851556*^9}},ExpressionUUID->"4c72d379-412a-47f8-bc55-\
2e8e5cd5dbb1"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"rlm1rhs", "[", "t", "]"}], "=", 
   RowBox[{"(", 
    RowBox[{"2", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"sigma", "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"2", "Pi"}], "]"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m1", "[", "t", "]"}], " ", "sigma", " ", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
              RowBox[{"sigma", "^", "2"}], " ", 
              RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
                "2"}], 
               RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                RowBox[{"sigma", "^", "2"}], 
                RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], ")"}], " ", 
        
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], 
            "]"}]}]}], ")"}]}], "+", 
       RowBox[{"mu1", "*", 
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{"OwenT", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
            RowBox[{"1", "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                RowBox[{"sigma", "^", "2"}], " ", 
                RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}], ")"}]}]}], 
      ")"}]}], ")"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rlm2rhs", "[", "t", "]"}], "=", 
   RowBox[{"(", 
    RowBox[{"2", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"sigma", "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"2", "Pi"}], "]"}]}], 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"m2", "[", "t", "]"}], " ", "sigma", " ", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"Pi", "/", "8"}], "]"}]}], ")"}], "/", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                RowBox[{
                 RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
              RowBox[{"sigma", "^", "2"}], " ", 
              RowBox[{"Pi", "/", "8"}]}]}], "]"}]}], "*", 
          RowBox[{"Exp", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"-", "1"}], "/", "2"}], "*", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], "^", 
                "2"}], 
               RowBox[{"Pi", "/", "8"}]}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], " ", "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                RowBox[{"sigma", "^", "2"}], 
                RowBox[{"Pi", "/", "8"}]}]}], ")"}]}]}], "]"}]}], ")"}], " ", 
        
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"2", 
           RowBox[{"Phi", "[", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], " ", "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "8"}]}]}], ")"}], 
                RowBox[{"(", 
                 RowBox[{"1", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                    RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                   RowBox[{"sigma", "^", "2"}], " ", 
                   RowBox[{"Pi", "/", "4"}]}]}], ")"}]}], "]"}]}]}], 
            "]"}]}]}], ")"}]}], "+", 
       RowBox[{"mu2", "*", 
        RowBox[{"(", 
         RowBox[{"2", 
          RowBox[{"OwenT", "[", 
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                RowBox[{"m1", "[", "t", "]"}], " ", "mu1"}], " ", "+", 
               RowBox[{
                RowBox[{"m2", "[", "t", "]"}], " ", "mu2"}]}], ")"}], 
             RowBox[{
              RowBox[{"Sqrt", "[", 
               RowBox[{"Pi", "/", "8"}], "]"}], "/", 
              RowBox[{"Sqrt", "[", 
               RowBox[{"1", "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                   RowBox[{
                    RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], " ", 
                 RowBox[{"sigma", "^", "2"}], " ", 
                 RowBox[{"Pi", "/", "8"}]}]}], "]"}]}]}], ",", 
            RowBox[{"1", "/", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"m1", "[", "t", "]"}], "^", "2"}], "+", 
                  RowBox[{
                   RowBox[{"m2", "[", "t", "]"}], "^", "2"}]}], ")"}], 
                RowBox[{"sigma", "^", "2"}], " ", 
                RowBox[{"Pi", "/", "4"}]}]}], "]"}]}]}], "]"}]}], ")"}]}]}], 
      ")"}]}], ")"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.92524788241601*^9, 3.925247946868093*^9}, {
  3.925247977120509*^9, 3.92524797911217*^9}},
 CellLabel->"In[67]:=",ExpressionUUID->"17bc8c93-9c73-48aa-b13b-8ba7ccda5f3c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rlcovterms1", "[", "t", "]"}], " ", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"C11", "[", "t", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
    RowBox[{"2", 
     RowBox[{"C12", "[", "t", "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"C22", "[", "t", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.9252479544858627`*^9, 3.925248074271063*^9}, {
  3.925248301273757*^9, 3.925248301792185*^9}, {3.925248410297703*^9, 
  3.9252484427662897`*^9}, {3.92524849187291*^9, 3.925248500664318*^9}, {
  3.9252485821272173`*^9, 3.925248583007399*^9}, {3.925248655072493*^9, 
  3.9252487056565027`*^9}, {3.925249028407683*^9, 3.925249072559517*^9}, {
  3.925249728673358*^9, 3.9252497311582327`*^9}, {3.925249907328587*^9, 
  3.9252499158684397`*^9}},
 CellLabel->"In[69]:=",ExpressionUUID->"8a3d6495-050b-42cb-a896-7def59827e52"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rlcovterms2", "[", "t", "]"}], " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"C11", "[", "t", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
    RowBox[{"2", 
     RowBox[{"C12", "[", "t", "]"}], "*", 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
       RowBox[{"m1", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"C22", "[", "t", "]"}], 
     RowBox[{"D", "[", 
      RowBox[{
       RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}], ",", 
       RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.925249925368931*^9, 3.925249943711206*^9}},
 CellLabel->"In[70]:=",ExpressionUUID->"66bf3a4a-8d0c-4a59-bb40-03030070c058"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rlcovap11", "[", "t", "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"C11", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
         RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"C12", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
         RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.925249954412922*^9, 3.9252499987786083`*^9}, {
  3.925250068648518*^9, 3.925250082861416*^9}, {3.9252503656289587`*^9, 
  3.9252503681449833`*^9}},
 CellLabel->"In[71]:=",ExpressionUUID->"ae957cf7-9eac-4aad-aa5f-b26f80452146"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rlcovap12", "[", "t", "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"C11", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
         RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"C12", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
         RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"C12", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
         RowBox[{"m2", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{
       RowBox[{"C22", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm1rhs", "[", "t", "]"}], ",", 
         RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.925250100881031*^9, 3.925250119926024*^9}, {
  3.925250150910994*^9, 3.925250176417844*^9}, {3.925250217175969*^9, 
  3.925250227661439*^9}, {3.925250264179335*^9, 3.925250264381049*^9}, {
  3.9252503300839157`*^9, 3.925250350094743*^9}},
 CellLabel->"In[72]:=",ExpressionUUID->"59a0f362-2d99-4e1a-8058-249be65d4196"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rlcovap22", "[", "t", "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"2", "*", 
       RowBox[{"C12", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
         RowBox[{"m1", "[", "t", "]"}]}], "]"}]}], "+", 
      RowBox[{"2", "*", 
       RowBox[{"C22", "[", "t", "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"rlm2rhs", "[", "t", "]"}], ",", 
         RowBox[{"m2", "[", "t", "]"}]}], "]"}]}]}], ")"}], "//", 
    "Simplify"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.925250280282449*^9, 3.925250363497376*^9}},
 CellLabel->"In[73]:=",ExpressionUUID->"4df5b0ef-42a4-4dc9-a247-b5cf3149bb1a"],

Cell[BoxData[
 RowBox[{
  RowBox[{"rlsolcovar", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"NDSolve", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"m1", "[", "0", "]"}], "\[Equal]", 
          RowBox[{"1", "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"m2", "[", "0", "]"}], "\[Equal]", 
          RowBox[{
           RowBox[{"-", "1"}], "/", 
           RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
         RowBox[{
          RowBox[{"C11", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{"C12", "[", "0", "]"}], "\[Equal]", "0"}], ",", 
         RowBox[{
          RowBox[{"C22", "[", "0", "]"}], "\[Equal]", "0.1"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m1", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rlm1rhs", "[", "t", "]"}], "+", 
             RowBox[{"rlcovterms1", "[", "t", "]"}], "-", 
             RowBox[{"0.1", "*", 
              RowBox[{"m1", "[", "t", "]"}]}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"m2", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rlm2rhs", "[", "t", "]"}], "+", 
             RowBox[{"rlcovterms2", "[", "t", "]"}], "-", 
             RowBox[{"0.1", 
              RowBox[{"m2", "[", "t", "]"}]}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C11", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rlcovap11", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C11", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C12", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rlcovap12", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C12", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"C22", "'"}], "[", "t", "]"}], "\[Equal]", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"rlcovap22", "[", "t", "]"}], "-", 
             RowBox[{"2", 
              RowBox[{"C22", "[", "t", "]"}], "*", "0.1"}]}], ")"}]}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"mu1", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"mu2", "\[Rule]", 
             RowBox[{"1", "/", 
              RowBox[{"Sqrt", "[", "2", "]"}]}]}], ",", 
            RowBox[{"sigma", "\[Rule]", "sigval"}]}], "}"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"m1", ",", "m2", ",", "C11", ",", "C12", ",", "C22"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"sigval", ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "0.5", ",", " ", "0.0"}], "}"}]}], "}"}]}], "]"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.925250376884144*^9, 3.925250434235468*^9}, {
  3.925252297539249*^9, 3.925252326724676*^9}, {3.925317766559638*^9, 
  3.925317776576219*^9}, {3.9253201545898542`*^9, 3.925320188528232*^9}},
 CellLabel->
  "In[108]:=",ExpressionUUID->"3efe66af-c471-4d6f-86b7-32fcec16dcc7"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outcovtracerlsig10.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tval", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"C11", "[", "t", "]"}], "+", 
              RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
            RowBox[{"rlsolcovar", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], ",", 
   "\"\<CSV\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outcovtracerlsig05.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tval", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"C11", "[", "t", "]"}], "+", 
              RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
            RowBox[{"rlsolcovar", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], ",", 
   "\"\<CSV\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Export", "[", 
  RowBox[{"\"\<outcovtracerlsig00.csv\>\"", ",", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"tval", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"Evaluate", "[", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"C11", "[", "t", "]"}], "+", 
              RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
            RowBox[{"rlsolcovar", "[", 
             RowBox[{"[", "3", "]"}], "]"}]}], "]"}], "/.", 
          RowBox[{"t", "\[Rule]", "tval"}]}], ")"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"tval", ",", "0", ",", "40", ",", "0.1"}], "}"}]}], "]"}], ",", 
   "\"\<CSV\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.925252348466672*^9, 3.925252358974593*^9}, {
  3.925320224596066*^9, 3.925320230406228*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"968e2bdc-f1d3-46f4-b7a7-1427523e6d41"],

Cell[BoxData["\<\"outcovtracerlsig10.csv\"\>"], "Output",
 CellChangeTimes->{3.92525236101598*^9, 3.925320233476735*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"8286b1f0-bf37-4ddb-abac-4bc7ea8db096"],

Cell[BoxData["\<\"outcovtracerlsig05.csv\"\>"], "Output",
 CellChangeTimes->{3.92525236101598*^9, 3.925320233505471*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"345b2ac6-7acc-42be-bb67-c0606f813b59"],

Cell[BoxData["\<\"outcovtracerlsig00.csv\"\>"], "Output",
 CellChangeTimes->{3.92525236101598*^9, 3.9253202335198936`*^9},
 CellLabel->
  "Out[112]=",ExpressionUUID->"f0d751b0-b02c-4127-8e8b-c6c433b9b894"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C11", "[", "t", "]"}], "+", 
         RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
       RowBox[{"rlsolcovar", "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C11", "[", "t", "]"}], "+", 
         RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
       RowBox[{"rlsolcovar", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
     RowBox[{"Evaluate", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"C11", "[", "t", "]"}], "+", 
         RowBox[{"C22", "[", "t", "]"}]}], ")"}], "/.", 
       RowBox[{"rlsolcovar", "[", 
        RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "40"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.925250452257142*^9, 3.925250452460243*^9}, {
  3.925317790679964*^9, 3.925317807171549*^9}, {3.925320200618484*^9, 
  3.9253202034124107`*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"2b1f8f57-98e9-4273-ae17-4f46093dd349"],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    TagBox[
     {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVV3c8Ft4XNqKM7JW9d/Ye9573fRHSErKzR0l2KmWGSGZIQnYUJSrzays7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       "]]},
     Annotation[#, "Charting`Private`Tag$1225315#1"]& ], 
    TagBox[
     {RGBColor[0.880722, 0.611041, 0.142051], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVl3c01o8Xx42oUPbM3h5778+9PAhZGZUSEQlZIbtkRhlJCNlK35KGhpGV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       "]]},
     Annotation[#, "Charting`Private`Tag$1225315#2"]& ], 
    TagBox[
     {RGBColor[0.560181, 0.691569, 0.194885], AbsoluteThickness[1.6], Opacity[
      1.], LineBox[CompressedData["
1:eJwVkGk41Asbh82gbJ0wydIxhsFoZElFJM/DX0mWhCLajK0QEZ2k0tjGZMlI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       "]]},
     Annotation[#, "Charting`Private`Tag$1225315#3"]& ]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{0, 40}, {0., 0.050100321680901505`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.925250452867634*^9, {3.925317791826748*^9, 3.925317807673901*^9}, 
   3.925320204385899*^9},
 CellLabel->
  "Out[109]=",ExpressionUUID->"d4f78941-e319-4466-a5c9-3deb2ef6517f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1080., 592.5},
WindowMargins->{{645, Automatic}, {Automatic, 205.5}},
Magnification:>1. Inherited,
FrontEndVersion->"12.2 for Linux x86 (64-bit) (December 12, 2020)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b7c41909-5e4a-4d78-a7c0-4d246c148900"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 416, 11, 29, "Input",ExpressionUUID->"ab7aa9d6-d032-4f70-9390-16be15a00838"],
Cell[CellGroupData[{
Cell[999, 35, 167, 3, 69, "Chapter",ExpressionUUID->"4c0c8a55-b48d-4c0c-b2fe-f815c3ce33b8"],
Cell[CellGroupData[{
Cell[1191, 42, 36859, 925, 366, "Input",ExpressionUUID->"e7b7c3f3-f16e-4cad-abd3-918435c3b65c"],
Cell[38053, 969, 8877, 240, 93, "Output",ExpressionUUID->"d2549795-7f16-499d-b964-bba71c6b4ad5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[46967, 1214, 1795, 54, 44, "Input",ExpressionUUID->"9d7b5d07-0931-4ea8-b921-cfbfca82be73"],
Cell[48765, 1270, 1024, 32, 47, "Output",ExpressionUUID->"7dc07ded-3d81-4581-a98a-19336356192d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[49826, 1307, 43451, 1067, 369, "Input",ExpressionUUID->"fa9af152-7ad4-4b78-9e83-45b68265940c"],
Cell[93280, 2376, 2392, 64, 67, "Output",ExpressionUUID->"1bb37764-3a17-450e-8d36-db8912793999"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[95721, 2446, 230, 4, 69, "Chapter",ExpressionUUID->"00d84e8e-0c64-4609-907d-2dc86eff17ec"],
Cell[CellGroupData[{
Cell[95976, 2454, 43658, 1068, 368, "Input",ExpressionUUID->"2fa32f83-73b3-46dd-9d37-cf93d889c4f4"],
Cell[139637, 3524, 25322, 611, 252, "Output",ExpressionUUID->"f8e749b1-a75d-4f9c-8ee1-b0f695e3c978"]
}, Open  ]],
Cell[164974, 4138, 15291, 408, 568, "Input",ExpressionUUID->"be4a7bc1-934e-439f-9e77-c16b1bb856f7"],
Cell[180268, 4548, 7584, 229, 277, "Input",ExpressionUUID->"2944b6cb-92d0-450e-a86d-275beae0cc79"],
Cell[CellGroupData[{
Cell[187877, 4781, 336, 7, 29, "Input",ExpressionUUID->"37ec219e-aa95-4bca-930f-bc9d9c34739d"],
Cell[188216, 4790, 662, 15, 55, "Output",ExpressionUUID->"1806131e-481d-497a-a84d-afaca04ca683"]
}, Open  ]],
Cell[CellGroupData[{
Cell[188915, 4810, 454, 12, 29, "Input",ExpressionUUID->"317d36eb-82cc-431e-ba5e-96ebbff014e3"],
Cell[189372, 4824, 107668, 1769, 254, "Output",ExpressionUUID->"1fe886b2-24d2-4ef8-8706-18e920081eae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[297077, 6598, 22061, 532, 541, "Input",ExpressionUUID->"64d29de2-d632-453c-9412-f5e77c9dc3ec"],
Cell[319141, 7132, 8306, 146, 347, "Output",ExpressionUUID->"71b3e6fc-9cbe-462c-8a34-0eb7ebab11f7"],
Cell[327450, 7280, 386, 8, 22, "Message",ExpressionUUID->"390cb659-161c-41e4-a9df-8ae7369b443e"],
Cell[327839, 7290, 2573, 38, 61, "Message",ExpressionUUID->"b695c284-eb85-42a8-8513-dacdf709c938"],
Cell[330415, 7330, 345, 7, 22, "Message",ExpressionUUID->"14acf31c-62e1-4281-af0a-0a067d7b4f92"],
Cell[330763, 7339, 2640, 39, 61, "Message",ExpressionUUID->"d0a08707-0f7e-4013-9eaf-bb81d4eb527a"],
Cell[333406, 7380, 343, 7, 22, "Message",ExpressionUUID->"c2477990-77a0-4faf-af86-b88c9bf7aca2"],
Cell[333752, 7389, 2252, 34, 38, "Message",ExpressionUUID->"e9bc7073-e30b-4d6b-96e3-dc93ab6ff3fa"],
Cell[336007, 7425, 421, 8, 22, "Message",ExpressionUUID->"13606502-bce4-4814-ab5d-04734f19a583"],
Cell[336431, 7435, 340, 7, 22, "Message",ExpressionUUID->"06a0f183-a99d-4420-b740-719713ca5b00"],
Cell[336774, 7444, 419, 8, 22, "Message",ExpressionUUID->"ec7fb7d0-edc1-422d-90b3-5eb6ade45349"]
}, Open  ]],
Cell[CellGroupData[{
Cell[337230, 7457, 619, 17, 29, "Input",ExpressionUUID->"6c5f920e-bd4b-49e9-b1bb-3f828ea36327"],
Cell[337852, 7476, 4733, 97, 239, "Output",ExpressionUUID->"c602745a-0803-4c9e-8c6d-da015890aed8"]
}, Open  ]],
Cell[342600, 7576, 1466, 39, 29, "Input",ExpressionUUID->"b899abae-237f-488c-aec5-49574481b316"],
Cell[CellGroupData[{
Cell[344091, 7619, 307, 7, 29, "Input",ExpressionUUID->"cadac2df-1515-4779-b04c-054e177416f2"],
Cell[344401, 7628, 12254, 207, 529, "Output",ExpressionUUID->"1fa62ee3-c78d-4f79-9025-1b6e39af8fd0"]
}, Open  ]],
Cell[CellGroupData[{
Cell[356692, 7840, 452, 9, 29, "Input",ExpressionUUID->"ee2f93cf-45da-4bde-878f-931d89aa308e"],
Cell[357147, 7851, 295, 5, 33, "Output",ExpressionUUID->"c778c539-b824-42e7-93d1-8b0d29d64b9e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[357479, 7861, 424, 10, 29, "Input",ExpressionUUID->"c62731a7-13c4-4fa0-9f8d-897d6d101699"],
Cell[357906, 7873, 6077, 117, 310, "Output",ExpressionUUID->"816142b6-c6c7-4a65-9626-9dfb8e97a92b"]
}, Open  ]],
Cell[363998, 7993, 22063, 533, 500, "Input",ExpressionUUID->"0abf92d6-261a-4f02-a50a-c98a2027ca2f"],
Cell[CellGroupData[{
Cell[386086, 8530, 593, 14, 29, "Input",ExpressionUUID->"e3ffe636-3666-410f-948e-fc74bf1a7fed"],
Cell[386682, 8546, 11426, 285, 140, "Output",ExpressionUUID->"bd5029cf-9eb1-4ec9-82a5-b554628b462d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[398145, 8836, 822, 23, 29, "Input",ExpressionUUID->"d6d63c9d-edfe-4608-b2b0-2be28caf4f34"],
Cell[398970, 8861, 18294, 613, 364, "Output",ExpressionUUID->"5936d8a2-9dd3-4d2b-bb0b-51cdae9afbce"]
}, Open  ]],
Cell[CellGroupData[{
Cell[417301, 9479, 494, 14, 29, "Input",ExpressionUUID->"1bd330da-e58a-44f5-aadf-4221042d4cad"],
Cell[417798, 9495, 7733, 209, 199, "Output",ExpressionUUID->"8e055a27-fd65-4dab-9472-21d1c19efd8d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[425568, 9709, 673, 17, 29, "Input",ExpressionUUID->"262e18d9-647a-4619-a314-9003c522aa37"],
Cell[426244, 9728, 2241, 53, 240, "Output",ExpressionUUID->"21171f91-e7b9-4be8-b872-48a7fc8fb0f5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[428522, 9786, 672, 18, 29, "Input",ExpressionUUID->"24544a4f-964c-489b-862e-aa2fae2ddcf6"],
Cell[429197, 9806, 230, 4, 33, "Output",ExpressionUUID->"31228ff2-ded1-48a7-82ee-7eae7f9364b5"]
}, Open  ]],
Cell[CellGroupData[{
Cell[429464, 9815, 803, 22, 29, "Input",ExpressionUUID->"6199d550-c787-4980-80cb-b72c8822fa24"],
Cell[430270, 9839, 498, 11, 22, "Message",ExpressionUUID->"159c1e0e-6f66-4d1b-95e4-4ccd62148236"],
Cell[430771, 9852, 5309, 76, 61, "Message",ExpressionUUID->"54b84edb-5556-47a5-b72c-792af45c9043"],
Cell[436083, 9930, 439, 10, 22, "Message",ExpressionUUID->"64d17c37-7d92-4489-8621-9c1902e8a6d6"],
Cell[436525, 9942, 5320, 76, 61, "Message",ExpressionUUID->"a07c9eef-69c4-4a54-a5e1-8779153e565e"],
Cell[441848, 10020, 5309, 76, 61, "Message",ExpressionUUID->"5ee1f688-012a-40d8-a20c-3dab9bc5ec59"],
Cell[447160, 10098, 533, 11, 22, "Message",ExpressionUUID->"26ec2cbc-bd0f-4734-a193-d2d691e0c222"],
Cell[447696, 10111, 441, 10, 22, "Message",ExpressionUUID->"8edcf586-ad11-425b-a162-4980e82ac28e"],
Cell[448140, 10123, 453, 10, 22, "Message",ExpressionUUID->"d2fb4ba8-0b7e-483f-92ea-121bc7d317fd"],
Cell[448596, 10135, 531, 11, 22, "Message",ExpressionUUID->"ece9265d-68ad-460f-90f2-f674aea00e30"],
Cell[449130, 10148, 468, 10, 22, "Message",ExpressionUUID->"cd33ef9b-7f9f-4bff-9966-fb96670ac56c"],
Cell[449601, 10160, 605, 12, 22, "Message",ExpressionUUID->"03de688b-dcc1-40eb-ba3a-bbf425c43f5c"],
Cell[450209, 10174, 472, 12, 33, "Output",ExpressionUUID->"0fbc2b94-5202-4e57-92fd-3c7a2d700325"]
}, Open  ]],
Cell[CellGroupData[{
Cell[450718, 10191, 151, 3, 29, "Input",ExpressionUUID->"093a86f6-1e82-4001-9ebf-a164286b08dc"],
Cell[450872, 10196, 1230, 18, 75, "Output",ExpressionUUID->"bdb6b479-82f8-4ee7-b5d4-b226c65aaf79"]
}, Open  ]],
Cell[452117, 10217, 224, 4, 29, "Input",ExpressionUUID->"9aff4814-06af-406f-9e76-3a19faf1ab2f"],
Cell[452344, 10223, 152, 3, 29, "Input",ExpressionUUID->"a9cf23b5-cae5-4df3-b852-3965fef0e50d"],
Cell[CellGroupData[{
Cell[452521, 10230, 156, 3, 54, "Subsection",ExpressionUUID->"4c72d379-412a-47f8-bc55-2e8e5cd5dbb1"],
Cell[452680, 10235, 10293, 275, 411, "Input",ExpressionUUID->"17bc8c93-9c73-48aa-b13b-8ba7ccda5f3c"],
Cell[462976, 10512, 1427, 33, 71, "Input",ExpressionUUID->"8a3d6495-050b-42cb-a896-7def59827e52"],
Cell[464406, 10547, 1035, 27, 71, "Input",ExpressionUUID->"66bf3a4a-8d0c-4a59-bb40-03030070c058"],
Cell[465444, 10576, 863, 23, 29, "Input",ExpressionUUID->"ae957cf7-9eac-4aad-aa5f-b26f80452146"],
Cell[466310, 10601, 1356, 36, 29, "Input",ExpressionUUID->"59a0f362-2d99-4e1a-8058-249be65d4196"],
Cell[467669, 10639, 759, 21, 29, "Input",ExpressionUUID->"4df5b0ef-42a4-4dc9-a247-b5cf3149bb1a"],
Cell[468431, 10662, 5029, 130, 71, "Input",ExpressionUUID->"3efe66af-c471-4d6f-86b7-32fcec16dcc7"],
Cell[CellGroupData[{
Cell[473485, 10796, 2596, 70, 71, "Input",ExpressionUUID->"968e2bdc-f1d3-46f4-b7a7-1427523e6d41"],
Cell[476084, 10868, 203, 3, 33, "Output",ExpressionUUID->"8286b1f0-bf37-4ddb-abac-4bc7ea8db096"],
Cell[476290, 10873, 203, 3, 33, "Output",ExpressionUUID->"345b2ac6-7acc-42be-bb67-c0606f813b59"],
Cell[476496, 10878, 205, 3, 33, "Output",ExpressionUUID->"f0d751b0-b02c-4127-8e8b-c6c433b9b894"]
}, Open  ]],
Cell[CellGroupData[{
Cell[476738, 10886, 1252, 35, 29, "Input",ExpressionUUID->"2b1f8f57-98e9-4273-ae17-4f46093dd349"],
Cell[477993, 10923, 24394, 425, 235, "Output",ExpressionUUID->"d4f78941-e319-4466-a5c9-3deb2ef6517f"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

